set more off
capt log close

log using "C:\Documents and Settings\alebleb\Desktop\replication_files\table3", replace
use "C:\Documents and Settings\alebleb\Desktop\replication_files\pwt61&wdi_75.dta", clear

/**************************************GOVERNMENT SPENDING***********************/

ivreg2 grgdpw grgdpw2 y* ccountry* (grgdpw1 lgov1 dlgov1  lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3), bw(2) ro 
abar, lags(2)
test lgov1=dlgov1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0


/**************************************TRADE***********************/
ivreg2 grgdpw grgdpw2 y* ccountry* (grgdpw1 ltrade1 dltrade1 lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3), bw(2) ro 
abar, lags(2)
test ltrade1=dltrade1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0


/**************************************INFLATION***********************/
ivreg2 grgdpw grgdpw2 y* ccountry*  (grgdpw1 linfl1 dlinfl1 lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3), bw(2) ro 
abar, lags(2)
test linfl1=dlinfl1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0


/**************************************RELATIVE PRICE OF INVESTMENT***********************/
ivreg2 grgdpw grgdpw2 y* ccountry* (grgdpw1 lrelprinv1 dlrelprinv1  lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 /*
*/lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3 lrelprinv2 lrelprinv3 lrelprinv4), bw(2) ro 
abar, lags(2)
test lrelprinv1=dlrelprinv1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0



/**************************************TOT GROWTH***********************/
by country: gen totgrowth4=l.totgrowth3
ivreg2 grgdpw grgdpw2 y* ccountry* (grgdpw1 totgrowth1 dtotgrowth1 lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 /*
*/ lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3 totgrowth2 totgrowth3 totgrowth4 lrelprinv2 lrelprinv3), bw(2) ro fwl(ccountry*)
abar, lags(2)
test totgrowth1=dtotgrowth1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0


/**************************************PRIVATE CREDIT***********************/
ivreg2 grgdpw grgdpw2 y* ccountry* (grgdpw1 lprcredit1 dlprcredit1 lki1 dlki1=  grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 /*
*/ lki4 lki5 lki6 lgov2 lgov3 ltrade2 ltrade3 linfl2 linfl3 lprcredit2 lprcredit3 lprcredit4), bw(2) ro fwl(ccountry*)
abar, lags(2)
test lprcredit1=dlprcredit1=0
test lki1=dlki1=0
scalar define g=_b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir g
testnl _b[lki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0
scalar define lev=_b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])
scalar dir lev
testnl _b[dlki1]/(1-_b[grgdpw1]-_b[grgdpw2])=0

log close
