ALLOCATE 0 5000
open data c:\data\growth\cointg_71.xls
DATA(FOR=XLS,ORG=COLS)
compute Nsecs = 71
compute Tperiods = 41
compute mlag =  3
compute yestrend =0
compute m = 1
dec vec[series] datavec(m+1)
set datavec(1) = vlrgdpw
set datavec(2) = vbwd





clear x y z
compute unbal = 0
dec vec Tvec(Nsecs)

linreg vlrgdpw
# constant  vbwd


                   *** MAIN SOURCE CODE ***

display ' '
display '      Currently computing panel statistics. Please wait. '
display ' '


dec rect tab(10,7)
dec vec muvec(7) vivec(7)

compute tab = $
|| 8.62, 60.75, -6.02, 31.27, -1.73, $
   0.93, -9.05, 35.98, -2.03, 0.66 $
| 11.754, 104.546, -9.495, 57.610, -2.177, $
  0.964, -12.938, 51.49, -2.453, 0.618 $
| 15.197, 151.094, -13.256, 81.772, -2.576, $
  0.923, -16.888, 67.123, -2.827, 0.585 $
| 18.910, 190.661, -17.163, 99.331,-2.930, $
  0.843, -20.841, 81.835, -3.157, 0.560 $
| 22.715, 231.864, -21.013, 119.546, -3.241, $
  0.800, -24.775, 98.278, -3.452, 0.553 $
| 26.603, 270.451, -24.944, 134.341, -3.531, $
  0.750, -28.720, 113.131, -3.726, 0.542 $
| 30.457, 293.431, -28.795, 144.615, -3.795, $
0.685, -32.538, 126.059, -3.976, 0.525 ||

if yestrend == 1
{
compute tab = $
||17.86, 101.68, -10.54, 39.52, -2.29, $
   0.66, -13.65, 50.91, -2.53, 0.56 $
| 21.162, 160.249, -14.011, 64.219, -2.648, $
  0.690, -17.359, 66.387, -2.872, 0.555 $
| 24.556, 198.167, -17.600, 83.815, -2.967, $
  0.686, -21.116, 81.832, -3.179, 0.548 $
| 28.046, 239.425, -21.287, 103.905, -3.262, $
  0.688, -24.930, 97.362, -3.464, 0.543 $
| 31.738, 276.997, -25.130, 124.613, -3.545, $
  0.686, -28.849, 113.145, -3.737, 0.538 $
| 35.537, 310.982, -28.981, 138.227, -3.806, $
  0.654, -32.716, 127.989, -3.986, 0.530 $
| 39.231, 348.217, -32.756, 154.378, -4.047, $
  0.638, -36.494, 140.756, -4.217, 0.518 ||
}
end if

compute muvec = ||tab(m,1), tab(m,3), tab(m,5), tab(m,5), tab(m,7), $
tab(m,9), tab(m,9)||

compute vivec = ||tab(m,2), tab(m,4), tab(m,6), tab(m,6), tab(m,8), $
tab(m,10), tab(m,10)||

dec vec[series] dvec(m+1) rvec(m+1)
dec vec[real] N(Nsecs) D(Nsecs) N2(Nsecs) D2(Nsecs) N3(Nsecs) D3(Nsecs) $
  Nadf(Nsecs) Dadf(Nsecs) Sadf(Nsecs) S(Nsecs) N3adf(Nsecs) D3adf(Nsecs) $
  S3adf(Nsecs) S3(Nsecs) V3(Nsecs) DD(Nsecs) DD3(Nsecs) NN3(Nsecs) $
  GR(Nsecs) GP(Nsecs) GA(Nsecs) statvec(7) Tval


               ***  SETUP DATA VARIABLES ***

do J=1,Nsecs

if unbal == 0 ; {; compute Tvec(J) = Tperiods; }
if unbal == 1 ; {; compute Tperiods = fix(Tvec(J)); }

overlay Tvec(1) with Tval(J-1)

  do K=1,M+1
    set dvec(K) 1 Tperiods = datavec(K)(T+fix(%sum(Tval)))
    diff dvec(K) 2 Tperiods rvec(K)
  end do K
  set trend = T


         *** DO INDIVIDUAL COINTEGRATING REGRESSIONS ***

 linreg(noprint) dvec(1) 1 Tperiods ehat
    # dvec(2) to dvec(m+1) constant

 if yestrend == 1
    {; linreg(noprint) dvec(1) 1 Tperiods ehat
    # dvec(2) to dvec(m+1) constant trend ;}

 linreg(noprint) rvec(1) 2 Tperiods nhat
    # rvec(2) to rvec(m+1)

  diff ehat / dehat


                *** COMPUTE ADF LAG TRUNCATIONS ***

do llags=mlag,1,-1
   linreg(noprint) dehat 2 Tperiods
   # ehat{1} dehat{1 to llags}
   compute mtratio = %beta(llags+1)/sqrt(%seesq*%xx(llags+1,llags+1))
   if abs(mtratio) >= 1.64
   { ; compute maxlag=llags ; break ; }
end do llags

   if llags == 1 .and. abs(mtratio) < 1.64
   { ; compute maxlag = 0 ; }

*display 'J=' J 'maxlag=' maxlag


            *** COMPUTE INDIVIDUAL MEMBER SAMPLE STATS ***

if maxlag == 0
{
   linreg(noprint) dehat 2 Tperiods
   # ehat{1}
}
if maxlag >= 1
{
   linreg(noprint) dehat 2 Tperiods
     # ehat{1} dehat{1 to maxlag}
}
    cmoment(noprint,lastreg) 2 Tperiods
     compute nadf(J) = %cmom(maxlag+2,1)
     compute dadf(J) = 1.0/%xx(1,1)
     compute sadf(J) = %seesq

   linreg(noprint) dehat 2 Tperiods uresid
    # ehat{1}
     compute d(J) = 1.0/%xx(1,1)
   cmoment(noprint,lastreg) 2 Tperiods
     compute n(J) = %cmom(2,1)
   mcov(damp=1.0,lags=maxlag) 2 Tperiods
    # uresid
     compute su = sqrt(%seesq*%ndf/(Tperiods-1.0))
     compute st = sqrt(%cmom(1,1)/(Tperiods-1.0))
     compute lambda = 0.5*(st**2-su**2)
     compute S(J) = st**2

   mcov(damp=1.0,lags=maxlag,noprint) 2 Tperiods
    # nhat
      compute L11var = (1.0/(Tperiods-1.0))*%CMOM(1,1)


          *** CONSTRUCT NUMERATOR AND DENOMINATOR TERMS ***

compute N2(J) = N(J) - lambda*Tperiods
compute D2(J) = D(J)
compute N3(J) = N2(J)/L11var
compute D3(J) = D2(J)/L11var
compute N3adf(J) = Nadf(J)/L11var
compute D3adf(J) = Dadf(J)/L11var
compute S3adf(J) = Sadf(J)/L11var
compute S3(J) = S(J)/L11var
compute DD(J) = D(J)*S(J)
compute DD3(J) = D3(J)*S3(J)

compute GR(J) = N2(J)/D2(J)
compute GP(J) = N2(J)/sqrt(D2(J)*S(J))
compute GA(J) = Nadf(J)/sqrt(Dadf(J)*Sadf(J))

end do J


        *** CONSTRUCT PANEL COINTEGRATION STATISTICS ***

if unbal == 0 ; {; ewise Tvec(I) = Tperiods ; } ; end if
ewise V3(I) = D3(I)*(1.0/(Tvec(I)**2))
ewise NN3(I) = N3(I)*(Tvec(I)/1.0)
ewise GR(I) = GR(I)*(Tvec(I)/1.0)

compute statvec(1) = sqrt(Nsecs**3)/%sum(V3)
compute statvec(2) = (sqrt(Nsecs)*%sum(NN3))/%sum(D3)
compute statvec(3) = %sum(N3)/(sqrt(%sum(D3)*%sum(S3)/Nsecs))
compute statvec(4) = %sum(N3adf)/(sqrt(%sum(D3adf)*(%sum(S3adf)/Nsecs)))
compute statvec(5) = %sum(GR)/sqrt(Nsecs)
compute statvec(6) = %sum(GP)/sqrt(Nsecs)
compute statvec(7) = %sum(GA)/sqrt(Nsecs)

do K=1,7
compute statvec(K) = (statvec(K) - muvec(K)*sqrt(Nsecs))/sqrt(vivec(K))
end do K


                *** DISPLAY RESULTS ***

display '                           RESULTS:'
display '         ******************************************** '
display '               panel v-stat     = ' statvec(1)
display '               panel rho-stat   = ' statvec(2)
display '               panel pp-stat    = ' statvec(3)
display '               panel adf-stat   = ' statvec(4)
display ' '
display '               group rho-stat   = ' statvec(5)
display '               group pp-stat    = ' statvec(6)
display '               group adf-stat   = ' statvec(7)
display ' '
if unbal == 0
{
display '        Nsecs =' Nsecs ', Tperiods =' Tperiods $
                    ', no. regressors =' M
}
if unbal == 1
display '        Nsecs =' Nsecs ', Tperiods = (unbalanced)' $
                    ', no. regressors =' M

display '         ******************************************** '
end


















