******************************************************
* CREATES TABLE D8 IN 'FUELING CONFLICT' 
* Our results vs. Nunn and Qian (2014)
*****************************************************


************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set maxiter 50 // max NR iterations for one estimation
parallel setclusters 15, force // set to number of cores, alters seeds used
set more off, perm

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 


** code for generic bootstrap program

* drop current prog in memory
cap program drop threestep_boot

* define 3-step bootstrap and tempvars neeeed
program threestep_boot, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric) initrends]
	tempname aa bb cc ss conv
	local initial_trends `initrends'
	
	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* allow going back to bilateral structure
	preserve
	
	* re-define panel
	gegen newpair = group(newid don_id)
	xtset newpair year
	
	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year, fe
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys newid year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by newid year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode == doncode[1] // works like collapse
	drop don_id doncode

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* balance sample to max Ti
	by newid (year): gen Ti = _N  
	qui sum Ti // fine now
	keep if Ti== `r(max)'

	* generate lagged conflict states
	gen lagged_o_2 = (l.`y' == 1)
	gen lagged_o_3 = (l.`y' == 2)
	gen lagged_o_4 = (l.`y' == 3)

	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	* note that we have few initial war observations, thus in some 
	* bootstrap iterations init_4 will be empty (not found)
	drop init_1 init // will always be omitted, second is tempvar

	* generate T-2 year dummies 
	qui sum year
	// first year will always drop out given condition below, second year is base
	forv i = `=r(min)+2'(1)`=r(max)' {
		gen y_`i' =  (year==`i')
	}

	if "`initial_trends'" != "" {
		gen init2_X_year = init_2*year
		gen init3_X_year = init_3*year
		gen init4_X_year = init_4*year	
		local init_first init_2 init_3 init_4 init2_X_year init3_X_year init4_X_year
		local trends_main init2_X_year init3_X_year init4_X_year
	}
	
	
	* generate z_i vector including controls and IV
	local allvars agghatnetoda_gdp `z' // put other control vars here 
	foreach var in `allvars' {
		by newid (year): gegen m_`var' = mean(`var') if year>inityear 
		qui sum year // not first year, gets omitted otherwise
		forv i = `=r(min)+1'(1)`r(max)' {
			by newid (year): gen temp_z_`var'_`i' = `var' if year==`i'
			by newid (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
			drop  temp_z_`var'_`i'
		}
	}
	
	* panel set and sort again
	*xtset 

	*** first stage, equiv to xtreg, fe
	reg aggnetoda_gdp agghatnetoda_gdp `z' `init_first' m_* i.year if year>inityear, cluster(newid)
	local F_IV = (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
	local NT = e(N) // needed for later to replace "wrong N" from bilateral sample
	local N = e(N_clust)
	predict nu, resid 
		
	* generate averages and nu_i vector
	by newid (year): gegen m_nu = mean(nu) if year>inityear 
	sum year // not first year
	forv t = `=r(min)+1'(1)`r(max)' {
		by newid (year): gen temp_z_nu_`t' = nu if year==`t'
		by newid (year): gegen z_nu_`t' = max(temp_z_nu_`t')
		replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
		drop  temp_z_nu_`t'
	}

	*** main model
	* constrained version: averages plus first few years separately
	* nb: include controls after nu ...
	xtoprobit `y' aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4 lagged_o_2-lagged_o_4 init_2-init_4 ///
		`z' `trends_main' m_* z_*_197* i.year  if year>inityear, i(newid) 
	
	* save convergence results, needed for BS rejections	
	scalar `conv' = e(converged)
	
	* save coefficients
	mat `aa' = e(b)
	* count relevant output size
	local n1 : word count `z'
	local n2 : word count `trends_main'

	mat `aa' = `aa'[1,1..`=11+`n1'+`n2''] // save only relevant coef, not CRE stuff

	* post the main coefficients as e-class results
	ereturn post `aa' 
	
	* return e-class recording if iteration converged
	ereturn scalar converged =`conv'
	ereturn scalar NgT = `NT'
	ereturn scalar Ng = `N'	
	ereturn scalar T = `=`NT'/`N''	
	ereturn scalar F_IV = `F_IV'	

	* go back to bilateral structure
	restore
end

* drop current prog in memory
cap program drop twostep_boot_binary

* define 3-step bootstrap and tempvars neeeed
program twostep_boot_binary, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric)]
	tempname aa bb cc ss conv

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	drop init_1 init // will always be omitted, second is tempvar
	
	* generate z_i vector including controls and IV
	local allvars agghatnetoda_gdp `z' // put other control vars here 
	foreach var in `allvars' {
		by newid (year): gegen m_`var' = mean(`var') if year>inityear 
		qui sum year // not first year, gets omitted otherwise
		forv i = `=r(min)+1'(1)`r(max)' {
			by newid (year): gen temp_z_`var'_`i' = `var' if year==`i'
			by newid (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
			drop  temp_z_`var'_`i'
		}
	}
	
	* panel set and sort again
	*xtset 

	*** first stage, equiv to xtreg, fe
	reg aggnetoda_gdp agghatnetoda_gdp `z'  m_* i.year if year>inityear, cluster(newid)
	local F_IV = (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
	local NT = e(N) // needed for later to replace "wrong N" from bilateral sample
	local N = e(N_clust)
	predict nu, resid 
		
	* generate averages and nu_i vector
	by newid (year): gegen m_nu = mean(nu) if year>inityear 
	sum year // not first year
	forv t = `=r(min)+1'(1)`r(max)' {
		by newid (year): gen temp_z_nu_`t' = nu if year==`t'
		by newid (year): gegen z_nu_`t' = max(temp_z_nu_`t')
		replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
		drop  temp_z_nu_`t'
	}

	*** main model
	* constrained version: averages plus first few years separately
	* nb: include controls after nu ...
	xtoprobit `y' aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.l.`y' 1.l.`y' init_* ///
		`z' m_* z_*_197* i.year  if year>inityear, i(newid) 
	
	* save convergence results, needed for BS rejections	
	scalar `conv' = e(converged)
	
	* save coefficients
	mat `aa' = e(b)
	* count relevant output size
	local n1 : word count `z'
	local n2 : word count `trends_main'

	mat `aa' = `aa'[1,1..`=11+`n1'+`n2''] // save only relevant coef, not CRE stuff

	* post the main coefficients as e-class results
	ereturn post `aa' 
	
	* return e-class recording if iteration converged
	ereturn scalar converged = `conv'
	ereturn scalar NgT = `NT'
	ereturn scalar Ng = `N'	
	ereturn scalar T = `=`NT'/`N''	
	ereturn scalar F_IV = `F_IV'	
	
	* clean up
	drop nu init_* m_* z_*
	drop touse inityear

end

* drop current prog in memory
cap program drop twostep_boot

* define 3-step bootstrap and tempvars neeeed
program twostep_boot, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric)]
	tempname aa bb cc ss conv

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* generate lagged conflict states
	gen lagged_o_2 = (l.`y' == 1)
	gen lagged_o_3 = (l.`y' == 2)
	gen lagged_o_4 = (l.`y' == 3)
	
	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	drop init_1 init // will always be omitted, second is tempvar
	
	* generate z_i vector including controls and IV
	local allvars agghatnetoda_gdp `z' // put other control vars here 
	foreach var in `allvars' {
		by newid (year): gegen m_`var' = mean(`var') if year>inityear 
		qui sum year // not first year, gets omitted otherwise
		forv i = `=r(min)+1'(1)`r(max)' {
			by newid (year): gen temp_z_`var'_`i' = `var' if year==`i'
			by newid (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
			drop  temp_z_`var'_`i'
		}
	}
	
	* panel set and sort again
	*xtset 

	*** first stage, equiv to xtreg, fe
	reg aggnetoda_gdp agghatnetoda_gdp `z'  m_* i.year if year>inityear, cluster(newid)
	local F_IV = (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
	local NT = e(N) // needed for later to replace "wrong N" from bilateral sample
	local N = e(N_clust)
	predict nu, resid 
		
	* generate averages and nu_i vector
	by newid (year): gegen m_nu = mean(nu) if year>inityear 
	sum year // not first year
	forv t = `=r(min)+1'(1)`r(max)' {
		by newid (year): gen temp_z_nu_`t' = nu if year==`t'
		by newid (year): gegen z_nu_`t' = max(temp_z_nu_`t')
		replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
		drop  temp_z_nu_`t'
	}

	*** main model
	* constrained version: averages plus first few years separately
	* nb: include controls after nu ...
	xtoprobit `y' aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4 lagged_o_2-lagged_o_4 init_2-init_4 ///
		`z' m_* z_*_197* i.year  if year>inityear, i(newid) 
	
	* save convergence results, needed for BS rejections	
	scalar `conv' = e(converged)
	
	* save coefficients
	mat `aa' = e(b)
	* count relevant output size
	local n1 : word count `z'
	local n2 : word count `trends_main'

	mat `aa' = `aa'[1,1..`=11+`n1'+`n2''] // save only relevant coef, not CRE stuff

	* post the main coefficients as e-class results
	ereturn post `aa' 
	
	* return e-class recording if iteration converged
	ereturn scalar converged = `conv'
	ereturn scalar NgT = `NT'
	ereturn scalar Ng = `N'	
	ereturn scalar T = `=`NT'/`N''	
	ereturn scalar F_IV = `F_IV'	
	
	* clean up
	drop nu init_* m_* z_*
	drop touse inityear
	drop lagged_o_*

end

** open bilateral data
use ./data/AiC_all_bootstrap.dta, clear
xtset recdon_id year

* set the seed only once, parallel will take it from there
set seed 10101

* start timer
timer clear 1
timer on 1

*** Column 1: baseline on NQ sample

merge m:1 rec_id year using ./data/NQ_BGLS, keepusing(instrument) gen(nq_m) 
keep if nq_m == 3

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
threestep_boot, y(conflict_pb) z(ln_pop ln_gdp)
drop newid

local F = e(F_IV)	
local T = e(T)
local Ng = e(Ng)
local NT = e(NgT)

* call bootstrap in parallel and store all results
eststo: parallel bs, nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current): threestep_boot, /// 
	y(conflict_pb) z(ln_pop ln_gdp) 
di r(pll_seeds) // for log file

estadd scalar F_IV = `=`F''
estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''


*** Column 2: NQ results our method as binary

use ./data/NQ_BGLS, clear

*** swap NQ variables with ours 
drop aggnetoda_gdp agghatnetoda_gdp
ren wheat_aid aggnetoda_gdp
xtreg aggnetoda_gdp instrument ln_pop ln_gdp i.year, fe cluster(rec_id)
predict agghatnetoda_gdp, xbu

replace conflict_pb = 0 if conflict_pb == 1
replace conflict_pb = 1 if conflict_pb == 2 | conflict_pb == 3

* clean up
drop m_* y_* z_*
drop init* lagged_* 

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot_binary, y(conflict_pb) z(ln_pop ln_gdp)
drop newid

local F = e(F_IV)	
local T = e(T)
local Ng = e(Ng)
local NT = e(NgT)


* call bootstrap in parallel and store all results
eststo: parallel bs, nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot_binary, ///
	y(conflict_pb) z(ln_pop ln_gdp)

di r(pll_seeds) // for log file

estadd scalar F_IV = `=`F''
estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''

*** Column 3: NQ results our measure

use ./data/NQ_BGLS, clear

*** swap NQ variables with ours 
drop aggnetoda_gdp agghatnetoda_gdp
ren wheat_aid aggnetoda_gdp
xtreg aggnetoda_gdp instrument ln_pop ln_gdp i.year, fe cluster(rec_id)
predict agghatnetoda_gdp, xbu

* clean up
drop m_* y_* z_*
drop init* lagged_* 

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
twostep_boot, y(conflict_pb) z(ln_pop ln_gdp)
drop newid

local F = e(F_IV)	
local T = e(T)
local Ng = e(Ng)
local NT = e(NgT)

* call bootstrap in parallel and store all results
eststo: parallel bs, nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, /// 
	y(conflict_pb) z(ln_pop ln_gdp) 
	
di r(pll_seeds) // for log file

estadd scalar F_IV = `=`F''
estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''

* Create output using estimated coefs and bootstrapped SEs
esttab using ./tables/Table_D8.tex, replace  tex star(* 0.10 ** 0.05 *** 0.01) ///
	se  nobaselevels b(4) se(4)  ///
	stats(F_IV NgT T Ng, fmt(a3) labels("First stage F-stat" "Observations" "Years" "Countries")) 
esttab using ./tables/Table_D8.rtf, replace rtf star(* 0.10 ** 0.05 *** 0.01) ///
	se nobaselevels b(4) se(4)  ///


* total time taken
timer off 1
timer list 1
