******************************************************
* CREATES TABLE D5 IN 'FUELING CONFLICT' 
* Adding bilateral controls
*****************************************************


************** preliminaries **************
clear *
set more off, perm

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 


** open bilateral data
use ./data/AiC_all_bilateralrobust.dta, clear
xtset recdon_id year

*** Column 1: partial out UNGA agreement
eststo: xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon agree2un i.year, fe vce(cluster recdon_id)

*** Column 2: partial out bilateral trade
eststo: xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon ln_import_don ln_import_rec i.year, fe vce(cluster recdon_id)

*** Column 3: partial out bilateral trade and UNGA
eststo:  xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon agree2un ln_import_don ln_import_rec i.year, fe vce(cluster recdon_id)

* Create output using estimated coefs and bootstrapped SEs
esttab using ./tables/Table_D5.tex, replace  tex  star(* 0.10 ** 0.05 *** 0.01) drop(*.year) ///
	se nobaselevels noomitted b(4) se(4)  ///
	stats(r2_w N Tbar N_g, fmt(a3) labels("Within-R2" "Observations" "Avg. Years" "Dyads")) 
esttab using ./tables/Table_D5.rtf, replace rtf  star(* 0.10 ** 0.05 *** 0.01) drop(*.year) ///
	se nobaselevels noomitted b(4) se(4)  ///
	stats(r2_w N Tbar N_g, fmt(a3) labels("Within-R2" "Observations" "Avg. Years" "Dyads")) 

esttab,  star(* 0.10 ** 0.05 *** 0.01) drop(*.year) ///
	se nobaselevels noomitted b(4) se(4)  ///
	stats(r2_w N Tbar N_g, fmt(a3) labels("Within-R2" "Observations" "Avg. Years" "Dyads")) 
