******************************************************
* CREATES TABLE D2 IN 'FUELING CONFLICT' 
* Alternate measures of conflict
*****************************************************


************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set maxiter 50 // max NR iterations for one estimation
parallel setclusters 30, force // set to number of cores, alters seeds used
set more off, perm

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 

** code for generic bootstrap programs

* drop current prog in memory
cap program drop threestep_boot

* define 3-step bootstrap and tempvars, 4 valued outcomes
program threestep_boot, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric) initrends]
	tempname aa bb cc ss conv
	local initial_trends `initrends'

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* allow going back to bilateral structure
	preserve
	
	* re-define panel
	gegen newpair = group(newid don_id)
	xtset newpair year
	
	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year, fe
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys newid year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by newid year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode == doncode[1] // works like collapse
	drop don_id doncode

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* balance sample to max Ti
	by newid (year): gen Ti = _N  
	qui sum Ti // fine now
	keep if Ti== `r(max)'

	* generate lagged conflict states
	gen lagged_o_2 = (l.`y' == 1)
	gen lagged_o_3 = (l.`y' == 2)
	gen lagged_o_4 = (l.`y' == 3)

	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	* note that we have few initial war observations, thus in some 
	* bootstrap iterations init_4 will be empty (not found)
	drop init_1 init // will always be omitted, second is tempvar

	* generate T-2 year dummies 
	qui sum year
	// first year will always drop out given condition below, second year is base
	forv i = `=r(min)+2'(1)`=r(max)' {
		gen y_`i' =  (year==`i')
	}

	if "`initial_trends'" != "" {
		gen init2_X_year = init_2*year
		gen init3_X_year = init_3*year
		gen init4_X_year = init_4*year	
		local init_first init_2 init_3 init_4 init2_X_year init3_X_year init4_X_year
		local trends_main init2_X_year init3_X_year init4_X_year
	}
	
	
	* generate z_i vector including controls and IV
	local allvars agghatnetoda_gdp `z' // put other control vars here 
	foreach var in `allvars' {
		by newid (year): gegen m_`var' = mean(`var') if year>inityear 
		qui sum year // not first year, gets omitted otherwise
		forv i = `=r(min)+1'(1)`r(max)' {
			by newid (year): gen temp_z_`var'_`i' = `var' if year==`i'
			by newid (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
			drop  temp_z_`var'_`i'
		}
	}
	
	* panel set and sort again
	*xtset 

	*** first stage, equiv to xtreg, fe
	reg aggnetoda_gdp agghatnetoda_gdp `z' `init_first' m_* y_1977-y_2010 if year>inityear, cluster(newid)
	local NT = e(N) // needed for later to replace "wrong N" from bilateral sample
	local N = e(N_clust)
	predict nu, resid 
	
	* generate averages and nu_i vector
	by newid (year): gegen m_nu = mean(nu) if year>inityear 
	sum year // not first year
	forv t = `=r(min)+1'(1)`r(max)' {
		by newid (year): gen temp_z_nu_`t' = nu if year==`t'
		by newid (year): gegen z_nu_`t' = max(temp_z_nu_`t')
		replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
		drop  temp_z_nu_`t'
	}

	*** main model
	* constrained version: averages plus first few years separately
	* nb: include controls after nu ...
	xtoprobit `y' aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4 lagged_o_2-lagged_o_4 init_2-init_4 ///
		`z' `trends_main' m_* z_*_197* y_1977-y_2010  if year>inityear, i(newid) 
	
	* save convergence results, needed for BS rejections	
	scalar `conv' = e(converged)
	
	* save coefficients
	mat `aa' = e(b)
	* count relevant output size
	local n1 : word count `z'
	local n2 : word count `trends_main'

	mat `aa' = `aa'[1,1..`=11+`n1'+`n2''] // save only relevant coef, not CRE stuff

	* estimate APEs on transition probabilities
	
	* initialize APE matrix 
	mat `bb' = J(4,4,.)

	* collect each effect one by one, analytic derivatives in expression()
	* SEs not needed, force to avoid Stata not knowing how to deal with sigma_u

	* on p0 continuation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
			margins, expression((-_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[1,1] = r(b)

	* on p0-p1 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[1,2] = r(b)
	
	* on p0-p2 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[1,3] = r(b) 
	
	* on p0-p3 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[1,4] = r(b)
		
	* on p1-p0 de-escalation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[2,1] = r(b)
	
	* on p1 continuation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[2,2] = r(b)

	* on p1-p2 escalation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[2,3] = r(b) 
	
	* on p1-p3 escalation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[2,4] = r(b)
	
	* on p2-p0 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		replace lagged_o_4 = 0 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[3,1] = r(b)

	* on p2-p1 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[3,2] = r(b)

	* on p2 continuation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[3,3] = r(b)

	* on p2-p3 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[3,4] = r(b)
	
	* on p3-p0 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 1 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_4#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[4,1] = r(b)

	* on p3-p1 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 1 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_4#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[4,2] = r(b)
	
	* on p3-p2 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 1 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_4#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[4,3] = r(b) 

	* on p3 continuation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 1 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_4#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[4,4] = r(b)
	
	*** now single transitions
	
	mat `cc' = J(1,4,.)
	
	* on p0 escalation to all 0<j<=J
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,1] = r(b)
	
	
	* on p1 escalation to all 1<j<=J
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,2] = r(b)

	* on p2 deescalation to all 0<=j<2
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		replace lagged_o_4 = 0 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,3] = r(b)

	* on p3 deescalation to all 0<=j<J
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		replace lagged_o_4 = 1 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_4#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut3:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,4] = r(b)
	
	* post the main coefficients as e-class results
	ereturn post `aa' 
	
	* post APEs as p_ij's as e-class scalars
	forv i = 0(1)3 {
		forv j = 0(1)3 {
			ereturn scalar p_`i'`j'=`bb'[`=`i'+1',`=`j'+1']
		}
	}
	
	* post other probs (all above / below)
	ereturn scalar p_0a=`cc'[1,1]
	ereturn scalar p_1a=`cc'[1,2]
	ereturn scalar p_2b=`cc'[1,3]
	ereturn scalar p_3b=`cc'[1,4]

	* return e-class recording if iteration converged
	ereturn scalar converged =`conv'
	ereturn scalar NgT = `NT'
	ereturn scalar Ng = `N'	
	ereturn scalar T = `=`NT'/`N''	

	* go back to bilateral structure
	restore
end


* drop current prog in memory
cap program drop threestep_boot_3valued

* define 3-step bootstrap and tempvars, 3 valued outcomes
program threestep_boot_3valued, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric) initrends]
	tempname aa bb cc ss conv
	local initial_trends `initrends'

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* allow going back to bilateral structure
	preserve
	
	* re-define panel
	gegen newpair = group(newid don_id)
	xtset newpair year
	
	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year, fe
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys newid year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by newid year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode == doncode[1] // works like collapse
	drop don_id doncode

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* balance sample to max Ti
	by newid (year): gen Ti = _N  
	qui sum Ti // fine now
	keep if Ti== `r(max)'

	* generate lagged conflict states
	gen lagged_o_2 = (l.`y' == 1)
	gen lagged_o_3 = (l.`y' == 2)

	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	drop init_1 init // will always be omitted, second is tempvar

	* generate T-2 year dummies 
	qui sum year
	// first year will always drop out given condition below, second year is base
	forv i = `=r(min)+2'(1)`=r(max)' {
		gen y_`i' =  (year==`i')
	}
	
	* generate z_i vector including controls and IV
	local allvars agghatnetoda_gdp `z' // put other control vars here 
	foreach var in `allvars' {
		by newid (year): gegen m_`var' = mean(`var') if year>inityear 
		qui sum year // not first year, gets omitted otherwise
		forv i = `=r(min)+1'(1)`r(max)' {
			by newid (year): gen temp_z_`var'_`i' = `var' if year==`i'
			by newid (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
			drop  temp_z_`var'_`i'
		}
	}
	
	* panel set and sort again
	*xtset 

	*** first stage, equiv to xtreg, fe
	reg aggnetoda_gdp agghatnetoda_gdp `z' `init_first' m_* y_1977-y_2010 if year>inityear, cluster(newid)
	local NT = e(N) // needed for later to replace "wrong N" from bilateral sample
	local N = e(N_clust)
	predict nu, resid 

	* generate averages and nu_i vector
	by newid (year): gegen m_nu = mean(nu) if year>inityear 
	sum year // not first year
	forv t = `=r(min)+1'(1)`r(max)' {
		by newid (year): gen temp_z_nu_`t' = nu if year==`t'
		by newid (year): gegen z_nu_`t' = max(temp_z_nu_`t')
		replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
		drop  temp_z_nu_`t'
	}

	*** main model
	* constrained version: averages plus first few years separately
	* nb: include controls after nu ...
	xtoprobit `y' aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		lagged_o_2-lagged_o_3 init_2-init_3 ///
		`z' `trends_main' m_* z_*_197* y_1977-y_2010  if year>inityear, i(newid) 
	
	* save convergence results, needed for BS rejections	
	scalar `conv' = e(converged)
	
	* save coefficients
	mat `aa' = e(b)
	* count relevant output size
	local n1 : word count `z'
	local n2 : word count `trends_main'

	mat `aa' = `aa'[1,1..`=8+`n1'+`n2''] // save only relevant coef, not CRE stuff

	* estimate APEs on transition probabilities
	
	* initialize APE matrix 
	mat `bb' = J(3,3,.)

	* collect each effect one by one, analytic derivatives in expression()
	* SEs not needed, force to avoid Stata not knowing how to deal with sigma_u

	* on p0 continuation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
			margins, expression((-_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[1,1] = r(b)
	
	
	* on p0-p1 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[1,2] = r(b)
	
	* on p0-p2 escalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[1,3] = r(b)
	
	* on p1-p0 de-escalation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[2,1] = r(b)
	
	* on p1 continuation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[2,2] = r(b)
	
	* on p1-p2 escalation
		replace lagged_o_2 = 1 
		replace lagged_o_3 = 0 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_2#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[2,3] = r(b)
	
	* on p2-p0 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[3,1] = r(b)
	
	* on p2-p1 deescalation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			[ normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))  - ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2))) ] ) force nose
		mat `bb'[3,2] = r(b)
	
	* on p2 continuation
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1 
		margins, expression(((_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `bb'[3,3] = r(b)
	
	
	*** now single transitions
	mat `cc' = J(1,2,.)
	
	* on p0 escalation to all 0<j<=J
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 0 
		margins, expression((_b[aggnetoda_gdp]/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut1:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,1] = r(b)
	
	* on p3 deescalation to all 0<=j<J
		replace lagged_o_2 = 0 
		replace lagged_o_3 = 1
		margins, expression((-(_b[aggnetoda_gdp]+_b[1.lagged_o_3#c.aggnetoda_gdp])/sqrt(1 + e(sigma_u)^2)) * ///
			normalden(((_b[cut2:_cons] - xb())/sqrt(1 + e(sigma_u)^2)))) force nose
		mat `cc'[1,2] = r(b)
	
	* Post the main coefficients as e-class results
	ereturn post `aa' 
	
	* post apes as transition matrix
	forv i = 0(1)2{
		forv j = 0(1)2 {
			ereturn scalar p_`i'`j'=`bb'[`=`i'+1',`=`j'+1']
		}
	}
	* post other probs
	ereturn scalar p_0a=`cc'[1,1]
	ereturn scalar p_2b=`cc'[1,2]

	* important for BS
	ereturn scalar converged =`conv'
	ereturn scalar NgT = `NT'
	ereturn scalar Ng = `N'	
	ereturn scalar T = `=`NT'/`N''	

	* go back to bilateral structure
	restore
end


** open bilateral data
use ./data/AiC_all_bootstrap.dta, clear
xtset recdon_id year

** generate additional conflict measures 
* regular UCDP-PRIO measure
gen conflict_clas = 0
replace conflict_clas = 1 if conflict_pb == 2
replace conflict_clas = 2 if conflict_pb == 3
* tab this
gen conflict_23 = conflict_pb
replace conflict_23 = 2 if conflict_pb == 3
tab conflict_23 conflict_pb

* set the seed only once, parallel will take it from there
set seed 10101

* start timer
timer clear 1
timer on 1

*** Column 1: baseline

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui threestep_boot, y(conflict_ter) z(ln_pop ln_gdp) 
drop newid

local T = e(T)
local Ng = e(Ng)
local NT = e(NgT)
	
* call bootstrap in parallel and store all results
eststo: parallel bs,  ///
	exp(_b p_00=e(p_00) p_01=e(p_01) p_02=e(p_02) p_03=e(p_03) ///
	p_10=e(p_10) p_11=e(p_11) p_12=e(p_12) p_13=e(p_13) ///
	p_20=e(p_20) p_21=e(p_21) p_22=e(p_22) p_23=e(p_23) ///
	p_30=e(p_30) p_31=e(p_31) p_32=e(p_32) p_33=e(p_33) ///
	p_0a=e(p_0a) p_1a=e(p_1a) p_2b=e(p_2b) p_3b=e(p_3b)) ///
	nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current): threestep_boot, y(conflict_ter) z(ln_pop ln_gdp) 

di r(pll_seeds) // for log file

estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''

*** Column 2: Conflict_23

* clear current panel setting
xtset, clear

* call bootstrap in parallel and store all results
eststo: parallel bs,  ///
	exp(_b p_00=e(p_00) p_01=e(p_01) p_02=e(p_02)  ///
	p_10=e(p_10) p_11=e(p_11) p_12=e(p_12)  ///
	p_20=e(p_20) p_21=e(p_21) p_22=e(p_22)  ///
	p_0a=e(p_0a) p_2b=e(p_2b)) ///
	nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current): threestep_boot_3valued, y(conflict_23) z(ln_pop ln_gdp) 
	
di r(pll_seeds) // for log file

* NT, N & T will remain the same, no need to update local

estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''
	
*** Column 3: Conflict (classical measure)

* can re-use 3 levels version from above
* careful, have to manually format output to fit 4 outcome scheme

* clear current panel setting
xtset, clear

* call bootstrap in parallel and store all results
eststo: parallel bs,  ///
	exp(_b p_00=e(p_00) p_01=e(p_01) p_02=e(p_02)  ///
	p_10=e(p_10) p_11=e(p_11) p_12=e(p_12)  ///
	p_20=e(p_20) p_21=e(p_21) p_22=e(p_22)  ///
	p_0a=e(p_0a) p_2b=e(p_2b)) ///
	nowarn reps($reps) reject(e(converged)==0) cluster(rec_id) ///
	idcluster(newid) randtype(current):threestep_boot_3valued, y(conflict_clas) z(ln_pop ln_gdp) 

di r(pll_seeds) // for log file

* NT, N & T will remain the same, no need to update local

estadd scalar Ng = `=`Ng''
estadd scalar T = `=`T''
estadd scalar NgT = `=`Ng''*`=`T''
	
* Create output using estimated coefs and bootstrapped SEs
esttab using ./tables/Table_D2.tex, replace  tex star(* 0.10 ** 0.05 *** 0.01) ///
	se  drop(_eq2:) nobaselevels b(4) se(4)  ///
	stats(NgT T Ng, fmt(a3) labels("Observations" "Years" "Countries")) 
esttab using ./tables/Table_D2.rtf, replace rtf star(* 0.10 ** 0.05 *** 0.01) ///
	se drop(_eq2:) nobaselevels b(4) se(4)  ///
	stats(NgT T Ng, fmt(a3) labels("Observations" "Years" "Countries")) 

* total time taken
timer off 1
timer list 1
