******************************************************
* CREATES TABLE D1 IN 'FUELING CONFLICT' 
* Robustness: Different linear estimation schemes
*****************************************************


************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set more off, perm
************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 



* open country-level data
use ./data/balance_sample28, clear

* mark the sample to use and drop rest 
mark touse
markout touse conflict_pb aggnetoda_gdp agghatnetoda_gdp ln_gdp ln_pop 
drop if !touse

* reset xt to panel bootstrap handle
xtset rec_id year
	
* balance sample to max Ti
by rec_id (year): gen Ti = _N  
qui sum Ti // fine now
keep if Ti== `r(max)'

* generate lagged conflict states
gen lagged_o_2 = (l.conflict_pb == 1)
gen lagged_o_3 = (l.conflict_pb == 2)
gen lagged_o_4 = (l.conflict_pb == 3)

* generate initial year var and initial state dummies
bys rec_id: egen inityear = min(year)  
gen initcondtemp = conflict_pb if year==inityear
bys rec_id: egen init = max(initcondtemp)
drop initcondtemp
qui tab init, gen(init_)  
drop init_1 init // will always be omitted, second is tempvar

* generate T-2 year dummies 
qui sum year
// first year will always drop out given condition below, second year is base
forv i = `=r(min)+2'(1)`=r(max)' {
	gen y_`i' =  (year==`i')
}
		
*** start estimating the linear models		
		
* set seed and clear results from memory
set seed 10101
estimates clear
	
*** FE OLS 	
eststo: xtreg conflict_pb aggnetoda_gdp ln_gdp ln_pop lagged_o_2-lagged_o_4 ///
		y_1977-y_2010 if year>inityear, fe cluster(rec_id)
		
* now linear CF model
program twostep_linearCRE, eclass
	
	xtset newid year

	xtreg aggnetoda_gdp agghatnetoda_gdp ln_gdp ln_pop y_1977-y_2010 if year>inityear, fe
	predict nu, e 

	xtreg conflict_pb  aggnetoda_gdp nu ln_gdp ln_pop lagged_o_2-lagged_o_4 ///
		y_1977-y_2010 if year>inityear, fe 	

	drop nu 	
end		
		
*** FE OLS with CF		

xtset, clear
eststo: bootstrap _b, reps($reps) cluster(rec_id) idcluster(newid): twostep_linearCRE

*** FE 2SLS		
	
eststo: xtivreg conflict_pb (aggnetoda_gdp=agghatnetoda_gdp) ln_gdp ln_pop lagged_o_2-lagged_o_4 ///
		y_1977-y_2010 if year>inityear, fe i(rec_id)  vce(cluster rec_id) 
		
*** FE OLS with dynamics

eststo: xtreg conflict_pb  aggnetoda_gdp  lagged_o_2-lagged_o_4 ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4  ///
		ln_gdp ln_pop y_1977-y_2010 if year>inityear, fe i(rec_id) vce(cluster rec_id) 
		
* now linear CF model with dynamics
cap program drop twostep_linearCRE_dyn
program twostep_linearCRE_dyn, eclass
	
	xtset newid year

	xtreg aggnetoda_gdp agghatnetoda_gdp ln_gdp ln_pop y_1977-y_2010 if year>inityear, fe
	predict nu, e 

	xtreg conflict_pb  aggnetoda_gdp nu ln_gdp ln_pop lagged_o_2-lagged_o_4 ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4 y_1977-y_2010 if year>inityear, fe i(newid) 
	
	drop nu 	
end		

*** FE OLS with CF and dynamics	

xtset, clear
eststo: bootstrap _b, reps($reps) cluster(rec_id) idcluster(newid): twostep_linearCRE_dyn

*** FE 2SLS with dynamics		
	
gen inter_2 = c.aggnetoda_gdp#1.lagged_o_2 
gen inter_3 = c.aggnetoda_gdp#1.lagged_o_3 
gen inter_4 = c.aggnetoda_gdp#1.lagged_o_4 

eststo: xtivreg conflict_pb  (aggnetoda_gdp inter_2-inter_4 = ///
		agghatnetoda_gdp c.agghatnetoda_gdp#1.lagged_o_2 ///
		c.agghatnetoda_gdp#1.lagged_o_3 c.agghatnetoda_gdp#1.lagged_o_4 ) ///
		lagged_o_2-lagged_o_4 ln_gdp ln_pop ///
		y_1977-y_2010 if year>1975, fe i(rec_id) vce(cluster rec_id)
		
*** output everything at once
		
esttab using ./tables/Table_D1.rtf, replace rtf se  drop(y_* _cons)  nobaselevels  b(4) se(4)  star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N N_clust, fmt(a3) labels("Observations" "Countries")) ///
	 mtitles("FE-OLS" "CRE-CF" "FE-2SLS" "FE-OLS" "CRE-CF" "FE-2SLS")

esttab using ./tables/Table_D1.tex, tex replace se  drop(y_* _cons)  nobaselevels  b(4) se(4)   star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N N_clust, fmt(a3) labels("Observations" "Countries")) ///
	 mtitles("FE-OLS" "CRE-CF" "FE-2SLS" "FE-OLS" "CRE-CF" "FE-2SLS")
	 
esttab, se  drop(y_* _cons)  nobaselevels  b(4) se(4)   star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N N_clust, fmt(a3) labels("Observations" "Countries")) ///
	 mtitles("FE-OLS" "CRE-CF" "FE-2SLS" "FE-OLS" "CRE-CF" "FE-2SLS")
