******************************************************
* CREATES TABLE C1 IN 'FUELING CONFLICT' 
* First stage with additional controls
*****************************************************


************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
parallel setclusters 30, force // set to number of cores, alters seeds used
set more off, perm


************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 


* tests if data exists, creates it if not
capture confirm file ./data/AiC_all_bootstrap_frobust.dta
di _rc // for logfile
if _rc==601 {
  
	use ./data/AiC_analysis_28.dta, clear 
	sort recdon_id year

	* they are donors
	drop if rec == "Korea"
	drop if rec == "Slovenia"

	* take care of pol systems
	gen frac_ukc = 0
	replace frac_ukc = frac if don == "United States" | don == "Canada" | don == "United Kingdom"
	gen gfrac = govfrac
	replace gfrac = 0 if don == "United States" | don == "Canada" | don == "United Kingdom"
	
	* add fdidata
	merge m:1 reccode year using "./data/processed/fdi.dta"
	drop if _merge==2
	drop _merge

	* main measure
	replace netoda_gdp = (netoda/pwt7_gdp_cUS)*100

	* keep only what is important
	keep conflict_pb netoda_gdp prob_recddon gfrac frac_ukc /// 
	ln_pop ln_gdp  Idealpoint openc fdi_gdp ///
	recdon_id rec_id don_id reccode doncode year

	save ./data/AiC_all_bootstrap_frobust.dta, replace

}
* eo prelims

** code for generic bootstrap program

* drop current prog in memory
cap program drop twostep_boot

* define bootstrap for first stages
program twostep_boot, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric) initrends]
	tempname aa bb cc ss conv
	local initial_trends `initrends'

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* allow going back to bilateral structure
	preserve
	
	* re-define panel
	gegen newpair = group(newid don_id)
	xtset newpair year
	
	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year, fe
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys newid year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by newid year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode == doncode[1] // works like collapse
	drop don_id doncode

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* balance sample to max Ti
	by newid (year): gen Ti = _N  
	qui sum Ti // fine now
	keep if Ti== `r(max)'

	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	* note that we have few initial war observations, thus in some 
	* bootstrap iterations init_4 will be empty (not found)
	drop init_1 init // will always be omitted, second is tempvar

	if "`initial_trends'" != "" {
		gen init2_X_year = init_2*year
		gen init3_X_year = init_3*year
		gen init4_X_year = init_4*year	
		local init_first init_2 init_3 init_4 init2_X_year init3_X_year init4_X_year
		local trends_main init2_X_year init3_X_year init4_X_year
	}
	
	*** first stage, equiv to xtreg, fe
	*reg aggnetoda_gdp agghatnetoda_gdp `z' `init_first' m_* y_1977-y_2010 if year>inityear 
	xtreg aggnetoda_gdp agghatnetoda_gdp `z' `trends_main' i.year if year>inityear, fe cluster(rec_id) 
	
	* go back to bilateral structure
	restore
end

** open bilateral data
use ./data/AiC_all_bootstrap_frobust.dta, clear

* set the seed only once, parallel will take it from there
set seed 10101

* start timer
timer clear 1
timer on 1

*** Column (1)

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb) z(ln_gdp ln_pop Idealpoint) 
drop newid
	
local Tbar = e(Tbar)
local N_g = e(N_g)
local NT = `Tbar'*`N_g'
local r2_w = e(r2_w)

* call bootstrap in parallel and store all results
eststo: parallel bs, reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, y(conflict_pb) z(ln_gdp ln_pop Idealpoint)  
di r(pll_seeds)

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`Tbar''
estadd scalar Ng = `=`N_g''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2_w''
	
*** Column (2)

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb) z(ln_gdp ln_pop openc) 
drop newid
	
local Tbar = e(Tbar)
local N_g = e(N_g)
local NT = `Tbar'*`N_g'
local r2_w = e(r2_w)

* call bootstrap in parallel and store all results
eststo: parallel bs, reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, y(conflict_pb) z(ln_gdp ln_pop openc)  
di r(pll_seeds) // for logfile

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`Tbar''
estadd scalar Ng = `=`N_g''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2_w''


*** Column (3)

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb) z(ln_gdp ln_pop fdi_gdp) 
drop newid
	
local Tbar = e(Tbar)
local N_g = e(N_g)
local NT = `Tbar'*`N_g'
local r2_w = e(r2_w)

* call bootstrap in parallel and store all results
eststo:  parallel bs, reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, y(conflict_pb) z(ln_gdp ln_pop fdi_gdp)  
di r(pll_seeds) // for logfile

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`Tbar''
estadd scalar Ng = `=`N_g''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2_w''

*** Column (3)

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb) z(ln_gdp ln_pop fdi_gdp Idealpoint openc fdi_gdp) 
drop newid
	
local Tbar = e(Tbar)
local N_g = e(N_g)
local NT = `Tbar'*`N_g'
local r2_w = e(r2_w)

* call bootstrap in parallel and store all results
eststo:  parallel bs, reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, y(conflict_pb) z(ln_gdp ln_pop Idealpoint openc fdi_gdp)  
di r(pll_seeds) // for logfile

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`Tbar''
estadd scalar Ng = `=`N_g''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2_w''

* output all regressions
esttab using ./tables/Table_C1.tex, replace  tex star(* 0.10 ** 0.05 *** 0.01) ///
	se drop(*.year)  nobaselevels b(4) se(4) ///
	stats(F r2w NgT Ng T, fmt(a3) labels("Within-R2" "F-stat IV" "$ N \times T $" "$ N $" "$ T $")) 
esttab using ./tables/Table_C1.rtf, replace rtf  star(* 0.10 ** 0.05 *** 0.01) ///
	se drop(*.year) nobaselevels b(4) se(4) ///
	stats(F r2w NgT Ng T, fmt(a3) labels("Within-R2" "F-stat IV" "$ N \times T $" "$ N $" "$ T $")) 
	
* total time taken
timer off 1
timer list 1
