******************************************************
* CREATES TABLE A1 IN 'FUELING CONFLICT' 
* Summary statistics
*****************************************************


************** preliminaries **************
clear *
global reps = 10 // bootstrap iterations, paper = 999
set more off, perm
set maxiter 50 // max NR iterations for one estimation

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 


*use AiC_analysis.dta, clear
use ./data/AiC_analysis_28.dta, clear // include Korea and Slovenia

*** exesive aid recipients
gen exesive = 0
replace exesive = 1 if netoda_gdp >= 50 & netoda_gdp != .
bys rec_id: egen ex_dum = mean(exesive)
replace ex_dum = 1 if ex_dum != 0


set matsize 10000
sort recdon_id year

* they are donors
drop if rec == "Korea"
drop if rec == "Slovenia"
gen govfrac_prob = govfrac*prob_recddon
gen legfrac_prob = frac* prob_recddon	
	
*** Bilateral descriptives
*------------------------------------------------------------------------------*
*** seperate fractionalization measures
gen frac_ukc = 0
replace frac_ukc = frac if don == "United States" | don == "Canada" | don == "United Kingdom"
gen gfrac = govfrac
replace gfrac = 0 if don == "United States" | don == "Canada" | don == "United Kingdom"

*** grosdis over gdp
replace grossminusdebt = 0 if grossminusdebt == . | grossminusdebt < 0
replace grossdisb = 0 if grossdisb < 0
gen gros_gdp = ((grossdisb)/pwt7_gdp_cUS)*100

label var netoda_gdp "Aid to GDP (in percent)"
label var gros_gdp "Gross ODA to GDP ratio"
label var netodaoof_gdp "Net ODA + OOF to GDP ratio"
label var govfracleg "Government Fractionalization"
label var prob_recddon "Probability to receive Aid"
label var prob_gros "Pro. to receive gross ODA"
label var prob_odaoof "Prob. to receive ODA+OOF"
label var gfrac "Government fractionalization"
label var frac_ukc "Legistlative Fractionalization (FPTP only)"

local varstats netoda_gdp   gfrac frac_ukc prob_recddon   // variables for table

mat stats = J(4,5,.) // first number defined the number if variables, second number of columns

local i = 1
foreach v in `varstats' {
	sum `v' 
	mat stats[`i',1] = r(mean)
	mat stats[`i',2] = r(sd)
	mat stats[`i',3] = r(min)
	mat stats[`i',4] = r(max)
	mat stats[`i',5] = r(N)
	local `i++' 
}
mat rownames stats = `varstats'
mat li stats

*creates Panel A) Bilateral of Table A-1 
frmttable, statmat(stats) varlabels  sdec(2,2,2,2,0) ///
             ctitles("Variable", "Mean","SD","Min","Max","N")
	     
frmttable using bil_sumstat.tex, statmat(stats) varlabels  sdec(2,2,2,2,0) ///
             ctitles("Variable", "Mean","SD","Min","Max","N") tex replace
			 
			 
*** Recipient descriptives
********************************************************************************
use ./data/AiC28_analysis_covariates, clear


label var aggnetoda_gdp "Aid to GDP (in percent)"
label var agg_gros_aidgdp "Gross ODA to GDP ratio"
label var aggnetodaoof_gdp "Net ODA + OOF to GDP ratio"
label var peace "Peace"
label var sc "Small Conflict"
label var vc "Armed Conflict"
label var war "War"
label var ln_gdp "Log of GDP"
label var ln_pop "Log of Population"
label var ln_gdpc "Log of GDP per capita"
label var oilexp "Oil Exporter Dummy"
label var polity2 "Polity IV (revised)"
label var inst3 "Political Instability"
label var region_polity "Regional Polity IV"
ren neighbor_smal~n neighbor_small
label var neighbor_small "Neighbor in Small Conflict Dummy"
label var neighbor_con "Neighbor in Armed Conflict Dummy"
label var neighbor_war "Neighbor in War Dummy"
label var Island "Island Dummy"
label var remittances_rec "Personal remittances, received (% of GDP)"


local varstats aggnetoda_gdp  ln_gdp ln_pop 
	
mat stats = J(3,5,.) // first number defined the number if variables, second number of columns

local i = 1
foreach v in `varstats' {
	sum `v' 
	mat stats[`i',1] = r(mean)
	mat stats[`i',2] = r(sd)
	mat stats[`i',3] = r(min)
	mat stats[`i',4] = r(max)
	mat stats[`i',5] = r(N)
	local `i++' 
}


mat rownames stats = `varstats'
mat li stats


*Creates Panel B) Country-level of Table A-1 
frmttable, statmat(stats) varlabels  sdec(2,2,2,2,0) ///
             ctitles("Variable", "Mean","SD","Min","Max","N")
	     
frmttable using sumstat.tex, statmat(stats) varlabels  sdec(2,2,2,2,0) ///
             ctitles("Variable", "Mean","SD","Min","Max","N") tex replace
	     
	     
