******************************************************
* CREATES TABLE 2 IN 'FUELING CONFLICT' 
* First stage regressions with generated IV
*****************************************************


************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set maxiter 50 // max NR iterations for one estimation
parallel setclusters 30, force // set to number of cores, alters seeds used
set more off, perm

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd 




** open bilateral data
use ./data/AiC_all_bootstrap.dta, clear

** code for generic bootstrap program

* drop current prog in memory
cap program drop twostep_boot

* define bootstrap for first stages
program twostep_boot, eclass 

	* allow changing dep var and adding controls
	syntax , Y(varname numeric) [Z(varlist numeric) initrends]
	tempname aa bb cc ss conv
	local initial_trends `initrends'

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does  not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	* allow going back to bilateral structure
	preserve
	
	* re-define panel
	gegen newpair = group(newid don_id)
	xtset newpair year
	
	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year, fe
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys newid year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by newid year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode == doncode[1] // works like collapse
	drop don_id doncode

	* mark the sample to use and drop rest 
	mark touse
	markout touse `y' aggnetoda_gdp agghatnetoda_gdp `z'
	drop if !touse

	* reset xt to panel bootstrap handle
	xtset newid year
	
	* balance sample to max Ti
	by newid (year): gen Ti = _N  
	qui sum Ti // fine now
	keep if Ti== `r(max)'

	* generate initial year var and initial state dummies
	by newid (year): gegen inityear = min(year)  
	gen initcondtemp = `y' if year==inityear
	by newid(year) : gegen init = max(initcondtemp)
	drop initcondtemp
	qui tab init, gen(init_)  
	* note that we have few initial war observations, thus in some 
	* bootstrap iterations init_4 will be empty (not found)
	drop init_1 init // will always be omitted, second is tempvar

	if "`initial_trends'" != "" {
		gen init2_X_year = init_2*year
		gen init3_X_year = init_3*year
		gen init4_X_year = init_4*year	
		local init_first init_2 init_3 init_4 init2_X_year init3_X_year init4_X_year
		local trends_main init2_X_year init3_X_year init4_X_year
	}
	
	*** first stage, equiv to xtreg, fe
	*reg aggnetoda_gdp agghatnetoda_gdp `z' `init_first' m_* y_1977-y_2010 if year>inityear 
	xtreg aggnetoda_gdp agghatnetoda_gdp `z' `trends_main' i.year if year>inityear, fe cluster(rec_id) 
	* go back to bilateral structure
	restore
end

** open bilateral data
use ./data/AiC_all_bootstrap.dta, clear
xtset recdon_id year

* set the seed only once, parallel will take it from there
set seed 10101

* start timer
timer clear 1
timer on 1

*** column 1

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb)  
drop newid
	
local T = e(Tbar)
local Ng = e(N_g)
local r2w = e(r2_w)
local NT = e(Tbar)*e(N_g)

* call bootstrap and store all results
eststo m1: parallel bs, ///
	nowarn reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, /// 
	y(conflict_pb)  
di r(pll_seeds) // for log file

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`T''
estadd scalar Ng = `=`Ng''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2w''

*** column 2

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb)  z(ln_gdp ln_pop)
drop newid
	
local T = e(Tbar)
local Ng = e(N_g)
local r2w = e(r2_w)
local NT = e(Tbar)*e(N_g)

* call bootstrap and store all results
eststo m2: parallel bs, ///
	nowarn reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, /// 
	y(conflict_pb)  z(ln_gdp ln_pop)
di r(pll_seeds) // for log file

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`T''
estadd scalar Ng = `=`Ng''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2w''

*** column 3

* clear current panel setting
xtset, clear

* parallel does not save results from first run, obtain beforehand
gen newid = rec_id
qui twostep_boot, y(conflict_pb)  z(ln_gdp ln_pop) initrends
drop newid
	
local T = e(Tbar)
local Ng = e(N_g)
local r2w = e(r2_w)
local NT = e(Tbar)*e(N_g)

* call bootstrap and store all results
eststo m3: parallel bs, ///
	nowarn reps($reps) cluster(rec_id) ///
	idcluster(newid) randtype(current): twostep_boot, /// 
	y(conflict_pb)  z(ln_gdp ln_pop) initrends
di r(pll_seeds) // for log file

estadd scalar F =  (_b[agghatnetoda_gdp]/_se[agghatnetoda_gdp])^2
estadd scalar T = `=`T''
estadd scalar Ng = `=`Ng''
estadd scalar NgT = `=`NT''
estadd scalar r2w = `=`r2w''

* output all regressions
esttab using ./tables/Table_2.tex, replace  tex star(* 0.10 ** 0.05 *** 0.01) ///
	se drop(*.year)  nobaselevels b(4) se(4) ///
	stats(F r2w NgT Ng T, fmt(a3) labels("Within-R2" "F-stat IV" "$ N \times T $" "$ N $" "$ T $")) 
esttab using ./tables/Table_2.rtf, replace rtf  star(* 0.10 ** 0.05 *** 0.01) ///
	se drop(*.year) nobaselevels b(4) se(4) ///
	stats(F r2w NgT Ng T, fmt(a3) labels("Within-R2" "F-stat IV" "$ N \times T $" "$ N $" "$ T $")) 
	
* total time taken
timer off 1
timer list 1
