******************************************************
* CREATES TABLE 1 IN 'FUELING CONFLICT' 
*****************************************************


************** preliminaries **************
clear *
global reps = 200 // bootstrap iterations, paper = 200
set more off, perm
set maxiter 50 // max NR iterations for one estimation


**************  set working dir **************

*add your working directory
* cd 


******** TABLE 1: Unconditional Transition Matrix

* Use data and set sample to max balanced given variables
use balance_sample28, clear
drop y_*

* Mark the sample to use and drop rest 
mark touse
markout touse conflict_pb conflict_clas conflict_ter aggnetoda_gdp agghatnetoda_gdp 
drop if !touse

* Balance sample to max Ti
bys rec_id (year): gen Ti = _N 
tab Ti

keep if Ti==36
tab year

* get Markov transitions

* can't save results with xttrans
xttrans conflict_pb  

* reproduce using tab
gen l_conflict_pb = l.conflict_pb
tab l_conflict_pb conflict_pb,  ro nof matcell(T)

* turn frequencies into probabilities
mata: 
T = st_matrix("T")
U = J(1,cols(T),1)
c = (U*T')
T = T:/c' * 100
st_matrix("T", T)
end

* back in stata, now hand over to frmttable
mat li T


frmttable using Table_1, statmat(T)  sdec(2) ///
	title("Markov Transition Matrix") ///
	ctitle("","Peace", "Small Conflict","Armed Conflict", "Civil War" ) ///
	rtitle("Peace"  \ "Small Conflict" \  "Armed Conflict" \"Civil War") ///
        annotate(stars) asymbol(*,**,***) tex frag replace

		
