******************************************************
* CREATES Figure C1 'FUELING CONFLICT' 
* Leave-one-out test: Donors
******************************************************

* lets try this with gtools, speeds up aggregation
which gtools
if _rc==111 {
	ssc install gtools
	gtools, upgrade
}



************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set more off, perm


**************  set working dir **************

*add your working directory
* cd 


* open bilateral data
use ./data/AiC_analysis_28.dta, clear 
sort recdon_id year

* they are donors
drop if rec == "Korea"
drop if rec == "Slovenia"

* take care of pol systems
gen frac_ukc = 0
replace frac_ukc = frac if don == "United States" | don == "Canada" | don == "United Kingdom"
gen gfrac = govfrac
replace gfrac = 0 if don == "United States" | don == "Canada" | don == "United Kingdom"

* main measures
replace netoda_gdp = (netoda/pwt7_gdp_cUS)*100

* do some stuff to anticipate which 125 rec_ids will be relevant in the later sample
bys rec_id year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
mark touse
markout touse conflict_pb aggnetoda_gdp  ln_gdp ln_pop
bys touse rec_id don_id (year): gen Ti = _N  
tab Ti if touse
sum Ti
replace rec_id=. if !touse | Ti< `r(max)'
gegen group = group(rec_id) if !missing(rec_id)
replace rec_id=group

* clean up
drop touse Ti aggnetoda_gdp group

* remove irrelevant stuff
keep recdon_id rec_id reccode don_id doncode year conflict_pb netoda_gdp ln_gdp ln_pop gfrac frac_ukc prob_recddon

save ./data/jackknife.dta, replace
	
***** Leave-one-out donors

levelsof don_id, local(allids)
local N: word count `allids'
di `N'

mat C_SE = J(`N',3,.)

forv i=1(1)`N' { 

	use ./data/jackknife, clear

	* leave one out
	drop if don_id == `i'

	*** predict aid bilaterally
	xtreg netoda_gdp c.gfrac##c.prob_recddon c.frac_ukc##c.prob_recddon i.year , fe 
	predict netoda_frac_ukc, xbu
	
	* aggregate to country-year panel
	bys rec_id year: gegen aggnetoda_gdp=total(netoda_gdp), missing  
	by rec_id year: gegen agghatnetoda_gdp=total(netoda_frac_ukc), missing 
	keep if doncode ==  doncode[1] // works like collapse
	drop don_id doncode
	
	* obtain correct sample
	drop if rec_id == .
	xtset rec_id year
	
	* generate initial year var 
	by rec_id (year): gegen inityear = min(year)  

	*** first stage, equiv to xtreg, fe
	xtreg aggnetoda_gdp agghatnetoda_gdp  i.year if year>inityear, fe cluster(rec_id) 

	mat C_SE[`i',1] =  _b[agghatnetoda_gdp]
	mat C_SE[`i',2] =  _se[agghatnetoda_gdp]
	mat C_SE[`i',3] =  `i'
}

mat li C_SE

matrix colnames C_SE = "coef" "se" "don_id"

clear
svmat C_SE, names(col) 

save ./data/coefresults_don, replace

*** merge and plot

use ./data/jackknife.dta, clear
collapse (first) doncode , by(don_id)
*** obtain country names
merge 1:1 don_id using ./data/coefresults_done

*** generate uper and lower 95 CI
gen CI_u = coef + se*abs(invnorm(0.025))
gen CI_l = coef - se*abs(invnorm(0.025))

encode doncode, gen(Don_id)

* plot 
twoway ///
	(scatter CI_l Don_id , msymbol(none) color(gs8)) ///
	(scatter CI_u Don_id , msymbol(none) color(gs8)) ///
	(rcap CI_u CI_l Don_id, lwidth(small) msize(small) color(gs8)) ///
	(scatter coef Don_id , msymbol(o) color(black)) , ///
		yscale(range(0.4(0.4)2.4)) ylabel(0.4 "0.4" 0.8 "0.8" 1.2 "1.2" 1.6 "1.6" 2 "2" 2.4 "2.4") ///
	xtick(#1) xscale(range(1(1)28)) xlabel(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 ///
	21 22 23 24 25 26 27 28, valuelabel alternate labsize(vsmall)) ///
	graphregion(color(white))  ytitle(Coefficient and 95% CI) xtitle(Excluded Donors) ///
	legend(off) name(jackknife_don, replace) ///
	yline(1.232559, lc(red)) 
graph export ./figures/Figure_C1.pdf, replace

