******************************************************
* CREATES FIGURE 2 IN 'FUELING CONFLICT' 
* randomization test
*
******************************************************

************** preliminaries **************
clear *
global reps = 999 // bootstrap iterations, paper = 999
set maxiter 50 // max NR iterations for one estimation
parallel setclusters 30, force // set to number of cores, alters seeds used
set more off, perm

************** Programs **************
/*
ssc install gtools
gtools, upgrade
ssc install parallel
*/

**************  set working dir **************

*add your working directory
* cd


* randomization program
cap prog drop randomize_aid
program define randomize_aid, rclass

	* allow changing dep var and adding controls
	syntax, [countries within years]
	tempname aa 
	
	* grab type
	local ctry `countries'
	local wthn `within'
	local yrs `years'

	* check if parallel execution was aborted
	parallel break
	
	* moved in here in case parallel does not export this parameter
	set maxiter 50 // max NR iterations for one estimation

	if("`ctry'"!="") {
		* countries
		bys year (rec_id): gen random = runiform()
		bys year (random): gen rindex_temp = _n if year == 2000
		bys rec_id: egen rindex = max(rindex_temp)
		bys year (rec_id): gen newaid = aggnetoda_gdp[rindex]
		di as error "countries"
	} 
	else if("`wthn'"!="") {
		*** within countries, reorder years
		bys rec_id (year): gen random = runiform()
		bys rec_id (random): gen rindex = _n
		bys rec_id (year): gen newaid = aggnetoda_gdp[rindex]
		di as error "within"
	} 
	else if("`yrs'"!="") {
		*** within years, reorder countries
		bys year (rec_id): gen random = runiform()
		bys year (random): gen rindex = _n
		bys year (rec_id): gen newaid = aggnetoda_gdp[rindex]
		di as error "years"
	} 
	else {
		* everything
		gen random = runiform()
		sort random
		gen rindex = _n
		xtset
		gen newaid = aggnetoda_gdp[rindex]
		di as error "everything"
	}
	
	* sort again
	xtset

	*** CRE model
	xtoprobit conflict_pb newaid  ///
			c.newaid#1.lagged_o_2 c.newaid#1.lagged_o_3 ///
			c.newaid#1.lagged_o_4 init_2-init_4 ///
			lagged_o_2-lagged_o_4 nu ///
			ln_pop ln_gdp ///
			z_nu_197* m_nu z_agg*_197* m_agg* ///
			z_ln*_197*  m_ln* ///
			y_1977-y_2010 if year>inityear, i(rec_id) 
			
	* save coefficients
	return scalar b_int1 = _b[c.newaid#1.lagged_o_2]
	return scalar se_int1 = _se[c.newaid#1.lagged_o_2]
	return scalar b_int2 = _b[c.newaid#1.lagged_o_3]
	return scalar se_int2 = _se[c.newaid#1.lagged_o_3]
	return scalar b_int3 = _b[c.newaid#1.lagged_o_4]
	return scalar se_int3 = _se[c.newaid#1.lagged_o_4]
	
	* clean up		
	drop random rindex* newaid

end

** load country level data
use ./data/balance_sample28.dta

* mark the sample to use and drop rest 
mark touse
markout touse conflict_pb aggnetoda_gdp agghatnetoda_gdp ln_pop ln_gdp
drop if !touse

xtset rec_id year

* balance sample to max Ti
by rec_id (year): gen Ti = _N  
qui sum Ti // fine now
keep if Ti== `r(max)'

* generate lagged conflict states
gen lagged_o_2 = (l.conflict_pb == 1)
gen lagged_o_3 = (l.conflict_pb == 2)
gen lagged_o_4 = (l.conflict_pb == 3)

* generate initial year var and initial state dummies
by rec_id (year): gegen inityear = min(year)  
gen initcondtemp = conflict_pb if year==inityear
by rec_id(year) : gegen init = max(initcondtemp)
drop initcondtemp
qui tab init, gen(init_)  
drop init_1 init // will always be omitted, second is tempvar

* generate T-2 year dummies 
qui sum year
// first year will always drop out given condition below, second year is base
forv i = `=r(min)+2'(1)`=r(max)' {
	gen y_`i' =  (year==`i')
}

* generate z_i vector including controls and IV
local allvars agghatnetoda_gdp ln_pop ln_gdp // put other control vars here 
foreach var in `allvars' {
	by rec_id (year): gegen m_`var' = mean(`var') if year>inityear 
	qui sum year // not first year, gets omitted otherwise
	forv i = `=r(min)+1'(1)`r(max)' {
		by rec_id (year): gen temp_z_`var'_`i' = `var' if year==`i'
		by rec_id (year): gegen z_`var'_`i' = max(temp_z_`var'_`i')
		drop  temp_z_`var'_`i'
	}
}
	
*** first stage, equiv to xtreg, fe
reg aggnetoda_gdp agghatnetoda_gdp ln_pop ln_gdp m_* y_1977-y_2010 if year>inityear, cluster(rec_id)
predict nu, resid

* generate averages and nu_i vector
by rec_id (year): gegen m_nu = mean(nu) if year>inityear 
sum year // not first year
forv t = `=r(min)+1'(1)`r(max)' {
	by rec_id (year): gen temp_z_nu_`t' = nu if year==`t'
	by rec_id (year): gegen z_nu_`t' = max(temp_z_nu_`t')
	replace z_nu_`t' = 0 if missing(z_nu_`t') // needed?
	drop  temp_z_nu_`t'
}

*** main model
xtoprobit conflict_pb aggnetoda_gdp nu ///
		c.aggnetoda_gdp#1.lagged_o_2 c.aggnetoda_gdp#1.lagged_o_3 ///
		c.aggnetoda_gdp#1.lagged_o_4 lagged_o_2-lagged_o_4 init_2-init_4 ///
		ln_pop ln_gdp m_* z_*_197* y_1977-y_2010  if year>inityear, i(rec_id)  
		
* save results
forv i = 1(1)3 {	
	global b_real`i' = _b[c.aggnetoda_gdp#1.lagged_o_`=`i'+1']
	global se_real`i' = _se[c.aggnetoda_gdp#1.lagged_o_`=`i'+1']
	di ${b_real`i'} 
	di ${se_real`i'} 
	
}

* set set once, parallel will take care of the rest
set seed 10101

* time for log
timer clear 1
timer on 1

* overall
preserve
	* execute simulation in parallel
	parallel sim, reps($reps) expr(b_int1 = r(b_int1) se_int1 = r(se_int1) ///
				      b_int2 = r(b_int2) se_int2 = r(se_int2) ///
				      b_int3 = r(b_int3) se_int3 = r(se_int3)) /// 
		randtype(current): randomize_aid

	save ./data/randomize_aid_overall, replace
restore

* countries
preserve
	* execute simulation in parallel
	parallel sim, reps($reps) expr(b_int1 = r(b_int1) se_int1 = r(se_int1) ///
				      b_int2 = r(b_int2) se_int2 = r(se_int2) ///
				      b_int3 = r(b_int3) se_int3 = r(se_int3)) /// 
		randtype(current): randomize_aid, countries
		
	save ./data/randomize_aid_countries, replace
restore

* within
preserve
	* execute simulation in parallel
	parallel sim, reps($reps) expr(b_int1 = r(b_int1) se_int1 = r(se_int1) ///
				      b_int2 = r(b_int2) se_int2 = r(se_int2) ///
				      b_int3 = r(b_int3) se_int3 = r(se_int3)) /// 
		randtype(current): randomize_aid, within

	save ./data/randomize_aid_within, replace
restore

* years
preserve
	* execute simulation in parallel
	parallel sim, reps($reps) expr(b_int1 = r(b_int1) se_int1 = r(se_int1) ///
				      b_int2 = r(b_int2) se_int2 = r(se_int2) ///
				      b_int3 = r(b_int3) se_int3 = r(se_int3)) /// 
		randtype(current): randomize_aid, years
	
	save ./data/randomize_aid_years, replace
restore

* total time taken
timer off 1
timer list 1

local fnames overall countries within years
foreach x of local fnames {

	* open results
	use ./data/randomize_aid_`x', clear
	
	* get original t-stats
	forv i = 1(1)3 {	
		gen t_crit`i' = abs(${b_real`i'} /${se_real`i'} )
	}

	* compute sim pp-values
	forv i = 1(1)3 {
			gen t`i' = abs(b_int`i'/se_int`i')
			gen p`i' = (t`i' > t_crit`i')
			sum p`i', mean
			local p`i' = `r(mean)'
	}

	* toggle correct title
	local gtitle = proper("`x'")

	* get's rid of little frames later
	set scheme LeanR
	
	*** small conflict interaction	
	graph twoway ///
		(kdensity b_int1, lcolor(gs10) bcolor(gs10)  range(-0.03 0.03)) ///
		, xline($b_real1, lp(dash) lw(medium) lcolor(black)) graphregion(fcolor(white)) ///
		text(70 -0.05 "p-value: `=round(`p1', .001)'", orient(horizontal) size(small)) ///
		ylabel(none) legend(off) xtitle("") ytitle("Small Conflict", size(medium)) bgcolor(white) ///
		title("`gtitle'", size(medium))	name(`x'_random_b1, replace)  

	*** armed conflict interaction	
	graph twoway ///
		(kdensity b_int2, lcolor(gs10) bcolor(gs10)) ///
		, xline($b_real2, lp(dash) lw(medium) lcolor(black)) graphregion(fcolor(white)) ///
		ylabel(none) legend(off) xtitle("") ytitle("Armed Conflict", size(medium)) ///
		text(70 0.05 "p-value: `=round(`p2', .001)'", orient(horizontal) size(small)) bgcolor(white) ///
		title("") name(`x'_random_b2, replace) 

	*** civil war interaction	
	graph twoway ///
		(kdensity b_int3, lcolor(gs10) bcolor(gs10)) ///
		, xline($b_real3, lp(dash) lw(medium) lcolor(black)) graphregion(fcolor(white)) ///
		text(70 0.05 "p-value: `=round(`p3', .001)'", orient(horizontal) size(small)) ///
		ylabel(none) legend(off) xtitle("") ytitle("War", size(medium)) bgcolor(white) ///
		title("") name(`x'_random_b3, replace)

}

** grab all graphs
graph combine ///
	overall_random_b1 countries_random_b1 within_random_b1 years_random_b1 ///
	overall_random_b2 countries_random_b2 within_random_b2 years_random_b2 ///
	overall_random_b3 countries_random_b3 within_random_b3 years_random_b3 , ///
	graphregion(fcolor(white)) ycommon xcommon 
graph export ./figures/Figure_2.pdf, replace
graph close _all
