################################################################################
# load packages&results and prepare helper functions
################################################################################

library(ggplot2)
library(gridExtra)
library(xtable)

load("Replication.RData")

# helper function (see http://adv-r.had.co.nz/Computing-on-the-language.html)
substitute_q <- function(x, env) {
  call <- substitute(substitute(y, env), list(y = x))
  eval(call)
}
  
# transform gaps of 'mscmt' objects
gapTransform <- function(x,what=character(),
                         expr=quote((treated-synth)/synth*100)) {
  if (is.list(x)&&is.null(x$combined)&&is.null(x$placebo)) {
    lapply(x,gapTransform,what=what,expr=expr) 
  } else {
    if (!is.null(x$placebo)) {
	    for (i in setdiff(names(x),"placebo"))
        x[[i]] <- gapTransform(x[[i]],what,expr)
	    for (i in what) {
	      if (i %in% names(x[["placebo"]])) {
          x[["placebo"]][[i]]$gaps <- 
            eval(substitute_q(expr,list(treated=x[["placebo"]][[i]]$data.treat,
                                        synth=x[["placebo"]][[i]]$data.synth)))
          colnames(x[["placebo"]][[i]]$gaps) <- 
            colnames(x[["placebo"]][[i]]$data.treat)
		    }  
      }  
    } else {
      for (i in what)
	    if (i %in% names(x$gaps))
        x$gaps[[i]] <- 
          eval(substitute_q(expr,list(treated=x$data.treat[[i]],
                                      synth=x$data.synth[[i]])))
      for (i in what)
        if (i %in% names(x$combined))
          x$combined[[i]][,"gaps"] <- 
            eval(substitute_q(expr,list(treated=x$combined[[i]][,"treated"],
                                        synth=x$combined[[i]][,"synth"])))
    }
	x
  }
}

nice_names <- "Main Specification"
Labels     <- c("PIE"="Piedmont","VDA"="Valle d'Aosta","LOM"="Lombardy",
                "LIG"="Liguria","TAA"="Trentino Alto Adige","VEN"="Veneto",
                "FVG"="Friuli Venezia Giulia","EMR"="Emilia Romagna",
                "TOS"="Tuscany","UMB"="Umbria","MAR"="Marche","LAZ"="Lazio",
                "ABR"="Abruzzo","MOL"="Molise","SAR"="Sardinia")          
LabelsWA   <- paste0(Labels," (",names(Labels),")")            
names(LabelsWA) <- names(Labels)
Scenarios  <- c("Stata, EJ","R/MSCMT","Matlab","R/Synth")
table.w <- function(x,i,tol=2e-15,digits=3,include.rmspe=FALSE,caption=NULL,
                    label=NULL,include.loss.w=FALSE) {
  tmp <- x[[i]]$comparison$results$w[,Scenarios]
  ind <- apply(tmp,1,function(x) any(is.na(x)|(x>tol)))
  tmp <- tmp[ind,,drop=FALSE]
  rownames(tmp) <- LabelsWA[rownames(tmp)]
  colnames(tmp) <- Scenarios
  hline.after <- c(-1,0)
  if (include.rmspe||include.loss.w) hline.after <- c(hline.after,nrow(tmp))
  if (include.rmspe)  
    tmp <- rbind(tmp,"RMSPE GDP per Capita 1951--60"=
                        x[[i]]$comparison$results$rmspe[Scenarios]/100)
  if (include.loss.w) 
    tmp <- rbind(tmp,"Predictor loss $(\\times 100)$"=
                        x[[i]]$comparison$results$loss.w[Scenarios])
  hline.after <- c(hline.after,nrow(tmp))
  print(
    xtable(100*tmp,display=rep("f",ncol(tmp)+1),
           digits=rep(digits,ncol(tmp)+1),
           align=paste0("l",paste0(rep("r",ncol(tmp)),collapse="")),
           caption=if (is.null(caption)) 
             paste0(nice_names[i],". Weights of donor units in \\%",
               if (include.rmspe) " and RMSPE of GDP per Capita 1951--60" else 
                                  NULL,
               ". Donor units with (nearly) zero weights are omitted.") else
             caption,
           label=if (is.null(label)) paste0("tab:A_w_",names(x)[i]) else label),
    booktabs=TRUE,size="footnotesize",table.placement="H",
    hline.after=hline.after,sanitize.rownames.function=function(x) x
  )
}      

agg.res        <- vector("list",1)
names(agg.res) <- "main"
for (i in names(agg.res))
  agg.res[[i]] <- gapTransform(
                    list("R/MSCMT"=res_narrow[[i]],"Stata, EJ"=res_paper[[i]],
                         "Matlab"=res_matlab[[i]],"R/Synth"=res_synth[[i]]),
                    "gdppercap")
comp.res <- lapply(agg.res,compare)       

gglty1   <- scale_linetype_manual(values=c("Stata, EJ"="11","R/MSCMT"="31",
                     "Matlab"="solid","R/Synth"="13")) 
ggmafia  <- geom_rect(data=data.frame(xmin=as.Date("1975-01-01"),
                                      xmax=as.Date("1980-12-31")),
                      aes(xmin=xmin,xmax=xmax),ymin=-Inf,ymax=+Inf,alpha=0.1,
                      fill="blue")     
ggscale  <- scale_x_date(breaks=seq.Date(as.Date("1950-01-01"),
                                         as.Date("2010-01-01"),by="10 year"),
                         date_labels="%Y")                 
ggshape1 <- scale_shape_manual(values=c("Stata, EJ"=1,"R/MSCMT"=2,"Matlab"=3,
                                        "R/Synth"=4)) 
gg_gdp   <- ggplot(comp.res$main,what=c("gdppercap"),draw.points=TRUE,
                   unit.name="Software",
                   col=c("springgreen1","black","darkorange","blue")) +
            labs(title="GDP per Capita",x="",y="GDP per Capita, % Gap") +
            gglty1 + ggscale + ggmafia + ggshape1 
gg_elec  <- ggplot(comp.res$main,what=c("kwpop"),draw.estwindow=FALSE,
                   draw.points=TRUE,unit.name="Software",
                   col=c("springgreen1","black","darkorange","blue")) + 
			      labs(title="Electricity Consumption",
                 y="Gaps for Kilowatt-Hour per Capita",x="") + 
			      ggshape1 + gglty1 + ggscale + ggmafia


################################################################################
# generate Table 1
################################################################################
table.w(comp.res,1,digits=5,tol=1e-5,include.rmspe=TRUE)

################################################################################
# generate Figure 1
################################################################################
grid.arrange(arrangeGrob(grobs=lapply(list(gg_gdp,gg_elec),ggplotGrob),
                         ncol=2,nrow=1))
