################################################################################
# load packages and prepare the data
################################################################################

library(readstata13)
library(Synth)

# dataset.dta was extracted from zip-file accessible via:
# http://onlinelibrary.wiley.com/doi/10.1111/ecoj.12235/abstract
mafia <- read.dta13("dataset.dta")                                              # data for package Synth

# prepare dataprep object
dataprep.out <- list(main=dataprep(
  foo=mafia,
  predictors = c("gdppercap","invrate","shvain","shvaag","shvams","shvanms",  
                 "shskill","density"),
  predictors.op = "mean", 
  special.predictors = NULL,
  dependent = "gdppercap", 
  unit.variable = "reg",
  time.variable = "year",
  treatment.identifier = "NEW",
  controls.identifier = c("PIE", "VDA", "LOM", "TAA", "VEN", "FVG", "LIG", 
                          "EMR", "TOS", "UMB", "MAR", "LAZ", "ABR", "MOL", 
                          "SAR"),
  time.predictors.prior = 1951:1960,
  time.optimize.ssr = 1951:1960, 
  time.plot = 1951:1960,
  unit.names.variable = "region"
))

# prepare data for matlab
for (i in names(dataprep.out)) 
  for (j in c("X0","X1","Z0","Z1"))
    write.table(dataprep.out[[i]][[j]],file=paste0(i,"_",j,".txt"),
                col.names=FALSE,row.names=FALSE)
