% The Role of Time-Varying Price Elasticities in Accounting for Volatility
% Changes in the Crude Oil Market. 
% By Christiane Baumeister and Gert Peersman.
% March 2012.

clear all; clc;
%profile on
%retrieve functions from these folders
path(path,'C:\BP2012codes\mymatprog\reduced')
path(path,'C:\BP2012codes\mymatprog\structural')
path(path,'C:\BP2012codes\mymatprog\convergence')
path(path,'C:\BP2012codes\mymatprog\utilities')
warning('off','all')
%
estimate=1;     % 1 corresponds to re-estimate model; 0 loads in results to reproduce figures
N=3;            % number of endogenous variables
B=1;            % 1 corresponds to benchmark specification; 0 is Kilian robustness check (JEEA specification)
exact=0;        % 1 if exact zero restriction is imposed on Y after oil specific-demand shock; 0 otherwise
pers=0;         % 1 if in addition to IRFs you want to compute also persistence and volatility measures; 0 otherwise

if B==1;   
FD=1;           % estimation in FIRST DIFFERENCES
TP=25;          % length of the training sample in years
%store results in this folder: benchmark specification 
DFILE1 = 'C:\BP2012codes\results\reduced\worldoil_real_burn4';
DFILE2 = 'C:\BP2012codes\results\reduced\worldoil_real_MCMC4';
if exact==0 && pers==0
    DFILE3 = 'C:\BP2012codes\results\structural\worldoil_real_IRF4';
elseif exact==1 && pers==0
    DFILE3 = 'C:\BP2012codes\results\structural\worldoil_real_IRF4exact';
elseif exact==0 && pers==1
    DFILE3 = 'C:\BP2012codes\results\structural\worldoil_real_IRF4persist';
end
%retrieve data
data=xlsread('C:\BP2012codes\data\BP2oil.xls','real_B','B2:D257');
time=(1947.0:0.25:2010.75)'; %sample period: 1947Q1 - 2010Q4
else
FD=0;          % data transformation
TP=5;          % length of the training sample in years
%store results in this folder: robustness check (quarterly version of Kilian JEEA specification) 
DFILE1 = 'C:\BP2012codes\results\reduced\worldoil_Kilian67_burn4';
DFILE2 = 'C:\BP2012codes\results\reduced\worldoil_Kilian67_MCMC4';
DFILE3 = 'C:\BP2012codes\results\structural\worldoil_Kilian67_IRF4';
%retrieve data 
data=xlsread('C:\BP2012codes\data\BP2oil.xls','real_K','B2:D174');
time=(1967.75:0.25:2010.75)'; %sample period: 1967Q4 - 2010Q4
end
%%%
if FD==1
    m=1;
    QO=100*log(data(:,1));      %world oil production
    PO=100*log(data(:,2));      %real oil price index: imported RAC (not adjusted for price controls)
    Y=100*log(data(:,3));       %world industrial production index (UN monthly statistical bulletin), sa
    data=[QO PO Y];
    y=lagn(data,m);
else
    QO=100*lagn(data(:,1),1)./data(1:end-1,1);      %percent change
    PO=100*log(data(:,2))-mean(100*log(data(:,2))); %real oil price demeaned
    Y=data(:,3);                                    %average of global real activity index based on Baltic Dry Index
    y=[QO PO(2:end,1) Y(2:end,1)];
end
%
NB = 50000;      % number of burn-in iterations
D = 10;          % sampling interval from Markov chain (memory constraint, mixing)
NG = 5000;       % number of draws from Gibbs sampler per data file
%lag length:
L=4;
%determine whether you want to impose stability constraint:
SC=0;           % 0 = NO STABILITY CONSTRAINT imposed
Lambda='Small'; % determines amount of time variation in the evolution of reduced-form coefficients
                % 'Small' corresponds to Primiceri (default),
                % 'Large' corresponds to most time variation,
                % 'CogSa' corresponds to Cogley and Sargent value
h=1;            % number of PERIODS for which the SIGN RESTRICTIONS have to hold
R=500;          % number of simulations for each point in time

if estimate==1
%do MCMC for reduced-form TVP-VAR    
a=TVP_BURN(DFILE1,y,NB,NG,L,TP,SC,Lambda);         %first generation TVP-VAR
M=TVP_MCMC(DFILE1,DFILE2,y,D,NG,L,TP,SC,Lambda);   %first generation TVP-VAR

%test whether Markov chain has converged: produces Figure 1A at the end
convergence_check(N,DFILE2);

%identification of structural shocks and computation of IRFs
[TIME,NN,T]=TVP_IRFS(DFILE2,L,N,TP,time,NG,y,DFILE3,h,SC,FD,R,exact,pers);

save bench_final
%save bench_final_exact
%save bench_final_persist
%save Kilian_final

load(DFILE3)

else 
    load(DFILE3)
    load('C:\BP2012codes\bench_final.mat')
    %load('C:\BP2011codes\bench_final_exact.mat')
    %load('C:\BP2011codes\bench_final_persist.mat')
    %load('C:\BP2011codes\Kilian_final.mat')

end

s=4;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make figures (main text and appendix (denoted by A))
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figures1and4A      %volatility measures and significance of TV of volatilities
figure2_perc2      %impulse responses for all admissible models and 68% and 95% coverage
figure3            %oil inflation persistence measure
figures4and6and5A  %elasticities and shocks and significance of TV of elasticities
figures4and6_perc2 %elasticities and shocks for 68% and 95% coverage and range of all models
figure5            %conducts sensitivity analysis with regard to upper bound on supply elasticity
figure7            %quarterly trading volume of WTI futures contracts


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%more figures for the appendix (robustness checks): This requires re-running
%the programs with the parameters B, exact, pers (lines 17-19) selected for 
%the alternative models
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kilian specification: load Kilian results first (B=0)
figure6A_perc2 %IRFs for all admissible models and 68% and 95% coverage
figure7A       %elasticities

%exact identification (zero restriction on WIP after other oil demand
%shock): load exact results first (exact=1)
figure8A_perc2 %IRFs for all admissible models and 68% and 95% coverage
figure9A       %elasticities

%variance decomposition: load persist results first (pers=1)
figure10A       %variance decomposition for 68% and 95% coverage


