function [NormSpecAtZero]=persistencePO(DFILE2,N,L)
%                               Normalised spectral density at omega=0
load(DFILE2)
NN=size(SD,3)-1;
%Nw=1000;
Nw=50;
% Getting the spectral densities:
clear QD VD UU S1 S2 SS
w=linspace(0,pi,Nw)';
i=sqrt(-1);
T=size(SD,2);
NormSpecAtZero=zeros(T,NN);
SpecInflation=zeros(Nw,NN,T);
%
kk=1;
while kk<=size(SD,2)
    T-kk+1
    hh=1;
    while hh<=NN
        SI=SD(:,kk,hh);
        a=reshape(SI',1+N*L,N)';
        a=a(:,2:1+N*L);
        for jj=1:L
            A(:,:,jj)=a(:,(jj-1)*N+1:(jj-1)*N+N);
        end
        invA=inv(chofac(N,AA(:,kk,hh)));
        VAR=invA*diag(OM(kk,:,hh))*invA'; % The variance-covariance matrix of the VAR
        %
        SS=zeros(N,N,Nw);
        for ww=1:length(w)
            G=eye(N);
            for aa=1:size(A,3)
                G=G-A(:,:,aa)*exp(-i*aa*w(ww));
            end
            SS(:,:,ww)=inv(G)*VAR*inv(G');
        end
        % y=[Inflation Unemployment 10*log(Short) MoneyGrowth];
        SpecInflation(:,hh,kk)=real(squeeze(SS(2,2,:)));
        NormSpecAtZero(kk,hh)=SpecInflation(1,hh,kk)/sum(SpecInflation(:,hh,kk));
        clear SS
        hh=hh+1;
    end
    kk=kk+1;
end

index1=[125 NN-124]; %implies 95% coverage of the entire distribution
% figure(555)
% x1=sort(squeeze(sum(SpecInflation)));
% temp1=[log((median(x1)))' log((x1(index(1),:)))' log((x1(index(2),:)))'];
% plotx1(temp1(2*s:end,:),TIME(s:end,1)); box on
% axis tight
% xlabel('time')
% 
% figure(5551)
% x1=sort(NormSpecAtZero,2);
% temp1=[(median(x1,2)) (x1(:,index1(1))) (x1(:,index1(2)))];
% plotx1(1*temp1(2*s:end,:),TIME(s:end,1)); box on
% axis tight
% xlabel('time')
% title('Persistence of Real Oil Price Inflation')

%save bench_reduced_persist SpecInflation NormSpecAtZero
