function [SD1,SD2,STDRATE,STDINFL]=getvolatilities_variables(L,N,NN,DFILE2)

%computes unconditional standard deviations
%Christiane Baumeister
%April 2009

load(DFILE2)
clear D DD II QD UU VD S1 S2 S3 S4

InterestRateSelector=[1 zeros(1,11)]'; 
InflationSelector=[0 1 zeros(1,10)]'; 
%OutputGrowthSelector=[zeros(1,2) 1 zeros(1,9)]'; 

 
alpha=0.16*2; % One minus the coverage of the confidence intervals  
DeltaTolerance=1.0000e-12; 
% 
STDRATE=zeros(size(SD,2),3); 
STDINFL=zeros(size(SD,2),3);
SD1=zeros(NN,size(SD,2));
SD2=zeros(NN,size(SD,2));
%STDGDPG=zeros(size(SD,2),3); 
% 
kk=1; 
while kk<=size(SD,2) 
    size(SD,2)-kk 
    StdRate=zeros(NN,1); 
    StdInfl=zeros(NN,1); 
    %StdGdpg=zeros(NN,1); 
    %StdMg=zeros(NN,1); 
    for hh=1:NN 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        SI=SD(:,kk,hh); 
        a=reshape(SI',1+N*L,N)'; 
        a=a(:,2:1+N*L); 
        invA=inv(chofac(N,AA(:,kk,hh))); 
        VAR=invA*diag(OM(kk,:,hh))*invA'; % The variance-covariance matrix of the VAR 
     
        %A=[a; eye(N) zeros(N,N)]; % The AR matrix of the companion form of the VAR 
        A=[a; eye(N) zeros(N,N) zeros(N,N) zeros(N,N); zeros(N,N) eye(N) zeros(N,N) zeros(N,N); zeros(N,N) zeros(N,N) eye(N) zeros(N,N)];
        VAR=[VAR zeros(N,N) zeros(N,N) zeros(N,N); zeros(3*N,4*N)]; % The AR matrix of the companion form of the VAR 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        VarianceRateOld=0; 
        Delta=1; 
        zz=0; 
        while Delta>DeltaTolerance 
            Azz=A^zz; 
            VarianceRateNew=VarianceRateOld+InterestRateSelector'*Azz*VAR*Azz'*InterestRateSelector; 
            if zz>0 
                Delta=(VarianceRateNew-VarianceRateOld)/VarianceRateOld;
            end 
            VarianceRateOld=VarianceRateNew;
            zz=zz+1; 
        end 
        StdRate(hh)=sqrt(VarianceRateNew); 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        VarianceInflationOld=0; 
        Delta=1; 
        zz=0; 
        while Delta>DeltaTolerance 
            Azz=A^zz; 
            VarianceInflationNew=VarianceInflationOld+InflationSelector'*Azz*VAR*Azz'*InflationSelector; 
            if zz>0 
                Delta=(VarianceInflationNew-VarianceInflationOld)/VarianceInflationOld; 
            end 
            VarianceInflationOld=VarianceInflationNew; 
            zz=zz+1; 
        end 
        StdInfl(hh)=sqrt(VarianceInflationNew); 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        %VarianceOutputGrowthOld=0; 
        %Delta=1; 
        %zz=0; 
        %while Delta>DeltaTolerance 
        %    Azz=A^zz; 
        %    VarianceOutputGrowthNew=VarianceOutputGrowthOld+OutputGrowthSelector'*Azz*VAR*Azz'*OutputGrowthSelector; 
        %    if zz>0 
        %        Delta=(VarianceOutputGrowthNew-VarianceOutputGrowthOld)/VarianceOutputGrowthOld; 
        %    end 
        %    VarianceOutputGrowthOld=VarianceOutputGrowthNew; 
        %    zz=zz+1; 
        %end 
        %StdGdpg(hh)=sqrt(VarianceOutputGrowthNew); 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
    end 
    
    SD1(:,kk)=StdRate;  %saves the whole distribution
    SD2(:,kk)=StdInfl;
    %SD3(:,kk)=StdGdpg;
    
    StdRate=sort(StdRate); 
    StdInfl=sort(StdInfl); 
    %StdGdpg=sort(StdGdpg); 
    
    STDRATE(kk,:)=StdRate(fix(NN*[0.5 alpha/2 (1-alpha/2)]'))'; 
    STDINFL(kk,:)=StdInfl(fix(NN*[0.5 alpha/2 (1-alpha/2)]'))'; 
    %STDGDPG(kk,:)=StdGdpg(fix(NN*[0.5 alpha/2 (1-alpha/2)]'))'; 
   
    kk=kk+1; 
end 

save volaQOPO SD1 SD2 STDRATE STDINFL   %for joint distribution
