function [zpers,zvarpo,zvarqo]=persist(SI,N,L,A0,tel)
%Contributions of structural shocks to oil inflation persistence

%Getting the spectral densities:
w=linspace(0,pi,50)';
i=sqrt(-1);
zzpers=zeros(tel,4);
zzvarPO=zeros(tel,3);
zzvarQO=zeros(tel,3);

a=reshape(SI',1+N*L,N)';
a=a(:,2:1+N*L);
for jj=1:L
    A(:,:,jj)=a(:,(jj-1)*N+1:(jj-1)*N+N);
end

for kk=1:tel
aa0=A0(:,:,kk);
VAR=aa0*aa0';
% (1) The overall spectral density:
for ww=1:length(w)
    G=eye(N);
    for aa=1:size(A,3)
        G=G-A(:,:,aa)*exp(-i*aa*w(ww));
    end
    SSS(:,:,ww)=inv(G)*VAR*inv(G');
end
% (2) The spectral density shutting off everything but the oil supply shock:
a0=aa0*diag([1 0 0]');
VAR=a0*a0';
for ww=1:length(w)
    G=eye(N);
    for aa=1:size(A,3)
        G=G-A(:,:,aa)*exp(-i*aa*w(ww));
    end
    SS_M(:,:,ww)=inv(G)*VAR*inv(G');
end
% (3) The spectral density shutting off everything but the oil-specific demand shock:
a0=aa0*diag([0 1 0]');
VAR=a0*a0';
for ww=1:length(w)
    G=eye(N);
    for aa=1:size(A,3)
        G=G-A(:,:,aa)*exp(-i*aa*w(ww));
    end
    SS_D(:,:,ww)=inv(G)*VAR*inv(G');
end
% (4) The spectral density shutting off everything but the global demand shock:
a0=aa0*diag([0 0 1]');
VAR=a0*a0';
for ww=1:length(w)
    G=eye(N);
    for aa=1:size(A,3)
        G=G-A(:,:,aa)*exp(-i*aa*w(ww));
    end
    SS_S(:,:,ww)=inv(G)*VAR*inv(G');
end
%oil price inflation
Pinfl=real(squeeze(SSS(2,2,:)));  %spectral density
NPinfl=Pinfl/sum(Pinfl);          %normalized spectral density=spectral density/variance(integral of spectral density)
NPinflM=real(squeeze(SS_M(2,2,:)))/sum(Pinfl);
NPinflD=real(squeeze(SS_D(2,2,:)))/sum(Pinfl);
NPinflS=real(squeeze(SS_S(2,2,:)))/sum(Pinfl);
zzpers(kk,:)=[NPinfl(1) [NPinflM(1) NPinflD(1) NPinflS(1)]/NPinfl(1)];
%variance decomposition for oil price
NPinflMv=sum(real(squeeze(SS_M(2,2,:))))/sum(Pinfl);
NPinflDv=sum(real(squeeze(SS_D(2,2,:))))/sum(Pinfl);
NPinflSv=sum(real(squeeze(SS_S(2,2,:))))/sum(Pinfl);
zzvarPO(kk,:)=[NPinflMv NPinflDv NPinflSv];

%oil production growth
Pqoil=real(squeeze(SSS(1,1,:)));  %spectral density
%variance decomposition for oil quantity
NPqoilMv=sum(real(squeeze(SS_M(1,1,:))))/sum(Pqoil);
NPqoilDv=sum(real(squeeze(SS_D(1,1,:))))/sum(Pqoil);
NPqoilSv=sum(real(squeeze(SS_S(1,1,:))))/sum(Pqoil);
zzvarQO(kk,:)=[NPqoilMv NPqoilDv NPqoilSv];
end

%contains oil inflation persistence and contribution of oil supply,
%oil-specific demand and global demand shocks to persistence (in that
%order) at frequency zero:
zpers=mean(zzpers,1);
zvarpo=mean(zzvarPO,1);
zvarqo=mean(zzvarQO,1);
