function [sd1,sd2,ss1,ss2,d1,s1,s2]=oilmarket_model(sirf,dirf,aggirf)

%s1 is slope of supply with oil-specific
%d1 is slope of demand
%s2 is slope of supply with global
%Christiane Baumeister
%June 2008

dQdS=sirf(1,1);      %after oil supply shock
dPdS=sirf(1,2);
dQdD1=dirf(1,1);     %after demand shock: once oil-specific
dPdD1=dirf(1,2);
dQdD2=aggirf(1,1);   %after demand shock: once global
dPdD2=aggirf(1,2);

A=dPdS;
B=dQdS;
C=dPdD1;
D=dQdD1;
E=dPdD2;
F=dQdD2;

d1=dQdS/dPdS; %elasticity in the demand equation
s1=dQdD1/dPdD1;
s2=dQdD2/dPdD2;

%magnitude of oil-specific demand shock over all horizons
sd1=D-(C.*d1);

%magnitude of global demand shock over all horizons
sd2=F-(E.*d1);

%magnitude of supply shock over all horizons derived with oil-specific
ss1=-(A.*s1)+B;

%magnitude of supply shock over all horizons derived with global
ss2=-(A.*s2)+B;
