function [sirf,dirf,aggirf,ind,d]=GIRFs_N3_exact(sd,aa,qd,s1,s2,vd,om,YY,HOR,N,L,cors,NMCInteg,h,SC,D)
%
%Christiane Baumeister
%July 2011
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                             Simulating the elements of the VAR into the future:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                   (1) Simulating the covariance matrix:
% The shocks to the matrix A:
aa_e=real(sqrtm([s1 zeros(1,2); zeros(2,1) s2]))*randn(3,HOR+L+1);
% Simulating the elements of the matrix A:
for jj=1:HOR+L+1
    aa(:,:,jj+1)=aa(:,:,jj)+aa_e(:,jj);
end
%
% The shocks to the stochastic volatilities:
om_e=diag(vd)*randn(N,HOR+L+1);
% Simulating the matrix OM:
om=log(om);
for jj=1:HOR+L+1
    om(:,:,jj+1)=om(:,:,jj)+om_e(:,jj);
end
om=exp(om);

VAR=zeros(N,N,HOR+L+1);
% The VAR's reduced-form covariance matrix:
for jj=1:HOR+L+1
    invA=inv(chofac(N,aa(:,:,jj)));
    VAR(:,:,jj)=invA*diag(om(:,:,jj))*invA'; % The variance-covariance matrix of the VAR
end
VARC=VAR(:,:,1);
%VAR=VAR(:,:,2:HOR+L+1);     %variance-covariance matrix

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                       (2) Simulating the matrix B:
B=zeros(N,N*L+1,HOR+L+1);
jj=2; % Simulating the matrix B:
trial=0;
maxtrial=50;
while jj<=HOR+L+1
    dd=sd(:,:,jj-1)+real(mysqrt_varm(qd))*randn(N*(1+N*L),1);
    b=[dd(1:1+N*L,1)'; dd((1+N*L)+1:2*(1+N*L),1)'; dd(2*(1+N*L)+1:3*(1+N*L),1)'];
    
    if SC==0
        sd(:,:,jj)=dd;
        B(:,:,jj)=b;
        jj=jj+1;
        
    else
    if max(abs(varroots(L,N,b)))<1
        sd(:,:,jj)=dd;
        B(:,:,jj)=b;
        jj=jj+1;
        trial=0;
    elseif max(abs(varroots(L,N,b)))>1 && trial<maxtrial
        trial=trial+1;
    elseif max(abs(varroots(L,N,b)))>1 && trial==maxtrial
        sirf=[];
        dirf=[];
        aggirf=[];
        ind=0;
        d=0;
        return
    end
    end
end
%
%B=B(:,:,2:HOR+L+1);    %time-varying coefficient matrix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                             The GIRFs:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
iroil1=zeros(NMCInteg,HOR);
iroil2=iroil1;
iroil3=iroil1;

irdem1=iroil1;
irdem2=iroil1;
irdem3=iroil1;

iragg1=iroil1;
iragg2=iroil1;
iragg3=iroil1;

tel=0;
count=0;
maxcount=2500;

while tel<NMCInteg && count<maxcount
    count=count+1;
 
a0=impact(VARC,N);        %contemporaneous impact matrix  

%deterministic rotation to impose single zero restriction in place(3,2):
%Luca's method:
%Theta=atan(a0(3,2)/a0(3,3)); 
%RR=[1 zeros(1,2); zeros(2,1) [cos(Theta) -sin(Theta); sin(Theta) cos(Theta)]];
%a0=a0*RR

%Given's rotation
ra0=sqrt(a0(3,2)^2+a0(3,3)^2);
s0=-a0(3,2)/ra0;
c0=a0(3,3)/ra0;
%alternative computation (might be more stable):
%ra0=-a0(3,3)/a(3,2);
%s0=1/sqrt(1+ra0^2);
%c0=s0*ra0;
%rotation matrix:
RM=[1 zeros(1,2); 0 c0 -s0; 0 s0 c0];
a0=a0*RM;

         
Y_BEN1=[YY zeros(N,HOR+3-L)];
Y_OILS=Y_BEN1;
Y_OILD=Y_BEN1;
Y_OILA=Y_BEN1;
SHOCKS=randn(N,HOR);  %same shocks for oil supply and demand shock IRFs
% The impact:
Y_BEN1(:,L+1)=a0*SHOCKS(:,1);
Y_OILS(:,L+1)=a0*[1+SHOCKS(1,1) SHOCKS(2:3,1)']';  
Y_OILD(:,L+1)=a0*[SHOCKS(1,1) 1+SHOCKS(2,1) SHOCKS(3,1)]'; 
Y_OILA(:,L+1)=a0*[SHOCKS(1:2,1)' 1+SHOCKS(3,1)]'; 
%
for tt=L+2:HOR+L
    shocks=mysqrt_varm(VAR(:,:,tt-L))*SHOCKS(:,tt-L);
    Y_BEN1(:,tt)=B(:,:,tt-L)*[1; myvec(myfliplr(Y_BEN1(:,tt-L:tt-1)))]+shocks;
    Y_OILS(:,tt)=B(:,:,tt-L)*[1; myvec(myfliplr(Y_OILS(:,tt-L:tt-1)))]+shocks;
    Y_OILD(:,tt)=B(:,:,tt-L)*[1; myvec(myfliplr(Y_OILD(:,tt-L:tt-1)))]+shocks;
    Y_OILA(:,tt)=B(:,:,tt-L)*[1; myvec(myfliplr(Y_OILA(:,tt-L:tt-1)))]+shocks;
end
%
Y_BEN1=Y_BEN1(:,L+1:size(Y_BEN1,2));   %3x20 matrices
Y_OILS=Y_OILS(:,L+1:size(Y_OILS,2));
Y_OILD=Y_OILD(:,L+1:size(Y_OILD,2));
Y_OILA=Y_OILA(:,L+1:size(Y_OILA,2));

%calculate the impulse responses as difference between baseline and shock
%case:

irf1=Y_OILS-Y_BEN1;   %IRF after 1st shock: 3x20 matrix i.e. response of all 3 variables to first shock
ir1=cumsum(irf1,2);
irf2=Y_OILD-Y_BEN1;   %IRF after 2nd shock
ir2=cumsum(irf2,2);
irf3=Y_OILA-Y_BEN1;   %IRF after 3rd shock
ir3=cumsum(irf3,2);

irf=zeros(N,N,HOR);   %not-accumulated
for jx=1:HOR
    irf(:,:,jx)=[irf1(:,jx) irf2(:,jx) irf3(:,jx)];    %contains all IRFs
end

%check the sign restrictions:
ir=zeros(N,N,HOR);    %accumulated
for jx=1:HOR
    ir(:,:,jx)=[ir1(:,jx) ir2(:,jx) ir3(:,jx)];    %contains all IRFs
end
clear ir1 ir2 ir3 irf1 irf2 irf3

ncorr=9;              %number of sign correlations
co=zeros(cors+h,ncorr);
    
for sh=1:N
    for k=1:cors+h
            co(k,1+N*(sh-1))=ir(1,sh,k)/ir(1,sh,cors);    %normalization
            if D==1
            co(k,2+N*(sh-1))=ir(2,sh,k)/ir(1,sh,cors);
            co(k,3+N*(sh-1))=ir(3,sh,k)/ir(1,sh,cors);
            else
            co(k,2+N*(sh-1))=irf(2,sh,k)/ir(1,sh,cors);
            co(k,3+N*(sh-1))=irf(3,sh,k)/ir(1,sh,cors);
            end
    end
end
    
s1is=0;
s2is=0;
s3is=0;
    
%%%Sign restrictions
    if h==4
    % oil supply shock 
    
    if co(cors,1)>=0 && co(cors+1,1)>=0 && co(cors+2,1)>=0 && co(cors+3,1)>=0 && co(cors+4,1)>=0 && ...
            co(cors,2)<=0 && co(cors+1,2)<=0 && co(cors+2,2)<=0 && co(cors+3,2)<=0 && co(cors+4,2)<=0 && ...
            co(cors,3)>=0 && co(cors+1,3)>=0 && co(cors+2,3)>=0 && co(cors+3,3)>=0 && co(cors+4,3)>=0
        s1is=100;
    end
%     if co(cors,4)>=0 && co(cors+1,4)>=0 && co(cors+2,4)>=0 && co(cors+3,4)>=0 && co(cors+4,4)>=0 && ...
%             co(cors,5)<=0 && co(cors+1,5)<=0 && co(cors+2,5)<=0 && co(cors+3,5)<=0 && co(cors+4,5)<=0 && ...
%             co(cors,6)>=0 && co(cors+1,6)>=0 && co(cors+2,6)>=0 && co(cors+3,6)>=0 && co(cors+4,6)>=0
%         s2is=100;
%     end
    if co(cors,7)>=0 && co(cors+1,7)>=0 && co(cors+2,7)>=0 && co(cors+3,7)>=0 && co(cors+4,7)>=0 && ...
            co(cors,8)<=0 && co(cors+1,8)<=0 && co(cors+2,8)<=0 && co(cors+3,8)<=0 && co(cors+4,8)<=0 && ...
            co(cors,9)>=0 && co(cors+1,9)>=0 && co(cors+2,9)>=0 && co(cors+3,9)>=0 && co(cors+4,9)>=0 
        s3is=100;
    end
    
    
    % pecautionary oil-specific demand shock
    
%     if co(cors,1)>=0 && co(cors+1,1)>=0 && co(cors+2,1)>=0 && co(cors+3,1)>=0 && co(cors+4,1)>=0 && ...
%             co(cors,2)>=0 && co(cors+1,2)>=0 && co(cors+2,2)>=0 && co(cors+3,2)>=0 && co(cors+4,2)>=0 && ...
%             co(cors,3)<=0 && co(cors+1,3)<=0 && co(cors+2,3)<=0 && co(cors+3,3)<=0 && co(cors+4,3)<=0
%         s1is=10;
%     end
    if co(cors,4)>=0 && co(cors+1,4)>=0 && co(cors+2,4)>=0 && co(cors+3,4)>=0 && co(cors+4,4)>=0 && ...
            co(cors,5)>=0 && co(cors+1,5)>=0 && co(cors+2,5)>=0 && co(cors+3,5)>=0 && co(cors+4,5)>=0
        s2is=10;
    end
%     if co(cors,7)>=0 && co(cors+1,7)>=0 && co(cors+2,7)>=0 && co(cors+3,7)>=0 && co(cors+4,7)>=0 && ...
%             co(cors,8)>=0 && co(cors+1,8)>=0 && co(cors+2,8)>=0 && co(cors+3,8)>=0 && co(cors+4,8)>=0 && ...
%             co(cors,9)<=0 && co(cors+1,9)<=0 && co(cors+2,9)<=0 && co(cors+3,9)<=0 && co(cors+4,9)<=0
%         s3is=10;
%     end
        
        
    % global demand shock
    
    if co(cors,1)>=0 && co(cors+1,1)>=0 && co(cors+2,1)>=0 && co(cors+3,1)>=0 && co(cors+4,1)>=0 && ...
            co(cors,2)>=0 && co(cors+1,2)>=0 && co(cors+2,2)>=0 && co(cors+3,2)>=0 && co(cors+4,2)>=0 && ...
            co(1,3)>0 && co(2,3)>0 && co(3,3)>0 && co(4,3)>0 && co(5,3)>0
        s1is=1;
    end
%     if co(cors,4)>=0 && co(cors+1,4)>=0 && co(cors+2,4)>=0 && co(cors+3,4)>=0 && co(cors+4,4)>=0 && ...
%             co(cors,5)>=0 && co(cors+1,5)>=0 && co(cors+2,5)>=0 && co(cors+3,5)>=0 && co(cors+4,5)>=0 && ...
%             co(1,6)>0 && co(2,6)>0 && co(3,6)>0 && co(4,6)>0 && co(5,6)>0
%         s2is=1;
%     end
    if co(cors,7)>=0 && co(cors+1,7)>=0 && co(cors+2,7)>=0 && co(cors+3,7)>=0 && co(cors+4,7)>=0 && ...
            co(cors,8)>=0 && co(cors+1,8)>=0 && co(cors+2,8)>=0 && co(cors+3,8)>=0 && co(cors+4,8)>=0 && ...
            co(1,9)>0 && co(2,9)>0 && co(3,9)>0 && co(4,9)>0 && co(5,9)>0
        s3is=1; 
    end
    
    elseif h==1
        
    if co(cors,1)>=0 && co(cors,2)<=0 && co(cors,3)>=0 
        s1is=100;
    end
%     if co(cors,4)>=0 && co(cors,5)<=0 && co(cors,6)>=0 
%         s2is=100;
%     end
    if co(cors,7)>=0 && co(cors,8)<=0 && co(cors,9)>=0  
        s3is=100;
    end
    
    
    % pecautionary oil-specific demand shock
    
%     if co(cors,1)>=0 && co(cors,2)>=0 && co(cors,3)<=0 
%         s1is=10;
%     end
    if co(cors,4)>=0 && co(cors,5)>=0  
        s2is=10;
    end
%     if co(cors,7)>=0 && co(cors,8)>=0 && co(cors,9)<=0 
%         s3is=10;
%     end
        
        
    % global demand shock
    
    if co(cors,1)>=0 && co(cors,2)>=0 && co(1,3)>0 
        s1is=1;
    end
%     if co(cors,4)>=0 && co(cors,5)>=0 && co(1,6)>0 
%         s2is=1;
%     end
    if co(cors,7)>=0 && co(cors,8)>=0 && co(1,9)>0
        s3is=1; 
    end
        
    end
        
identot=s1is+s2is+s3is;
clear co

if identot==111
   tel=tel+1;
            
    %shock 1
  
        if s1is==100
               iroil1(tel,1:HOR)=ir(1,1,1:HOR);
               if D==1
               iroil2(tel,1:HOR)=ir(2,1,1:HOR);
               iroil3(tel,1:HOR)=ir(3,1,1:HOR);
               else
               iroil2(tel,1:HOR)=irf(2,1,1:HOR);
               iroil3(tel,1:HOR)=irf(3,1,1:HOR);
               end
        end
        
%         if s1is==10
%                irdem1(tel,1:HOR)=ir(1,1,1:HOR);
%                if D==1
%                irdem2(tel,1:HOR)=ir(2,1,1:HOR);
%                irdem3(tel,1:HOR)=ir(3,1,1:HOR);
%                else
%                irdem2(tel,1:HOR)=irf(2,1,1:HOR);
%                irdem3(tel,1:HOR)=irf(3,1,1:HOR);
%                end
%         end
        
        if s1is==1
               iragg1(tel,1:HOR)=ir(1,1,1:HOR);
               if D==1
               iragg2(tel,1:HOR)=ir(2,1,1:HOR);
               iragg3(tel,1:HOR)=ir(3,1,1:HOR);  
               else
               iragg2(tel,1:HOR)=irf(2,1,1:HOR);
               iragg3(tel,1:HOR)=irf(3,1,1:HOR);
               end
        end
                
        %shock 2
  
%         if s2is==100
%                 iroil1(tel,1:HOR)=ir(1,2,1:HOR);
%                 if D==1
%                 iroil2(tel,1:HOR)=ir(2,2,1:HOR);
%                 iroil3(tel,1:HOR)=ir(3,2,1:HOR); 
%                 else
%                 iroil2(tel,1:HOR)=irf(2,2,1:HOR);
%                 iroil3(tel,1:HOR)=irf(3,2,1:HOR);
%                 end
%         end
        
        if s2is==10
               irdem1(tel,1:HOR)=ir(1,2,1:HOR);
               if D==1
               irdem2(tel,1:HOR)=ir(2,2,1:HOR);
               irdem3(tel,1:HOR)=ir(3,2,1:HOR);
               else
               irdem2(tel,1:HOR)=irf(2,2,1:HOR);
               irdem3(tel,1:HOR)=irf(3,2,1:HOR);
               end
        end
        
%         if s2is==1
%                iragg1(tel,1:HOR)=ir(1,2,1:HOR);
%                if D==1
%                iragg2(tel,1:HOR)=ir(2,2,1:HOR);
%                iragg3(tel,1:HOR)=ir(3,2,1:HOR);
%                else
%                iragg2(tel,1:HOR)=irf(2,2,1:HOR);
%                iragg3(tel,1:HOR)=irf(3,2,1:HOR);
%                end
%         end
    
       %shock 3
  
        if s3is==100
                iroil1(tel,1:HOR)=ir(1,3,1:HOR);
                if D==1
                iroil2(tel,1:HOR)=ir(2,3,1:HOR);
                iroil3(tel,1:HOR)=ir(3,3,1:HOR);  
                else
                iroil2(tel,1:HOR)=irf(2,3,1:HOR);
                iroil3(tel,1:HOR)=irf(3,3,1:HOR);
                end
        end
        
%         if s3is==10
%                irdem1(tel,1:HOR)=ir(1,3,1:HOR);
%                if D==1
%                irdem2(tel,1:HOR)=ir(2,3,1:HOR);
%                irdem3(tel,1:HOR)=ir(3,3,1:HOR);
%                else
%                irdem2(tel,1:HOR)=irf(2,3,1:HOR);
%                irdem3(tel,1:HOR)=irf(3,3,1:HOR);
%                end
%         end
        
        if s3is==1
               iragg1(tel,1:HOR)=ir(1,3,1:HOR);
               if D==1
               iragg2(tel,1:HOR)=ir(2,3,1:HOR);
               iragg3(tel,1:HOR)=ir(3,3,1:HOR); 
               else
               iragg2(tel,1:HOR)=irf(2,3,1:HOR);
               iragg3(tel,1:HOR)=irf(3,3,1:HOR);
               end
        end
        
end

end

%[count tel]

if count==maxcount
    sirf=[];
    dirf=[];
    aggirf=[];
    ind=0;
    d=0;
    return
else ind=1;
     d=1;
end

tester1=iragg3(:,1);
tester2=irdem2(:,1);
tester3=iroil2(:,1);   
vts1=zeros(tel,1);
vts2=zeros(tel,1);
vts3=zeros(tel,1);

for jx=1:tel
    
    if tester1(jx,1)>0
        vts1(jx,1)=1;
    else vts1(jx,1)=-1;
    end
    
    if tester2(jx,1)>0
        vts2(jx,1)=1;
    else vts2(jx,1)=-1;
    end
        
    if tester3(jx,1)>0
        vts3(jx,1)=1;
    else vts3(jx,1)=-1;
    end
    
end

%impulse responses

for jy=1:HOR
    iroil1(:,jy)=vts3.*iroil1(:,jy);
    iroil2(:,jy)=vts3.*iroil2(:,jy);
    iroil3(:,jy)=vts3.*iroil3(:,jy);
end

for jy=1:HOR
    irdem1(:,jy)=vts2.*irdem1(:,jy);
    irdem2(:,jy)=vts2.*irdem2(:,jy);
    irdem3(:,jy)=vts2.*irdem3(:,jy);
end

for jy=1:HOR
    iragg1(:,jy)=vts1.*iragg1(:,jy);
    iragg2(:,jy)=vts1.*iragg2(:,jy);
    iragg3(:,jy)=vts1.*iragg3(:,jy);
end


%IRFs to oil supply shock
gem11=mean(iroil1);    %imp resp of QO to oil supply shock
gem21=mean(iroil2);    %imp resp of PO to oil supply shock
gem31=mean(iroil3);    %imp resp of Y to oil supply shock

%IRFs to oil-specific demand shock
gem12=mean(irdem1);    %imp resp of QO to oil-specific demand shock
gem22=mean(irdem2);    %imp resp of PO to oil-specific demand shock
gem32=mean(irdem3);    %imp resp of Y to oil-specific demand shock

%IRFs to aggregate demand shock
gem13=mean(iragg1);    %imp resp of QO to aggregate demand shock
gem23=mean(iragg2);    %imp resp of PO to aggregate demand shock
gem33=mean(iragg3);    %imp resp of Y to aggregate demand shock

sirf=[gem11' gem21' gem31'];      %response of all three variables to oil supply shock 
dirf=[gem12' gem22' gem32'];      %response of all three variables to precautionary demand shock
aggirf=[gem13' gem23' gem33'];    %response of all three variables to aggregate demand shock

