%imposing the upper bound on the 2 oil supply elasticities and the demand
%elasticity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%4 corresponds to 1974Q1 for benchmark model; 1 corresponds to 1974Q1 for
%Kilian model
st=4;
tt=TIME(st:end,1);
%ind=[5 R-4];
ind=[1 R];
esuppd=ones(R,size(TIME,1)-st+1);
esuppa=ones(R,size(TIME,1)-st+1);
eladem=-ones(R,size(TIME,1)-st+1);

for jx=st:size(TIME,1)
    x1=sort(slope_S_D(:,jx));
    x2=sort(slope_S_A(:,jx));
    x3=sort(slope_D_D(:,jx));
    j1=find(slope_S_D(:,jx)>x1(ind(1),1) & slope_S_D(:,jx)<x1(ind(2),1));
    j2=find(slope_S_A(:,jx)>x2(ind(1),1) & slope_S_A(:,jx)<x2(ind(2),1));
    j3=find(slope_D_D(:,jx)>x3(ind(1),1) & slope_D_D(:,jx)<x3(ind(2),1));
    f1=NaN(500,3);
    clear x1 x2 x3
    
    for jxx=1:(ind(2)-ind(1)-1)
    f1(j1(jxx,1),1)=j1(jxx,1);
    f1(j2(jxx,1),2)=j2(jxx,1);
    f1(j3(jxx,1),3)=j3(jxx,1);
    end
    
    jy=1;
    for jyy=1:500
    if(f1(jyy,1)==jyy && f1(jyy,2)==jyy && f1(jyy,3)==jyy);
        findex(jy,1)=jyy;
        jy=jy+1;
    end
    end
    clear j1 j2 j3

esuppd(1:size(findex,1),jx-st+1)=slope_S_D(findex,jx);
esuppa(1:size(findex,1),jx-st+1)=slope_S_A(findex,jx);
eladem(1:size(findex,1),jx-st+1)=slope_D_D(findex,jx);

end
% esuppd=slope_S_D(:,st:end);
% esuppa=slope_S_A(:,st:end);
% eladem=slope_D_D(:,st:end);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ja=NaN(501,size(TIME,1)-st+1);
for jy=1:size(esuppd,2)
jj=find(esuppd(:,jy)<=0.6 & esuppa(:,jy)<=0.6 & eladem(:,jy)>=-0.8);
%NOTE: 0.55 is the lowest value in order to find at least one draw that
%satisfies the upper bound on the supply elasticity!!!
ja(1:size(jj,1),jy)=jj;
end


jy=1;
jx=1;
elas_d=NaN(501,size(TIME,1)-st+1);
elas_a=NaN(501,size(TIME,1)-st+1);
edem=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            elas_d(jy,jx)=esuppd(ja(jy,jx),jx);
            elas_a(jy,jx)=esuppa(ja(jy,jx),jx);
            edem(jy,jx)=eladem(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


eds=sort(elas_d);
eda=sort(elas_a);
edd=sort(edem);

xad=zeros(size(eds,2),3);
xaa=zeros(size(eda,2),3);
xdd=zeros(size(edd,2),3);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(eds(jy,jx));
        if (index==1)
            r=jy-1;
            %median
            xad(jx,1)=median(eds(1:r,jx));
            xaa(jx,1)=median(eda(1:r,jx));
            xdd(jx,1)=median(edd(1:r,jx));
            %upper
            xad(jx,2)=(eds(1,jx));
            xaa(jx,2)=(eda(1,jx));
            xdd(jx,2)=(edd(r,jx));
            %lower
            xad(jx,3)=(eds(r,jx));
            xaa(jx,3)=(eda(r,jx));
            xdd(jx,3)=(edd(1,jx));
            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end

%this index calculates how many models satisfy the bounds at each point in
%time
indexm=sum(isnan(ja)*(-1)+1)';

% figure(1111)
% subplot(2,2,1)
% plot(tt,xaa(:,1),'b','LineWidth',3), hold on, plot(tt,xad(:,1),'r:','LineWidth',3)
% title('Oil supply elasticity','Fontsize',14)
% axis tight
% %xlabel('time')
% subplot(2,2,2)
% plot(tt,xdd(:,1),'b','LineWidth',3)
% title('Oil demand elasticity','Fontsize',14)
% axis tight
%xlabel('time')
% subplot(2,2,3)
% bar(tt,index,'b','LineWidth',2)
% title('Number of models that satisfy all upper bounds')
% xlabel('time')
% ylabel('Draws')
% axis tight

mdd=xdd(:,1);
maa=xaa(:,1);
mad=xad(:,1);

save bench_medianELAS mdd maa mad

% for jxx=1:3
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'Q',6,32);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'Q',6,32);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xad(:,jxx),'Q',6,32);
%     xad(:,jxx)=(yN+yC);
% end

% for jxx=1:3
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'A',4,12);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'A',4,12);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xds(:,jxx),'A',4,12);
%     xds(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xas(:,jxx),'A',4,12);
%     xas(:,jxx)=(yN+yC);
% end


figure(4)
subplot(3,2,1)
plotx1([maa xaa(:,2:3)],TIME(st:end,1)) 
box on
title('Oil supply elasticity with aggregate demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 0.85])
set(gca,'YTick',0:0.2:0.8)
set(gca,'XTick',1975:5:2010)
subplot(3,2,3)
plotx1([mad xad(:,2:3)],TIME(st:end,1)) 
box on
title('Oil supply elasticity with other oil demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 0.85])
set(gca,'YTick',0:0.2:0.8)
set(gca,'XTick',1975:5:2010)
subplot(3,2,5)
plotx1([mdd xdd(:,2:3)],TIME(st:end,1)) 
box on
title('Oil demand elasticity','Fontsize',14)
axis([tt(1) tt(end) -0.85 0.05])
set(gca,'YTick',-0.8:0.2:0)
set(gca,'XTick',1975:5:2010)

load bench_medianELAS8
load bench_medianELAS10

figure(45)
subplot(3,2,1)
plot(TIME(st:end,1),xaa(:,1),'b','linewidth',3), hold on, plot(TIME(st:end,1),maa8,'rx','linewidth',2), hold on, plot(TIME(st:end,1),maa10,'k:','linewidth',3) 
box on
title('Oil supply elasticity with aggregate demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
subplot(3,2,3)
plot(TIME(st:end,1),xad(:,1),'b','linewidth',3), hold on, plot(TIME(st:end,1),mad8,'rx','linewidth',2), hold on, plot(TIME(st:end,1),mad10,'k:','linewidth',3)  
box on
title('Oil supply elasticity with other oil demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
subplot(3,2,5)
plot(TIME(st:end,1),xdd(:,1),'b','linewidth',3), hold on, plot(TIME(st:end,1),mdd8,'rx','linewidth',2), hold on, plot(TIME(st:end,1),mdd10,'k:','linewidth',3)  
box on
title('Oil demand elasticity','Fontsize',14)
axis([tt(1) tt(end) -1 0.05])
set(gca,'YTick',-1:0.2:0)
set(gca,'XTick',1975:5:2010)



% figure(41)
% subplot(2,2,1)
% plotx1(xaa,TIME(st:end,1)), hold on, plot(TIME(st:end,1),xad(:,1),'k:','Linewidth',3)
% box on
% title('Oil supply elasticities','Fontsize',16)
% axis([tt(1) tt(end) -0.05 0.85])
% set(gca,'YTick',0:0.2:0.8)
% set(gca,'XTick',1975:5:2010)
% % subplot(2,2,1)
% % plotx1(xad,TIME(st:end,1)); box on
% % title('Oil supply elasticity with other oil demand','Fontsize',14)
% % axis([1974 2010.75 0 0.6])
% % set(gca,'YTick',0:0.2:0.6)
% % set(gca,'XTick',1975:5:2010)
% subplot(2,2,3)
% plotx1(xdd,TIME(st:end,1)); box on
% title('Oil demand elasticity','Fontsize',16)
% axis([tt(1) tt(end) -0.85 0.05])
% set(gca,'YTick',-0.8:0.2:0)
% set(gca,'XTick',1975:5:2010)


% figure(2221)
% subplot(2,2,1)
% plotx1(xaa,TIME(st:end,1)); box on
% title('Oil supply elasticity with global oil demand','Fontsize',14)
% axis([1974 2010.75 0 0.6])
% set(gca,'YTick',0:0.2:0.6)
% set(gca,'XTick',1975:5:2010)
% subplot(2,2,3)
% plotx1(xad,TIME(st:end,1)); box on
% title('Oil supply elasticity with other oil demand','Fontsize',14)
% axis([1974 2010.75 0 0.6])
% set(gca,'YTick',0:0.2:0.6)
% set(gca,'XTick',1975:5:2010)
% subplot(2,2,2)
% plotx1(xdd,TIME(st:end,1)); box on
% title('Oil demand elasticity','Fontsize',14)
% axis([1974 2010.75 -0.8 0])
% set(gca,'YTick',-0.8:0.2:0)
% set(gca,'XTick',1975:5:2010)
% subplot(2,2,4)
% bar(tt,indexm,'b')
% title('Number of models that satisfy all bounds','Fontsize',14)
% ylabel('Draws','Fontsize',11)
% axis tight
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %Figure 3A (TV tests of elasticities)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ssd=elas_dc; %supply elasticity with oil-specific demand
% ssa=elas_ac; %supply elasticity with global demand
% sdd=edemc;   %demand elasticity
% index=[12-3 26-3 52-3 70-3 144-3];  % in TIME: 1976Q1(12), 1979Q3(26), 1986Q1(52), 1990Q3(70), 2009Q1(144)
% 
% figure(11)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Oil supply elasticity with oil-specific
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% subplot(4,5,1)
% scatter(ssd(:,index(1)),ssd(:,index(2)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1976Q1','Fontsize',11)
% ylabel('1979Q3','Fontsize',11)
% subplot(4,5,2)
% scatter(ssd(:,index(2)),ssd(:,index(3)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1986Q1','Fontsize',11)
% subplot(4,5,3)
% scatter(ssd(:,index(2)),ssd(:,index(4)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1990Q3','Fontsize',11)
% subplot(4,5,4)
% scatter(ssd(:,index(1)),ssd(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1976Q1','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% subplot(4,5,5)
% scatter(ssd(:,index(4)),ssd(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1990Q3','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Oil supply elasticity with global
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% subplot(4,5,6)
% scatter(ssa(:,index(1)),ssa(:,index(2)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1976Q1','Fontsize',11)
% ylabel('1979Q3','Fontsize',11)
% subplot(4,5,7)
% scatter(ssa(:,index(2)),ssa(:,index(3)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1986Q1','Fontsize',11)
% subplot(4,5,8)
% scatter(ssa(:,index(2)),ssa(:,index(4)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1990Q3','Fontsize',11)
% subplot(4,5,9)
% scatter(ssa(:,index(1)),ssa(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1976Q1','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% subplot(4,5,10)
% scatter(ssa(:,index(4)),ssa(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
% axis([0 0.6 0 0.6])
% set(gca,'XTick',0:0.3:0.6)
% set(gca,'YTick',0:0.3:0.6)
% xlabel('1990Q3','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% Oil demand elasticity
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% subplot(4,5,11)
% scatter(sdd(:,index(1)),sdd(:,index(2)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
% axis([-0.8 0 -0.8 0])
% set(gca,'XTick',-0.8:0.4:0)
% set(gca,'YTick',-0.8:0.4:0)
% xlabel('1976Q1','Fontsize',11)
% ylabel('1979Q3','Fontsize',11)
% subplot(4,5,12)
% scatter(sdd(:,index(2)),sdd(:,index(3)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
% axis([-0.8 0 -0.8 0])
% set(gca,'XTick',-0.8:0.4:0)
% set(gca,'YTick',-0.8:0.4:0)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1986Q1','Fontsize',11)
% subplot(4,5,13)
% scatter(sdd(:,index(2)),sdd(:,index(4)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
% axis([-0.8 0 -0.8 0])
% set(gca,'XTick',-0.8:0.4:0)
% set(gca,'YTick',-0.8:0.4:0)
% xlabel('1979Q3','Fontsize',11)
% ylabel('1990Q3','Fontsize',11)
% subplot(4,5,14)
% scatter(sdd(:,index(1)),sdd(:,index(5)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
% axis([-0.8 0 -0.8 0])
% set(gca,'XTick',-0.8:0.4:0)
% set(gca,'YTick',-0.8:0.4:0)
% xlabel('1976Q1','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% subplot(4,5,15)
% scatter(sdd(:,index(4)),sdd(:,index(5)),'.'), hold on, plot([-0.8 0]',[-0.8 0]','k','LineWidth',2), box on
% axis([-0.8 0 -0.8 0])
% set(gca,'XTick',-0.8:0.4:0)
% set(gca,'YTick',-0.8:0.4:0)
% xlabel('1990Q3','Fontsize',11)
% ylabel('2009Q1','Fontsize',11)
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Figure 5 (magnitude of structural shocks)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
shock_DD=shock_D_D(:,st:end);
shock_AA=shock_A_A(:,st:end);
shock_SD=shock_S_D(:,st:end);
shock_SA=shock_S_A(:,st:end);

jy=1;
jx=1;
shock_dd=NaN(501,size(TIME,1)-st+1);
shock_aa=NaN(501,size(TIME,1)-st+1);
shock_sd=NaN(501,size(TIME,1)-st+1);
shock_sa=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            shock_dd(jy,jx)=shock_DD(ja(jy,jx),jx);
            shock_aa(jy,jx)=shock_AA(ja(jy,jx),jx);
            shock_sd(jy,jx)=shock_SD(ja(jy,jx),jx);
            shock_sa(jy,jx)=shock_SA(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


sdd=sort(shock_dd);
saa=sort(shock_aa);
dds=sort(shock_sd);
aas=sort(shock_sa);

xdd=zeros(size(sdd,2),3);
xaa=zeros(size(saa,2),3);
xds=zeros(size(dds,2),3);
xas=zeros(size(aas,2),3);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(sdd(jy,jx));
        if (index==1)
            r=jy-1;
            %median
            xdd(jx,1)=median(sdd(1:r,jx));
            xaa(jx,1)=median(saa(1:r,jx));
            xds(jx,1)=median(dds(1:r,jx));
            xas(jx,1)=median(aas(1:r,jx));
            %upper
            xdd(jx,2)=(sdd(1,jx));
            xaa(jx,2)=(saa(1,jx));
            xds(jx,2)=(dds(1,jx));
            xas(jx,2)=(aas(1,jx));
            %lower
            xdd(jx,3)=(sdd(r,jx));
            xaa(jx,3)=(saa(r,jx));
            xds(jx,3)=(dds(r,jx));
            xas(jx,3)=(aas(r,jx));
            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end

mdd=xdd(:,1);
maa=xaa(:,1);
mds=xds(:,1);
mas=xas(:,1);

% for jxx=1:3
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'Q',8,32);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'Q',8,32);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xds(:,jxx),'Q',8,32);
%     xds(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xas(:,jxx),'Q',8,32);
%     xas(:,jxx)=(yN+yC);
% end

for jxx=1:3
    [yN,yC,yI]=cffilter(xdd(:,jxx),'A',4,12);
    xdd(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xaa(:,jxx),'A',4,12);
    xaa(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xds(:,jxx),'A',4,12);
    xds(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xas(:,jxx),'A',4,12);
    xas(:,jxx)=(yN+yC);
end


figure(5)
subplot(3,3,5)
plotx1(xdd,TIME(st:end,1)); box on
title('Other oil demand shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)
subplot(3,3,2)
plotx1(xaa,TIME(st:end,1)); box on
title('Aggregate demand shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)
% subplot(2,2,2)
% plotx1(-xds,TIME(st:end,1)); box on
% title('Oil supply shock with other oil demand','Fontsize',14)
% axis([1974 2010.75 0 10])
% set(gca,'YTick',0:2:10)
% set(gca,'XTick',1975:5:2010)
subplot(3,3,8)
plotx1(-xas,TIME(st:end,1))%, hold on, plot(TIME(st:end,1),-xds(:,1),'k:','Linewidth',3)
box on
title('Oil supply shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)

% figure(5551)
% subplot(3,3,5)
% plotx1([mdd xdd(:,2:3)],TIME(st:end,1)); box on
% title('Other oil demand shock','Fontsize',14)
% axis([tt(1) tt(end) 0 13])
% set(gca,'YTick',0:2:12)
% set(gca,'XTick',1975:5:2010)
% subplot(3,3,2)
% plotx1([maa xaa(:,2:3)],TIME(st:end,1)); box on
% title('Global oil demand shock','Fontsize',14)
% axis([tt(1) tt(end) 0 13])
% set(gca,'YTick',0:2:12)
% set(gca,'XTick',1975:5:2010)
% % subplot(2,2,2)
% % plotx1(-xds,TIME(st:end,1)); box on
% % title('Oil supply shock with other oil demand','Fontsize',14)
% % axis([1974 2010.75 0 10])
% % set(gca,'YTick',0:2:10)
% % set(gca,'XTick',1975:5:2010)
% subplot(3,3,8)
% plotx1([-mas -xas(:,2:3)],TIME(st:end,1)), hold on, plot(TIME(st:end,1),-mds(:,1),'k:','Linewidth',3)
% box on
% title('Oil supply shocks','Fontsize',14)
% axis([tt(1) tt(end) 0 13])
% set(gca,'YTick',0:2:12)
% set(gca,'XTick',1975:5:2010)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 3A (TV tests of elasticities)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ssd=elas_d; %supply elasticity with oil-specific demand
ssa=elas_a; %supply elasticity with global demand
sdd=edem;   %demand elasticity
index=[12-3 26-3 52-3 70-3 144-3];  % in TIME: 1976Q1(12), 1979Q3(26), 1986Q1(52), 1990Q3(70), 2009Q1(144)

m=5;
figure(31)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Oil supply elasticity with oil-specific
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(m,5,6)
scatter(ssd(:,index(1)),ssd(:,index(2)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1976Q1','Fontsize',11)
ylabel('1979Q3','Fontsize',11)
subplot(m,5,7)
scatter(ssd(:,index(2)),ssd(:,index(3)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1979Q3','Fontsize',11)
ylabel('1986Q1','Fontsize',11)
subplot(m,5,8)
scatter(ssd(:,index(2)),ssd(:,index(4)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1979Q3','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(m,5,9)
scatter(ssd(:,index(1)),ssd(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1976Q1','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(m,5,10)
scatter(ssd(:,index(4)),ssd(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1990Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Oil supply elasticity with aggregate
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(m,5,1)
scatter(ssa(:,index(1)),ssa(:,index(2)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1976Q1','Fontsize',11)
ylabel('1979Q3','Fontsize',11)
subplot(m,5,2)
scatter(ssa(:,index(2)),ssa(:,index(3)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1979Q3','Fontsize',11)
ylabel('1986Q1','Fontsize',11)
subplot(m,5,3)
scatter(ssa(:,index(2)),ssa(:,index(4)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1979Q3','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(m,5,4)
scatter(ssa(:,index(1)),ssa(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1976Q1','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(m,5,5)
scatter(ssa(:,index(4)),ssa(:,index(5)),'.'), hold on, plot([0 0.6]',[0 0.6]','k','LineWidth',2), box on
axis([0 0.6 0 0.6])
set(gca,'XTick',0:0.3:0.6)
set(gca,'YTick',0:0.3:0.6)
xlabel('1990Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Oil demand elasticity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(m,5,11)
scatter(sdd(:,index(1)),sdd(:,index(2)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
axis([-0.8 0 -0.8 0])
set(gca,'XTick',-0.8:0.4:0)
set(gca,'YTick',-0.8:0.4:0)
xlabel('1976Q1','Fontsize',11)
ylabel('1979Q3','Fontsize',11)
subplot(m,5,12)
scatter(sdd(:,index(2)),sdd(:,index(3)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
axis([-0.8 0 -0.8 0])
set(gca,'XTick',-0.8:0.4:0)
set(gca,'YTick',-0.8:0.4:0)
xlabel('1979Q3','Fontsize',11)
ylabel('1986Q1','Fontsize',11)
subplot(m,5,13)
scatter(sdd(:,index(2)),sdd(:,index(4)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
axis([-0.8 0 -0.8 0])
set(gca,'XTick',-0.8:0.4:0)
set(gca,'YTick',-0.8:0.4:0)
xlabel('1979Q3','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(m,5,14)
scatter(sdd(:,index(1)),sdd(:,index(5)),'.'), hold on, plot([-.8 0]',[-.8 0]','k','LineWidth',2), box on
axis([-0.8 0 -0.8 0])
set(gca,'XTick',-0.8:0.4:0)
set(gca,'YTick',-0.8:0.4:0)
xlabel('1976Q1','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(m,5,15)
scatter(sdd(:,index(4)),sdd(:,index(5)),'.'), hold on, plot([-0.8 0]',[-0.8 0]','k','LineWidth',2), box on
axis([-0.8 0 -0.8 0])
set(gca,'XTick',-0.8:0.4:0)
set(gca,'YTick',-0.8:0.4:0)
xlabel('1990Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)


