%imposing the upper bound on the 2 oil supply elasticities and the demand
%elasticity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%4 corresponds to 1974Q1 for benchmark model; 1 corresponds to 1974Q1 for
%Kilian model
st=4;
tt=TIME(st:end,1);
%ind=[5 R-4];
ind=[1 R];
esuppd=ones(R,size(TIME,1)-st+1);
esuppa=ones(R,size(TIME,1)-st+1);
eladem=-ones(R,size(TIME,1)-st+1);

for jx=st:size(TIME,1)
    x1=sort(slope_S_D(:,jx));
    x2=sort(slope_S_A(:,jx));
    x3=sort(slope_D_D(:,jx));
    j1=find(slope_S_D(:,jx)>x1(ind(1),1) & slope_S_D(:,jx)<x1(ind(2),1));
    j2=find(slope_S_A(:,jx)>x2(ind(1),1) & slope_S_A(:,jx)<x2(ind(2),1));
    j3=find(slope_D_D(:,jx)>x3(ind(1),1) & slope_D_D(:,jx)<x3(ind(2),1));
    f1=NaN(500,3);
    clear x1 x2 x3
    
    for jxx=1:(ind(2)-ind(1)-1)
    f1(j1(jxx,1),1)=j1(jxx,1);
    f1(j2(jxx,1),2)=j2(jxx,1);
    f1(j3(jxx,1),3)=j3(jxx,1);
    end
    
    jy=1;
    for jyy=1:500
    if(f1(jyy,1)==jyy && f1(jyy,2)==jyy && f1(jyy,3)==jyy);
        findex(jy,1)=jyy;
        jy=jy+1;
    end
    end
    clear j1 j2 j3

esuppd(1:size(findex,1),jx-st+1)=slope_S_D(findex,jx);
esuppa(1:size(findex,1),jx-st+1)=slope_S_A(findex,jx);
eladem(1:size(findex,1),jx-st+1)=slope_D_D(findex,jx);

end
% esuppd=slope_S_D(:,st:end);
% esuppa=slope_S_A(:,st:end);
% eladem=slope_D_D(:,st:end);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ja=NaN(501,size(TIME,1)-st+1);
for jy=1:size(esuppd,2)
jj=find(esuppd(:,jy)<=0.6 & esuppa(:,jy)<=0.6 & eladem(:,jy)>=-0.8);
%NOTE: 0.55 is the lowest value in order to find at least one draw that
%satisfies the upper bound on the supply elasticity!!!
ja(1:size(jj,1),jy)=jj;
end


jy=1;
jx=1;
elas_d=NaN(501,size(TIME,1)-st+1);
elas_a=NaN(501,size(TIME,1)-st+1);
edem=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            elas_d(jy,jx)=esuppd(ja(jy,jx),jx);
            elas_a(jy,jx)=esuppa(ja(jy,jx),jx);
            edem(jy,jx)=eladem(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


eds=sort(elas_d);
eda=sort(elas_a);
edd=sort(edem);

xad=zeros(size(eds,2),7);
xaa=zeros(size(eda,2),7);
xdd=zeros(size(edd,2),7);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(eds(jy,jx));
        if (index==1)
            r=jy-1;
            PERC=fix(r*[0.5 0.025 0.975 0.16 0.84]');
            if PERC(2,1)==0
                PERC(2,1)=1;
            end
            %median
            xad(jx,1:5)=eds(PERC,jx);
            xaa(jx,1:5)=eda(PERC,jx);
            xdd(jx,1:5)=edd(PERC,jx);
            %upper
            xad(jx,6)=(eds(1,jx));
            xaa(jx,6)=(eda(1,jx));
            xdd(jx,6)=(edd(r,jx));
            %lower
            xad(jx,7)=(eds(r,jx));
            xaa(jx,7)=(eda(r,jx));
            xdd(jx,7)=(edd(1,jx));
            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end

%this index calculates how many models satisfy the bounds at each point in
%time
indexm=sum(isnan(ja)*(-1)+1)';

% figure(1111)
% subplot(2,2,1)
% plot(tt,xaa(:,1),'b','LineWidth',3), hold on, plot(tt,xad(:,1),'r:','LineWidth',3)
% title('Oil supply elasticity','Fontsize',14)
% axis tight
% %xlabel('time')
% subplot(2,2,2)
% plot(tt,xdd(:,1),'b','LineWidth',3)
% title('Oil demand elasticity','Fontsize',14)
% axis tight
%xlabel('time')
% subplot(2,2,3)
% bar(tt,index,'b','LineWidth',2)
% title('Number of models that satisfy all upper bounds')
% xlabel('time')
% ylabel('Draws')
% axis tight

mdd=xdd(:,1);
maa=xaa(:,1);
mad=xad(:,1);

%save bench_medianELAS mdd maa mad

% for jxx=1:3
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'Q',6,32);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'Q',6,32);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xad(:,jxx),'Q',6,32);
%     xad(:,jxx)=(yN+yC);
% end

% for jxx=1:3
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'A',4,12);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'A',4,12);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xds(:,jxx),'A',4,12);
%     xds(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xas(:,jxx),'A',4,12);
%     xas(:,jxx)=(yN+yC);
% end


figure(4)
subplot(3,2,1)
plotx2(xaa(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),xaa(:,6:7),'k','LineWidth',1) 
box on
title('Oil supply elasticity with aggregate demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 0.85])
set(gca,'YTick',0:0.2:0.8)
set(gca,'XTick',1975:5:2010)
subplot(3,2,3)
plotx2(xad(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),xad(:,6:7),'k','LineWidth',1)  
box on
title('Oil supply elasticity with other oil demand shock','Fontsize',14)
axis([tt(1) tt(end) -0.05 0.85])
set(gca,'YTick',0:0.2:0.8)
set(gca,'XTick',1975:5:2010)
subplot(3,2,5)
plotx2(xdd(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),xdd(:,6:7),'k','LineWidth',1)  
box on
title('Oil demand elasticity','Fontsize',14)
axis([tt(1) tt(end) -0.85 0.05])
set(gca,'YTick',-0.8:0.2:0)
set(gca,'XTick',1975:5:2010)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Figure 5 (magnitude of structural shocks)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
shock_DD=shock_D_D(:,st:end);
shock_AA=shock_A_A(:,st:end);
shock_SD=shock_S_D(:,st:end);
shock_SA=shock_S_A(:,st:end);

jy=1;
jx=1;
shock_dd=NaN(501,size(TIME,1)-st+1);
shock_aa=NaN(501,size(TIME,1)-st+1);
shock_sd=NaN(501,size(TIME,1)-st+1);
shock_sa=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            shock_dd(jy,jx)=shock_DD(ja(jy,jx),jx);
            shock_aa(jy,jx)=shock_AA(ja(jy,jx),jx);
            shock_sd(jy,jx)=shock_SD(ja(jy,jx),jx);
            shock_sa(jy,jx)=shock_SA(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


sdd=sort(shock_dd);
saa=sort(shock_aa);
dds=sort(shock_sd);
aas=sort(shock_sa);

xdd=zeros(size(sdd,2),7);
xaa=zeros(size(saa,2),7);
xds=zeros(size(dds,2),7);
xas=zeros(size(aas,2),7);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(sdd(jy,jx));
        if (index==1)
            r=jy-1;
            PERC=fix(r*[0.5 0.025 0.975 0.16 0.84]');
            if PERC(2,1)==0
                PERC(2,1)=1;
            end
            %median
            xdd(jx,1:5)=sdd(PERC,jx);
            xaa(jx,1:5)=saa(PERC,jx);
            xds(jx,1:5)=dds(PERC,jx);
            xas(jx,1:5)=aas(PERC,jx);
            %upper
            xdd(jx,6)=(sdd(1,jx));
            xaa(jx,6)=(saa(1,jx));
            xds(jx,6)=(dds(1,jx));
            xas(jx,6)=(aas(1,jx));
            %lower
            xdd(jx,7)=(sdd(r,jx));
            xaa(jx,7)=(saa(r,jx));
            xds(jx,7)=(dds(r,jx));
            xas(jx,7)=(aas(r,jx));
            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end

mdd=xdd(:,1);
maa=xaa(:,1);
mds=xds(:,1);
mas=xas(:,1);

% for jxx=1:7
%     [yN,yC,yI]=cffilter(xdd(:,jxx),'Q',8,32);
%     xdd(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xaa(:,jxx),'Q',8,32);
%     xaa(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xds(:,jxx),'Q',8,32);
%     xds(:,jxx)=(yN+yC);
%     [yN,yC,yI]=cffilter(xas(:,jxx),'Q',8,32);
%     xas(:,jxx)=(yN+yC);
% end

for jxx=1:7
    [yN,yC,yI]=cffilter(xdd(:,jxx),'A',4,12);
    xdd(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xaa(:,jxx),'A',4,12);
    xaa(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xds(:,jxx),'A',4,12);
    xds(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(xas(:,jxx),'A',4,12);
    xas(:,jxx)=(yN+yC);
end


figure(5)
subplot(3,3,5)
plotx2(xdd(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),xdd(:,6:7),'k','LineWidth',1) 
box on
title('Other oil demand shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)
subplot(3,3,2)
plotx2(xaa(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),xaa(:,6:7),'k','LineWidth',1)  
box on
title('Aggregate demand shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)
% subplot(2,2,2)
% plotx1(-xds,TIME(st:end,1)); box on
% title('Oil supply shock with other oil demand','Fontsize',14)
% axis([1974 2010.75 0 10])
% set(gca,'YTick',0:2:10)
% set(gca,'XTick',1975:5:2010)
subplot(3,3,8)
plotx2(-xas(:,1:5),TIME(st:end,1)), hold on, plot(TIME(st:end,1),-xas(:,6:7),'k','LineWidth',1)
box on
title('Oil supply shock','Fontsize',14)
axis([tt(1) tt(end) 0 13])
set(gca,'YTick',0:4:12)
set(gca,'XTick',1975:5:2010)