%raw data for oil production and oil price
qo=y(1+TP*4+L:end,1);
po=y(1+TP*4+L:end,2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 1, panel A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1) 
subplot(2,3,2)
plot(TIME(s:end),qo(s:end),TIME(s:end),zeros(length(TIME(s:end)),1),'k:','LineWidth',2)
axis([TIME(s) TIME(length(TIME)) -8 8])
set(gca,'YTick',-8:2:8)
set(gca,'XTick',1975:5:2010)
title('World oil production growth','Fontsize',14)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
subplot(2,3,1)
plot(TIME(s:end),po(s:end),TIME(s:end),zeros(length(TIME(s:end)),1),'k:','LineWidth',2)
axis([TIME(s) TIME(length(TIME)) -80 40])
set(gca,'YTick',-80:20:40)
set(gca,'XTick',1975:5:2010)
title('Changes in the real oil price','Fontsize',14)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 1, panel B
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[S1,S2,STDRATE,STDINFL]=getvolatilities_variables(L,N,NN,DFILE2);
index=[125 NN-124];  %implies 95% coverage of the entire distribution
%index=[1 NN];
%load bench_volaQOPO
%S1=SD1;
%S2=SD2;

figure(2)
subplot(2,3,2) 
x1=sort(S1);
temp1=[(median(x1))' (x1(index(1),:))' (x1(index(2),:)')];
plotx1(temp1(2*s:end,:),TIME(s:end,1)); box on
axis tight
set(gca,'XTick',1975:5:2010)
set(gca,'YTick',0:0.5:5.5)
title('Standard deviation of world oil production','Fontsize',14)
subplot(2,3,1) 
x1=sort(S2);
temp1=[(median(x1))' (x1(index(1),:))' (x1(index(2),:)')];
plotx1(temp1(2*s:end,:),TIME(s:end,1)); box on
axis tight
set(gca,'XTick',1975:5:2010)
set(gca,'YTick',0:5:40)
title('Standard deviation of the real oil price','Fontsize',14)

%calculate standard deviations over rolling windows (5 years)
k=5*4;                %determines length of rolling window: 5 years
qo_sd=vol_roll(y(:,1),k);
po_sd=vol_roll(y(:,2),k);
%index=[20 NN-20];

%alternative Figure 1, panel B that includes std dev from rolling window
figure(21)
subplot(2,3,2) 
x1=sort(S1);
temp1=[(median(x1))' (x1(index(1),:))' (x1(index(2),:)')];
plotx1(temp1(2*s:end,:),TIME(s:end,1)), hold on, plot(TIME(s:end,1),qo_sd(88:end,1),'r:','LineWidth',3); box on
axis([TIME(s) TIME(length(TIME)) 0 6])
set(gca,'XTick',1975:5:2010)
set(gca,'YTick',0:1:6)
title('Standard deviation of world oil production','Fontsize',14)
subplot(2,3,1) 
x1=sort(S2);
temp1=[(median(x1))' (x1(index(1),:))' (x1(index(2),:)')];
plotx1(temp1(2*s:end,:),TIME(s:end,1)), hold on, plot(TIME(s:end,1),po_sd(88:end,1),'r:','LineWidth',3); box on
axis([TIME(s) TIME(length(TIME)) 0 70])
title('Standard deviation of the real oil price','Fontsize',14)
set(gca,'XTick',1975:5:2010)
set(gca,'YTick',0:10:70)
legend('95% of distribution','median','5-year rolling window')
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 2A (time variation test on estimated volatilities)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sd1=S1(:,2*s:end);
sd2=S2(:,2*s:end);
%select points in time for comparison of significance of time variation
index=[26-3 52-3 70-3 144-3];  %1979Q3(26), 1986Q1(52), 1990Q3(70), 2009Q1(144)
%bilateral scatter plots for the 2 volatilities for QO and PO
%displayed in Figure 1, panel B
n=5;
figure(3)
subplot(n,n,2)
scatter(sd1(:,index(1)),sd1(:,index(2)),'.'), hold on, plot([0 8]',[0 8]','k','LineWidth',2), box on
axis([0 8 0 8])
set(gca,'XTick',0:4:8)
set(gca,'YTick',0:4:8)
xlabel('1979Q3','Fontsize',11)
ylabel('1986Q1','Fontsize',11)
title('World oil production','Fontsize',12)
subplot(n,n,1)
scatter(sd2(:,index(1)),sd2(:,index(2)),'.'), hold on, plot([0 50]',[0 50]','k','LineWidth',2), box on
axis([0 50 0 50])
set(gca,'XTick',0:25:50)
set(gca,'YTick',0:25:50)
xlabel('1979Q3','Fontsize',11)
ylabel('1986Q1','Fontsize',11)
title('Real oil price','Fontsize',12)
subplot(n,n,7)
scatter(sd1(:,index(2)),sd1(:,index(3)),'.'), hold on, plot([0 7]',[0 7]','k','LineWidth',2), box on
axis([0 7 0 7])
set(gca,'XTick',0:3.5:7)
set(gca,'YTick',0:3.5:7)
xlabel('1979Q3','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(n,n,6)
scatter(sd2(:,index(2)),sd2(:,index(3)),'.'), hold on, plot([0 100]',[0 100]','k','LineWidth',2), box on
axis([0 100 0 100])
set(gca,'XTick',0:50:100)
set(gca,'YTick',0:50:100)
xlabel('1979Q3','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(n,n,12)
scatter(sd1(:,index(2)),sd1(:,index(4)),'.'), hold on, plot([0 7]',[0 7]','k','LineWidth',2), box on
axis([0 7 0 7])
set(gca,'XTick',0:3.5:7)
set(gca,'YTick',0:3.5:7)
xlabel('1986Q1','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(n,n,11)
scatter(sd2(:,index(2)),sd2(:,index(4)),'.'), hold on, plot([0 100]',[0 100]','k','LineWidth',2), box on
axis([0 100 0 100])
set(gca,'XTick',0:50:100)
set(gca,'YTick',0:50:100)
xlabel('1986Q1','Fontsize',11)
ylabel('1990Q3','Fontsize',11)
subplot(n,n,17)
scatter(sd1(:,index(2)),sd1(:,index(3)),'.'), hold on, plot([0 7]',[0 7]','k','LineWidth',2), box on
axis([0 7 0 7])
set(gca,'XTick',0:3.5:7)
set(gca,'YTick',0:3.5:7)
xlabel('1979Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(n,n,16)
scatter(sd2(:,index(2)),sd2(:,index(3)),'.'), hold on, plot([0 100]',[0 100]','k','LineWidth',2), box on
axis([0 100 0 100])
set(gca,'XTick',0:50:100)
set(gca,'YTick',0:50:100)
xlabel('1979Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(n,n,22)
scatter(sd1(:,index(3)),sd1(:,index(4)),'.'), hold on, plot([0 5]',[0 5]','k','LineWidth',2), box on
axis([0 5 0 5])
set(gca,'XTick',0:2.5:5)
set(gca,'YTick',0:2.5:5)
xlabel('1990Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)
subplot(n,n,21)
scatter(sd2(:,index(3)),sd2(:,index(4)),'.'), hold on, plot([0 100]',[0 100]','k','LineWidth',2), box on
axis([0 100 0 100])
set(gca,'XTick',0:50:100)
set(gca,'YTick',0:50:100)
xlabel('1990Q3','Fontsize',11)
ylabel('2009Q1','Fontsize',11)

