%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PERSISTENCE MEASURES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%imposing the upper bound on the 2 oil supply elasticities and the demand
%elasticity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%st=4 corresponds to 1974Q1 for benchmark model; st=11 corresponds to 1974Q1 for
%Kilian model
st=4;
tt=TIME(st:end,1);
%ind=[5 R-4];
ind=[1 R];
esuppd=ones(R,size(TIME,1)-st+1);
esuppa=ones(R,size(TIME,1)-st+1);
eladem=-ones(R,size(TIME,1)-st+1);

for jx=st:size(TIME,1)
    x1=sort(slope_S_D(:,jx));
    x2=sort(slope_S_A(:,jx));
    x3=sort(slope_D_D(:,jx));
    j1=find(slope_S_D(:,jx)>x1(ind(1),1) & slope_S_D(:,jx)<x1(ind(2),1));
    j2=find(slope_S_A(:,jx)>x2(ind(1),1) & slope_S_A(:,jx)<x2(ind(2),1));
    j3=find(slope_D_D(:,jx)>x3(ind(1),1) & slope_D_D(:,jx)<x3(ind(2),1));
    f1=NaN(500,3);
    clear x1 x2 x3
    
    for jxx=1:(ind(2)-ind(1)-1)
    f1(j1(jxx,1),1)=j1(jxx,1);
    f1(j2(jxx,1),2)=j2(jxx,1);
    f1(j3(jxx,1),3)=j3(jxx,1);
    end
    
    jy=1;
    for jyy=1:500
    if(f1(jyy,1)==jyy && f1(jyy,2)==jyy && f1(jyy,3)==jyy);
        findex(jy,1)=jyy;
        jy=jy+1;
    end
    end
    clear j1 j2 j3

esuppd(1:size(findex,1),jx-st+1)=slope_S_D(findex,jx);
esuppa(1:size(findex,1),jx-st+1)=slope_S_A(findex,jx);
eladem(1:size(findex,1),jx-st+1)=slope_D_D(findex,jx);

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ja=NaN(501,size(TIME,1)-st+1);
for jy=1:size(esuppd,2)
jj=find(esuppd(:,jy)<=0.6 & esuppa(:,jy)<=0.6 & eladem(:,jy)>=-0.8);
%NOTE: 0.6 is the lowest value in order to find at least one draw that
%satisfies the upper bound on the supply elasticity!!!
ja(1:size(jj,1),jy)=jj;
end

%%%persistence: POPERSIST contains the persistence of oil price and the
%%%contribution of the three shocks to the persistenc of oil price (fractions)
p1=squeeze(POPERSIST(1,:,st:end));
p2=squeeze(POPERSIST(2,:,st:end));
p3=squeeze(POPERSIST(3,:,st:end));
p4=squeeze(POPERSIST(4,:,st:end));

jy=1;
jx=1;
pp1=NaN(501,size(TIME,1)-st+1);
pp2=NaN(501,size(TIME,1)-st+1);
pp3=NaN(501,size(TIME,1)-st+1);
pp4=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            pp1(jy,jx)=p1(ja(jy,jx),jx);
            pp2(jy,jx)=p2(ja(jy,jx),jx);
            pp3(jy,jx)=p3(ja(jy,jx),jx);
            pp4(jy,jx)=p4(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


p1s=sort(pp1);
p2s=sort(pp2);
p3s=sort(pp3);
p4s=sort(pp4);

pers1=zeros(size(p1s,2),5);
pers2=zeros(size(p2s,2),5);
pers3=zeros(size(p3s,2),5);
pers4=zeros(size(p4s,2),5);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(p1s(jy,jx));
        if (index==1)
            r=jy-1;
            PERC=fix(r*[0.5 0.025 0.975 0.16 0.84]');
            if PERC(2,1)==0
                PERC(2,1)=1;
            end
            %median
            pers1(jx,:)=(p1s(PERC,jx));
            pers2(jx,:)=(p2s(PERC,jx));
            pers3(jx,:)=(p3s(PERC,jx));
            pers4(jx,:)=(p4s(PERC,jx));
            
            
            %median
%             pers1(jx,1)=median(p1s(1:r,jx));
%             pers2(jx,1)=median(p2s(1:r,jx));
%             pers3(jx,1)=median(p3s(1:r,jx));
%             pers4(jx,1)=median(p4s(1:r,jx));
%             %upper
%             pers1(jx,2)=(p1s(1,jx));
%             pers2(jx,2)=(p2s(1,jx));
%             pers3(jx,2)=(p3s(1,jx));
%             pers4(jx,2)=(p4s(1,jx));
%             %lower
%             pers1(jx,3)=(p1s(r,jx));
%             pers2(jx,3)=(p2s(r,jx));
%             pers3(jx,3)=(p3s(r,jx));
%             pers4(jx,3)=(p4s(r,jx));

            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end


for jxx=1:5
    [yN,yC,yI]=cffilter(pers1(:,jxx),'A',4,12);
    pers1(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers2(:,jxx),'A',4,12);
    pers2(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers3(:,jxx),'A',4,12);
    pers3(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers4(:,jxx),'A',4,12);
    pers4(:,jxx)=(yN+yC);
end

%index1=[125 NN-124];  % 95% coverage
index1=fix(NN*[0.025 0.975 0.16 0.84]');
[NormSpecAtZero]=persistencePO(DFILE2,N,L);
%load('C:\CHRISTIANE\research\projects\BP2\codes\bench_reduced_persist.mat')
figure(555)
subplot(2,2,1)
x1=sort(NormSpecAtZero,2);
temp1=[(median(x1,2)) (x1(:,index1(1))) (x1(:,index1(2))) (x1(:,index1(3))) (x1(:,index1(4)))];
plotx2(1*temp1(2*s:end,:),TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 0.1])
set(gca,'YTick',0:0.02:0.1)
set(gca,'XTick',1975:5:2010)
title('Persistence of real oil price inflation','Fontsize',14)

%decomposition of oil price persistence not reported in the paper
% figure(5552)
% subplot(2,2,1)
% x1=sort(NormSpecAtZero,2);
% temp1=[(median(x1,2)) (x1(:,index1(1))) (x1(:,index1(2))) (x1(:,index1(3))) (x1(:,index1(4)))];
% plotx2(1*temp1(2*s:end,:),TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 0.1])
% set(gca,'YTick',0:0.02:0.1)
% set(gca,'XTick',1975:5:2010)
% title('Persistence of real oil price inflation','Fontsize',14)
% subplot(2,2,2)
% plotx2(pers2,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% title('Oil supply shock','Fontsize',14)
% %%%%%%%%%%%%%%%%%%
% subplot(2,2,3)
% plotx2(pers3,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% title('Other oil demand shock','Fontsize',14)
% %%%%%%%%%%%%%%%%%
% subplot(2,2,4)
% plotx2(pers4,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% title('Aggregate demand shock','Fontsize',14)

