%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% VARIANCE DECOMPOSITION
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%imposing the upper bound on the 2 oil supply elasticities and the demand
%elasticity
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%st=4 corresponds to 1974Q1 for benchmark model; st=1 corresponds to 1974Q1 for
%Kilian model
st=4;
tt=TIME(st:end,1);
%ind=[5 R-4];
ind=[1 R];
esuppd=ones(R,size(TIME,1)-st+1);
esuppa=ones(R,size(TIME,1)-st+1);
eladem=-ones(R,size(TIME,1)-st+1);

for jx=st:size(TIME,1)
    x1=sort(slope_S_D(:,jx));
    x2=sort(slope_S_A(:,jx));
    x3=sort(slope_D_D(:,jx));
    j1=find(slope_S_D(:,jx)>x1(ind(1),1) & slope_S_D(:,jx)<x1(ind(2),1));
    j2=find(slope_S_A(:,jx)>x2(ind(1),1) & slope_S_A(:,jx)<x2(ind(2),1));
    j3=find(slope_D_D(:,jx)>x3(ind(1),1) & slope_D_D(:,jx)<x3(ind(2),1));
    f1=NaN(500,3);
    clear x1 x2 x3
    
    for jxx=1:(ind(2)-ind(1)-1)
    f1(j1(jxx,1),1)=j1(jxx,1);
    f1(j2(jxx,1),2)=j2(jxx,1);
    f1(j3(jxx,1),3)=j3(jxx,1);
    end
    
    jy=1;
    for jyy=1:500
    if(f1(jyy,1)==jyy && f1(jyy,2)==jyy && f1(jyy,3)==jyy);
        findex(jy,1)=jyy;
        jy=jy+1;
    end
    end
    clear j1 j2 j3

esuppd(1:size(findex,1),jx-st+1)=slope_S_D(findex,jx);
esuppa(1:size(findex,1),jx-st+1)=slope_S_A(findex,jx);
eladem(1:size(findex,1),jx-st+1)=slope_D_D(findex,jx);

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ja=NaN(501,size(TIME,1)-st+1);
for jy=1:size(esuppd,2)
jj=find(esuppd(:,jy)<=0.6 & esuppa(:,jy)<=0.6 & eladem(:,jy)>=-0.8);
%NOTE: 0.6 is the lowest value in order to find at least one draw that
%satisfies the upper bound on the supply elasticity!!!
ja(1:size(jj,1),jy)=jj;
end

%%%Variance decomposition (frequency domain)

p1=squeeze(VARDECOPO(1,:,st:end));
p2=squeeze(VARDECOPO(2,:,st:end));
p3=squeeze(VARDECOPO(3,:,st:end));
p4=squeeze(VARDECOQO(1,:,st:end));
p5=squeeze(VARDECOQO(2,:,st:end));
p6=squeeze(VARDECOQO(3,:,st:end));

jy=1;
jx=1;
pp1=NaN(501,size(TIME,1)-st+1);
pp2=NaN(501,size(TIME,1)-st+1);
pp3=NaN(501,size(TIME,1)-st+1);
pp4=NaN(501,size(TIME,1)-st+1);
pp5=NaN(501,size(TIME,1)-st+1);
pp6=NaN(501,size(TIME,1)-st+1);
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(ja(jy,jx));
        if (index==0) 
            pp1(jy,jx)=p1(ja(jy,jx),jx);
            pp2(jy,jx)=p2(ja(jy,jx),jx);
            pp3(jy,jx)=p3(ja(jy,jx),jx);
            pp4(jy,jx)=p4(ja(jy,jx),jx);
            pp5(jy,jx)=p5(ja(jy,jx),jx);
            pp6(jy,jx)=p6(ja(jy,jx),jx);
            jy=jy+1;
        elseif (index==1)
            break
        end
     end
     jx=jx+1;
     jy=1;
end


p1s=sort(pp1);
p2s=sort(pp2);
p3s=sort(pp3);
p4s=sort(pp4);
p5s=sort(pp5);
p6s=sort(pp6);

pers1=zeros(size(p1s,2),5);
pers2=zeros(size(p2s,2),5);
pers3=zeros(size(p3s,2),5);
pers4=zeros(size(p4s,2),5);
pers5=zeros(size(p5s,2),5);
pers6=zeros(size(p6s,2),5);
jy=1;
jx=1;
while jx<=size(TIME,1)-st+1
     while jy<=501
            index=DetectNaN(p1s(jy,jx));
        if (index==1)
            r=jy-1;
            PERC=fix(r*[0.5 0.025 0.975 0.16 0.84]');
            if PERC(2,1)==0
                PERC(2,1)=1;
            end
            %median
            pers1(jx,:)=(p1s(PERC,jx));
            pers2(jx,:)=(p2s(PERC,jx));
            pers3(jx,:)=(p3s(PERC,jx));
            pers4(jx,:)=(p4s(PERC,jx));
            pers5(jx,:)=(p5s(PERC,jx));
            pers6(jx,:)=(p6s(PERC,jx));
            
%             %median
%             pers1(jx,1)=median(p1s(1:r,jx));
%             pers2(jx,1)=median(p2s(1:r,jx));
%             pers3(jx,1)=median(p3s(1:r,jx));
%             pers4(jx,1)=median(p4s(1:r,jx));
%             pers5(jx,1)=median(p5s(1:r,jx));
%             pers6(jx,1)=median(p6s(1:r,jx));
%             %upper
%             pers1(jx,2)=(p1s(1,jx));
%             pers2(jx,2)=(p2s(1,jx));
%             pers3(jx,2)=(p3s(1,jx));
%             pers4(jx,2)=(p4s(1,jx));
%             pers5(jx,2)=(p5s(1,jx));
%             pers6(jx,2)=(p6s(1,jx));
%             %lower
%             pers1(jx,3)=(p1s(r,jx));
%             pers2(jx,3)=(p2s(r,jx));
%             pers3(jx,3)=(p3s(r,jx));
%             pers4(jx,3)=(p4s(r,jx));
%             pers5(jx,3)=(p5s(r,jx));
%             pers6(jx,3)=(p6s(r,jx));

            break
        else jy=jy+1;
        end
     end
     jx=jx+1;
     jy=1;
end

% mdd=xdd(:,1);
% maa=xaa(:,1);
% mds=xds(:,1);
% mas=xas(:,1);

for jxx=1:5
    [yN,yC,yI]=cffilter(pers1(:,jxx),'A',4,12);
    pers1(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers2(:,jxx),'A',4,12);
    pers2(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers3(:,jxx),'A',4,12);
    pers3(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers4(:,jxx),'A',4,12);
    pers4(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers5(:,jxx),'A',4,12);
    pers5(:,jxx)=(yN+yC);
    [yN,yC,yI]=cffilter(pers6(:,jxx),'A',4,12);
    pers6(:,jxx)=(yN+yC);
end

% figure(666)
% subplot(3,2,1)
% plotx1(pers1,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Oil supply shock','Fontsize',12)
% subplot(3,2,3)
% plotx1(pers2,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Oil-specific demand shock','Fontsize',12)
% subplot(3,2,5)
% plotx1(pers3,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Global demand shock','Fontsize',12)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% subplot(3,2,2)
% plotx1(pers4,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Oil supply shock','Fontsize',12)
% subplot(3,2,4)
% plotx1(pers5,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Oil-Specific demand shock','Fontsize',12)
% subplot(3,2,6)
% plotx1(pers6,TIME(s:end,1)); box on
% axis([tt(1) tt(end) 0 1])
% set(gca,'YTick',0:0.2:1)
% set(gca,'XTick',1975:5:2010)
% %xlabel('time')
% title('Global demand shock','Fontsize',12)


figure(81)
subplot(3,2,1)
plotx2(pers1,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Oil supply shock','Fontsize',12)
subplot(3,2,3)
plotx2(pers2,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Other oil demand shock','Fontsize',12)
subplot(3,2,5)
plotx2(pers3,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Aggregate demand shock','Fontsize',12)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(3,2,2)
plotx2(pers4,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Oil supply shock','Fontsize',12)
subplot(3,2,4)
plotx2(pers5,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Other oil demand shock','Fontsize',12)
subplot(3,2,6)
plotx2(pers6,TIME(s:end,1)); box on
axis([tt(1) tt(end) 0 1])
set(gca,'YTick',0:0.2:1)
set(gca,'XTick',1975:5:2010)
%xlabel('time')
title('Aggregate demand shock','Fontsize',12)
