function convergence_check(nvar,DFILE2)

load(DFILE2)
NN=size(SD,3)-1;
%
% Variables:
% SD: States (time-varying parameters in the VAR)
% QD: State innovation covariance matrix (the matrix Q)
% AA: Non-zero and non-one elements in lower diagonal block of matrix A(t) in Primiceri, stacked in a vector
% UU: VAR residuals
% OM: The volatilities
% S1: S1
% S2: S2
% S3: S3
% S4: S4
% VD: Standard deviation of vol. innovation
%
clear UU
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%               Checking for convergence of the ergodic chain, based on the inefficiency factors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% SD: States (time-varying parameters in the VAR)
for hh=1:size(SD,1)
    for kk=1:size(SD,2)
        x=squeeze(SD(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
    %hh   %has to reach 39
end
%
IF_theta=IF(:);
%
save theta IF_theta
clear IF IF_theta SD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% QD: State innovation covariance matrix (the matrix Q)
for hh=1:size(QD,1)
    for kk=hh:size(QD,1)
        x=squeeze(QD(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IFF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
IFF=IFF';
%
IF=[];
for hh=1:size(QD,2)
    IF=[IF; IFF(hh:size(IFF,1),hh)];
end
clear IFF
IF_Q=IF;
%
save qmat IF_Q
clear IF IF_Q QD
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% VD: Standard deviation of vol. innovation
VD=VD';
%
for hh=1:size(VD,2)
    x=squeeze(VD(:,hh));
    [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
    P0=Py(1);
    Py=[fliplr(Py(2:length(Py)-1)') Py'];
    IF(hh,1)=1/(sum(Py)/(P0*2*pi));
end
%
IF_V=IF;
save vola IF_V
clear IF IF_V VD
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% S1: S1
S1=S1';
%
x=S1(2:NN);
[omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
P0=Py(1);
Py=[fliplr(Py(2:length(Py)-1)') Py'];
IF(1,1)=1/(sum(Py)/(P0*2*pi));
%
% S2: S2
for hh=1:size(S2,1)
    for kk=hh:size(S2,1)
        x=squeeze(S2(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IFF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
IFF=IFF';
%
for hh=1:size(S2,2)
    IF=[IF; IFF(hh:size(IFF,1),hh)];
end
clear IFF
%
% S3: S3
if nvar==4
for hh=1:size(S3,1)
    for kk=hh:size(S3,1)
        x=squeeze(S3(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IFF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
IFF=IFF';
%
for hh=1:size(S3,2)
    IF=[IF; IFF(hh:size(IFF,1),hh)];
end
clear IFF

elseif nvar==5
    for hh=1:size(S3,1)
    for kk=hh:size(S3,1)
        x=squeeze(S3(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IFF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
    end
IFF=IFF';
%
for hh=1:size(S3,2)
    IF=[IF; IFF(hh:size(IFF,1),hh)];
end
clear IFF
% S4: S4
for hh=1:size(S4,1)
    for kk=hh:size(S4,1)
        x=squeeze(S4(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IFF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
IFF=IFF';
%
for hh=1:size(S4,2)
    IF=[IF; IFF(hh:size(IFF,1),hh)];
end
clear IFF

end
%
IF_s=IF;
save volAA IF_s
clear IF IF_s S1 S2 S3 S4
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% AA: Non-zero and non-one elements in lower diagonal block of matrix A(t) in Primiceri, stacked in a vector
for hh=1:size(AA,1)
    for kk=1:size(AA,2)
        x=squeeze(AA(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
%
IF_AA=IF(:);
%
save aamat IF_AA
clear IF IF_AA AA
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% OM: The volatilities
for hh=1:size(OM,1)
    for kk=1:size(OM,2)
        x=squeeze(OM(hh,kk,2:NN));
        [omegak,Py,Pyl,Pyu]=SpecDensEstima(x,0.1,-9999,'N','NOBO','CHISQ',100);
        P0=Py(1);
        Py=[fliplr(Py(2:length(Py)-1)') Py'];
        IF(hh,kk)=1/(sum(Py)/(P0*2*pi));
    end
end
%
IF=IF';
IF=IF(:);
clear OM
%
save volamat IF

load theta 
load qmat 
load volAA 
load aamat 
load volamat 
load vola
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 1A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1)
T=(1:1:length(IF_theta))';
subplot(3,1,1)
plot(T,IF_theta,'k')
axis([1 length(IF_theta) 0 0.02])
%ylabel('theta')
title('Time-varying coefficients: theta')

T=(1:1:length(IF_Q))';
subplot(3,3,7)
plot(T,IF_Q,'k')
axis([1 length(IF_Q) 0 0.01])
%ylabel('QD')
title('Elements of Q')

T=(1:1:length(IF_V))';
subplot(3,3,8)
plot(T,IF_V,'k')
axis([1 length(IF_V) 0 1.1*max(IF_V)])
%ylabel('VD')
title('Elements of sigma')

T=(1:1:length(IF_s))';
subplot(3,3,9)
plot(T,IF_s,'k')
axis([1 length(IF_s) 0 1.1*max(IF_s)])
%ylabel('S')
title('Elements of S')

T=(1:1:length(IF_AA))';
subplot(3,2,3)
plot(T,IF_AA,'k')
axis([1 length(IF_AA) 0 1.1*max(IF_AA)])
%ylabel('AA')
title('Contemporaneous relations: A')

T=(1:1:length(IF))';
subplot(3,2,4)
plot(T,IF,'k')
axis([1 length(IF) 0 1.1*max(IF)])
%ylabel('OM')
title('Stochastic volatilities: H')