function [TIME,NN,T]=TVP_IRFS(DFILE2,L,N,TP,time,NG,data,DFILE3,h,SC,D,R,exact,pers)

%%%Structural analysis of TVC-BVAR with sign restrictions.
%%%By Christiane Baumeister and Gert Peersman.

load(DFILE2)

NN=NG-1;            %Gibbs sampler draws
T=size(SD,2);       %number of time periods
 
[YS,~,time]=databasics(time,L,TP,data);   %loading data and time vector

clear DD II UU

%variables to be saved:
%remember: variable names always have to be of the SAME LENGTH!
%impulse responses
varname(1,:) = 'IRF_qoilS';   
varname(2,:) = 'IRF_poilS';
varname(3,:) = 'IRF_windS';
varname(4,:) = 'IRF_qoilD';
varname(5,:) = 'IRF_poilD';
varname(6,:) = 'IRF_windD';
varname(7,:) = 'IRF_qoilA';
varname(8,:) = 'IRF_poilA';
varname(9,:) = 'IRF_windA';
%distributions of IRFS
varname(10,:) = 'IRFSUPPLY';
varname(11,:) = 'IRFDEMAND';
varname(12,:) = 'IRFGLOBAL';
%elasticities and back-of-the-envelope shocks
varname(13,:) = 'slope_S_D';    %slope of oil supply curve with oil-specific demand shock
varname(14,:) = 'slope_S_A';    %slope of oil supply curve with global demand shock
varname(15,:) = 'slope_D_D';    %slope of oil demand curve
varname(16,:) = 'shock_S_D';    %magnitude of oil supply shock with oil-specific demand shock
varname(17,:) = 'shock_S_A';    %magnitude of oil supply shock with global demand shock
varname(18,:) = 'shock_D_D';    %magnitude of oil-specific demand shock
varname(19,:) = 'shock_A_A';    %magnitude of global demand shock
varname(20,:) = 'POPERSIST';    %oil inflation persistence measures
varname(21,:) = 'VARDECOPO';    %variance decomposition of PO
varname(22,:) = 'VARDECOQO';    %variance decomposition of QO

%%%getting impulse response functions based on sign restrictions
HO=(5*4)+1;                  %horizon for IRFs (nsteps=20)
cors=1;          %identification parameter (1=contemporaneous)

NMCInteg=100;    %number of simulations to get GIRFs (Monte Carlo integration)
PERC=fix(R*[0.5 0.16 0.84]');        %percentiles: median, 16th and 84th percentile (error bands)
TT=(1:1:T)';             %sample only every four quarters: TT=(1:4:T)';
TT=TT(1+L:length(TT));   %defines the starting period for sampling --> check which period in my case!
%TT=TT(2:length(TT));    %if you sample only every four quarters
%t=length(TT); 
%epsilon=shockshist_new(T,N,L,YS,XS1,SD);

IRFSUPPLY=zeros(HO,N,R,length(TT));
IRF_qoilS=zeros(HO,3,length(TT));
IRF_poilS=zeros(HO,3,length(TT));
IRF_windS=zeros(HO,3,length(TT));

IRFDEMAND=zeros(HO,N,R,length(TT));
IRF_qoilD=zeros(HO,3,length(TT));
IRF_poilD=zeros(HO,3,length(TT));
IRF_windD=zeros(HO,3,length(TT));

IRFGLOBAL=zeros(HO,N,R,length(TT));
IRF_qoilA=zeros(HO,3,length(TT));
IRF_poilA=zeros(HO,3,length(TT));
IRF_windA=zeros(HO,3,length(TT));

slope_S_D=zeros(R,length(TT));
slope_S_A=zeros(R,length(TT));
slope_D_D=zeros(R,length(TT));
shock_S_D=zeros(R,length(TT));
shock_S_A=zeros(R,length(TT));
shock_D_D=zeros(R,length(TT));
shock_A_A=zeros(R,length(TT));

POPERSIST=zeros(4,R,length(TT));
VARDECOPO=zeros(3,R,length(TT));
VARDECOQO=zeros(3,R,length(TT));

%SHOCKS=zeros(N,length(TT));

%% Draw randomly 500 states of the economy at each point in time and then
%% search for 100 impulse responses that satisfy the sign restrictions for
%% each state of the economy

kk=1;
while kk<=length(TT)   %with the "observed" coefficients program can only run 
                       %until kk=32 (not length(TT)!)
                       %ALTERNATIVE: take last coefficient vector as best
                       %predictor for the future periods since coefficients
                       %are modelled as random walk i.e. add last
                       %coefficient vector HOR+1 times to SD and HOR+L
                       %times to AA and OM!!! (see Gambetti, Techno Shocks)
    tt=TT(kk);
    IRFMS=zeros(HO,N,R);   %accumulated IRFs
    IRFMD=zeros(HO,N,R);
    IRFMA=zeros(HO,N,R);
    POPCO=zeros(4,R);      %4 oil inflation persistence measures
    VARPO=zeros(3,R);      %variance decomposition (frequency domain)
    VARQO=zeros(3,R);      
    
    %schokken=zeros(N,R);   %structural shocks
    %index=zeros(R,1);      %contains the K's which led to accepted draws
    
    slopeS_D=zeros(R,1);    %only the impact elasticities
    slopeS_A=zeros(R,1);
    slopeD_D=zeros(R,1);
    shockS_D=zeros(R,1);
    shockS_A=zeros(R,1);
    shockD_D=zeros(R,1);
    shockA_A=zeros(R,1);
        
    hh=1;
    while hh<=R % Replications
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Sampling the current state of the economy from the Gibbs sampler output:
        K=fix(rand*(NN-0.01))+1;  %random draw from the max range of available Gibbs draws that satisfy the sign restrictions
        %
        sd=SD(:,tt,K);     % States (time-varying parameters in the VAR)
        aa=AA(:,tt,K);     % Non-zero and non-one elements in lower diagonal block of matrix A(t) in Primiceri, stacked in a vector
        %             
        qd=QD(:,:,K);      % State innovation covariance matrix (the matrix Q)
        s1=S1(1,K);        % S1
        s2=S2(:,:,K);      % S2
        %
        vd=VD(:,K);        % Standard deviation of vol. innovation
        om=OM(tt,:,K)';    % OM: The volatilities
        %            HOR+2 is sufficient (but HOR+L does not hurt!)
        %a0=AA00(:,:,K,tt+1+cors);
        %a0(:,1)=a0(:,1)/a0(1,1);
        
        if N==3 && exact==0 && pers==0
            [sirf,dirf,aggirf,ind,d]=GIRFs_N3(sd,aa,qd,s1,s2,vd,om,YS(:,tt-L:tt-1),HO,N,L,cors,NMCInteg,h,SC,D);
        elseif N==3 && exact==0 && pers==1
            [sirf,dirf,aggirf,POpersistence,varPO,varQO,ind,d]=GIRFs_N3_persist(sd,aa,qd,s1,s2,vd,om,YS(:,tt-L:tt-1),HO,N,L,cors,NMCInteg,h,SC,D);
        elseif N==3 && exact==1
            [sirf,dirf,aggirf,ind,d]=GIRFs_N3_exact(sd,aa,qd,s1,s2,vd,om,YS(:,tt-L:tt-1),HO,N,L,cors,NMCInteg,h,SC,D);
        end
        
        if ind==1 && d==1           
            
           %index(hh,1)=K;            %random draw from the Gibbs sampler
                                      %which created accepted IRFs
           %IRFS
           IRFMS(:,:,hh)=sirf;        % 20x3 matrices
           IRFMD(:,:,hh)=dirf;
           IRFMA(:,:,hh)=aggirf;
           
           if pers==1
           POPCO(:,hh)=POpersistence';  %oil inflation persistence: 4x1 vector
           VARPO(:,hh)=varPO';          %contribution of structural shocks to PO inflation: 3x1 vector
           VARQO(:,hh)=varQO';          %contribution of structural shocks to QO growth: 3x1 vector
           end
           %compute back-of-the-envelope shocks with impact elasticities
           [sdem,sagg,ssupd,ssupa,dd1,sd1,sa1]=oilmarket_model(sirf(1,:),dirf(1,:),aggirf(1,:));
           shockS_D(hh,1)=ssupd;     %magnitude of oil supply shocks computed with oil-specific demand shock
           shockD_D(hh,1)=sdem;      %magnitude of oil-specific demand shocks
           shockS_A(hh,1)=ssupa;     %magnitude of oil supply shocks computed with global demand shocks
           shockA_A(hh,1)=sagg;      %magnitude of global demand shocks
           
           %impact elasticities
           slopeS_D(hh,1)=sd1;      %slope of supply curve computed with oil-specific demand shock
           slopeD_D(hh,1)=dd1;      %slope of oil demand curve
           slopeS_A(hh,1)=sa1;      %slope of supply curve computed with global demand curve
           
           
           hh=hh+1;
        elseif ind==0 && d==0
            hh;
        end
                   
        clear sirf dirf aggirf POpersistence varPO varQO sd1 dd1 sa2 ssupd sdem sagg ssupa
        
    end
    
    %A0A0index(:,kk)=index;
    
    %SLOPES and SHOCKS over time
    shock_D_D(:,kk)=shockD_D;
    shock_A_A(:,kk)=shockA_A;
    shock_S_D(:,kk)=shockS_D;
    shock_S_A(:,kk)=shockS_A;
    
    slope_S_D(:,kk)=slopeS_D;
    slope_S_A(:,kk)=slopeS_A;
    slope_D_D(:,kk)=slopeD_D;
    
    IRFSUPPLY(:,:,:,kk)=IRFMS;    % saves distributions of impulse responses
    IRFDEMAND(:,:,:,kk)=IRFMD;
    IRFGLOBAL(:,:,:,kk)=IRFMA;
    POPERSIST(:,:,kk)=POPCO;      % saves distributions of persistence measures
    VARDECOPO(:,:,kk)=VARPO;      % saves distributions of variance decomposition PO
    VARDECOQO(:,:,kk)=VARQO;      %                                               QO                                          
    %SHOCKdist(:,kk)=schokken';   % hhxkk matrix
   
    %impulse responses (accumulated)
    
    IRFMS=sort(IRFMS,3);   
    IRF_qoilS(:,:,kk)=IRFMS(:,1,PERC);
    IRF_poilS(:,:,kk)=IRFMS(:,2,PERC);
    IRF_windS(:,:,kk)=IRFMS(:,3,PERC);
    
    IRFMD=sort(IRFMD,3);   
    IRF_qoilD(:,:,kk)=IRFMD(:,1,PERC);
    IRF_poilD(:,:,kk)=IRFMD(:,2,PERC);
    IRF_windD(:,:,kk)=IRFMD(:,3,PERC);
    
    IRFMA=sort(IRFMA,3);   
    IRF_qoilA(:,:,kk)=IRFMA(:,1,PERC);
    IRF_poilA(:,:,kk)=IRFMA(:,2,PERC);
    IRF_windA(:,:,kk)=IRFMA(:,3,PERC);
  
    kk=kk+1
    
end

save(DFILE3,varname(1,:),varname(2,:),varname(3,:),varname(4,:),varname(5,:),varname(6,:),varname(7,:),varname(8,:),varname(9,:),varname(10,:),varname(11,:),varname(12,:),varname(13,:),varname(14,:),varname(15,:),varname(16,:),varname(17,:),varname(18,:),varname(19,:),varname(20,:),varname(21,:),varname(22,:));
TIME=time(TT);

