/****************
This program estimates a model of federal funds rate. It decomposes
the funds rate into a desired rate part and a white noise part.
We model the desired rate as switching between an static state
and a dynamic state. In the static state, the desired rate does not change. 
In the dynamic state, the change in desired rate is hit by AR(1) shock and
changes in explanatory variables.

    r(t) = R(t)+ e(t),
R(t) = R(t-1), (when static)
R(t) =  R(t-1) + sum(betas* x(t-1)s) + u(t), (when dynamic)
     u(t) = phi*u(t-1) + v(t).

Every parameter changes in this program from 1991:4.
                                ************/


New;
library optmum,pgraph;

load data[218,1]=c:\data.txt;
load dat1[218,4]=c:\dta.txt;

yy =data[1:218,1];
yy0 = 9.0; @ federal funds target rate at 1982:10 @

/**
Change in (INF~INFE~GAP~SPRD), inf from GDP defl, infe from
SPF-smoothed (spline), gap from GDP,
spread is 10yr - 3-months.
**/

zz=dat1[1:218,.];
t1=101; @ break point is 1991:4 @
t=rows(yy);
format /m1 /rd 8,4;
output file=c:\prg_2.out reset;
output off;
@================= Initialize Global Variables============@

           START=1;  @1982:11.....@
           START1= T1+1;

           PRMTR_NO=18;   @ Number of parameters to be estimated @
           dmnsion=2;     @ dimension of transition equation @

pr_1=-1.7;pr_2=-3.0;
pr_3=-2.2;pr_4=-2.7;

pr_5=-1.3;pr_6=-1.3;

pr_7=-1.8;pr_8=1.3;

pr_9=-1.4;pr_10=1.3;

pr_11=0.1;pr_12=0.5;pr_13=0.1; pr_14=0.1;
pr_15=0.5; pr_16=0.9;pr_17=0.3; pr_18=0.5;


           @initial values of parameters@

PRMTR_IN=pr_1|pr_2|pr_3|pr_4|pr_5|pr_6|pr_7|pr_8|pr_9|pr_10|pr_11|pr_12|
pr_13|pr_14|pr_15|pr_16|pr_17|pr_18;

@ Maximum Likelihood Estimation @

 {xout,fout,gout,cout}=optmum(&lik_fcn,PRMTR_IN);

  @ prmtr estimates, -log lik value, Gradient, Hessian@

  "Calculating Hessian..... Please be patient!!!!";

  hout=inv(hessp(&lik_fcn,xout));


PRM_FNL=trans(xout);   @ Estimated  coefficients, constrained@

grdn_fnl=gradfd(&TRANS,xout);
Hsn_fnl=grdn_fnl*hout*grdn_fnl';
SD_fnl =sqrt(diag(Hsn_fnl)); @Std errors est. coeffs@

@-------To do a Wald test on Prob__1 ----------@
wald1_r=wtrans1(prm_fnl[1:4,.]);
wald1_grd=gradfd(&wtrans1,prm_fnl[1:4,.]);
wald1_cov= wald1_grd*hsn_fnl[1:4,1:4]*wald1_grd';
wald1=wald1_r'*inv(wald1_cov)*wald1_r;

@=========To do a Wald test on V(u(t))=======@
wald2_r=wtrans2(prm_fnl[7:10,.]);
wald2_grd=gradfd(&wtrans2,prm_fnl[7:10,.]);
wald2_cov= wald2_grd*hsn_fnl[7:10,7:10]*wald2_grd';
wald2=wald2_r'*inv(wald2_cov)*wald2_r;

@+++++++++To do a Wald test on all phi's +++++++@

wald3_r=wtrans3(prm_fnl[11:18,.]);
wald3_grd=gradfd(&wtrans3,prm_fnl[11:18,.]);
wald3_cov= wald3_grd*hsn_fnl[11:18,11:18]*wald3_grd';
wald3=wald3_r'*inv(wald3_cov)*wald3_r;

@+++++++++To do a Wald test on 2 F-look vars+++++++@
wald4_r=wtrans4(prm_fnl[11:18,.]);
wald4_grd=gradfd(&wtrans4,prm_fnl[11:18,.]);
wald4_cov= wald4_grd*hsn_fnl[11:18,11:18]*wald4_grd';
wald4=wald4_r'*inv(wald4_cov)*wald4_r;

@+++++++++To do a Wald test on 2 B-look vars+++++++@
wald5_r=wtrans5(prm_fnl[11:18,.]);
wald5_grd=gradfd(&wtrans5,prm_fnl[11:18,.]);
wald5_cov= wald5_grd*hsn_fnl[11:18,11:18]*wald5_grd';
wald5=wald5_r'*inv(wald5_cov)*wald5_r;

@+++++++++To do a Wald test on inflation+++++++@
wald6_r=wtrans6(prm_fnl[11:18,.]);
wald6_grd=gradfd(&wtrans6,prm_fnl[11:18,.]);
wald6_cov= wald6_grd*hsn_fnl[11:18,11:18]*wald6_grd';
wald6=wald6_r'*inv(wald6_cov)*wald6_r;

@+++++++++To do a Wald test on infl. exp+++++++@
wald7_r=wtrans7(prm_fnl[11:18,.]);
wald7_grd=gradfd(&wtrans7,prm_fnl[11:18,.]);
wald7_cov= wald7_grd*hsn_fnl[11:18,11:18]*wald7_grd';
wald7=wald7_r'*inv(wald7_cov)*wald7_r;

@+++++++++To do a Wald test on gap+++++++@
wald8_r=wtrans8(prm_fnl[11:18,.]);
wald8_grd=gradfd(&wtrans8,prm_fnl[11:18,.]);
wald8_cov= wald8_grd*hsn_fnl[11:18,11:18]*wald8_grd';
wald8=wald8_r'*inv(wald8_cov)*wald8_r;

@+++++++++To do a Wald test on sprd+++++++@
wald9_r=wtrans9(prm_fnl[11:18,.]);
wald9_grd=gradfd(&wtrans9,prm_fnl[11:18,.]);
wald9_cov= wald9_grd*hsn_fnl[11:18,11:18]*wald9_grd';
wald9=wald9_r'*inv(wald9_cov)*wald9_r;

@++++++++++++++++++++++++++++++++++@
v_e=prm_fnl[5:6,.]^2;

var_se=evar(prm_fnl);
prob1_1=(1-prm_fnl[2,.])/(2-prm_fnl[1,.]-prm_fnl[2,.]);
prob1_2=(1-prm_fnl[4,.])/(2-prm_fnl[3,.]-prm_fnl[4,.]);

output on;
"==FINAL OUTPUT=============================================";
"The code is ";;-cout;
"Likelihood value is ";; -fout;
"Estimated parameters are:";
prm_fnl';
"Estimated parameters without transformation are:";
xout';
"Standard errors of parameters are:"; sd_fnl';
"The variances of white noise errors are:";v_e';
"The V(u(t)) and SE(u(t))'s are:";var_se;
"The S-S probability of State I is:";prob1_1~prob1_2;
"The covariances 1:";hsn_fnl[1:18,1:6];
"The covariances 2:";hsn_fnl[1:18,7:12];
"The covariances 3:";hsn_fnl[1:18,13:18];

"The Wald statistics for Constant Prob_1:"; wald1;
"The Wald statistics for Constant V(u(t)):"; wald2;
"The Wald statistics for same parameters:"; wald3;
"The Wald statistics for same forward-looking coeffs:"; wald4;
"The Wald statistics for same backward-looking coeffs:"; wald5;
"The Wald statistics for same infl coeffs:"; wald6;
"The Wald statistics for same infl exp coeffs:"; wald7;
"The Wald statistics for same gap coeffs:"; wald8;
"The Wald statistics for same sprd coeffs:"; wald9;
"===============================================================";
output off;

{eq_r,Prob_T1,Prob_TL1,f_err} =FILTER(XOUT);
{PRSM_1,PRSM_2}=SMOOTH(PROB_T1,PROB_TL1);

output file=c:\prg_2a.out reset;
Eq_R~f_err~PROB_T1~PRsm_1;
output off;
@+++++++++++++++++++++++++++++++++++++++++++++++++++++++@
PROC LIK_FCN(PRMTR1);
Local  prmtr, PR_VAL,H, YT,ZT,LIKV, LIK, J_ITER,mean_ar1,lik_m,

b11,b12,b13,b14,
b21,b22,b23,b24,
B1,B2,

PR_TR,pr_tr1,
PR_TRF0,pr_trf1,
P, Q,p_1,q_1,
RR1,RR2,
F11,F12,F21,F22,
phi1,phi2,tht1,tht2,
qq11,qq12,qq21,qq22,
sig_M1,sig_t1,
sig_M2,sig_t2,

prb__1,prb__2,
Prob__1, Prob__2,
P_ll1, P_ll2,
vecp1, vecp2,
b_ll1, b_ll2,

B_TL11, B_TL12,
B_TL21, B_TL22,
p_TL11, p_TL12,
p_TL21, p_TL22,

B_Tt11, B_Tt12,
B_Tt21, B_Tt22,
p_Tt11, p_Tt12,
p_Tt21, p_Tt22,

ss11,ss12,
ss21,ss22,

F_cast11,F_cast12,
F_cast21,F_cast22,

PRO_11, PRO_12,
PRO_21, PRO_22,
PR_VL11, PR_VL12,
PR_VL21, PR_VL22;

EXTERNAL PROC TRANS, V_PROB;
PRMTR=TRANS(PRMTR1);
LOCATE 16,1; PRMTR';


        p=PRMTR[1,1];   @Pr[St=1|St-1=1}@
        q=PRMTR[2,1];   @Pr[St=2|St-1=2]@

        p_1=prmtr[3,1];
        q_1=prmtr[4,1];

        SIG_M1=PRMTR[5,1];
        SIG_M2=PRMTR[6,1];

        SIG_T1=prmtr[7,1];

        phi1=prmtr[8,1];


        Sig_T2=prmtr[9,1];

        phi2=prmtr[10,1];

        b11=prmtr[11,1];
        b12=prmtr[12,1];
        b13=prmtr[13,1];
        b14=prmtr[14,1];

        b21=prmtr[15,1];
        b22=prmtr[16,1];
        b23=prmtr[17,1];
        b24=prmtr[18,1];

    @A matrix of Tr. prob@
PR_TR=  (p~1-q)|(1-p~q );
pr_tr1= (p_1~1-q_1)|(1-p_1~q_1);


    @ Initial Probabilities @
           PROB__1=(1-q)/(2-p-q);
           PROB__2=1-prob__1;

           prb__1=(1-q_1)/(2-p_1-q_1);
           prb__2=1-prb__1;

           PR_TRF0=VEC(PR_TR);
           pr_trf1=vec(pr_tr1);

        H = (1~0);

        B1 = (b11~b12~b13~b14);
        F11 = (1~0)|(0~phi1);
        F12 = (1~phi1)|(0~phi1);

        RR1 = (SIG_M1^2);
        QQ11 = (0~0)|(0~sig_t1^2);
        QQ12 = ones(2,1)*(sig_t1^2)*ones(1,2);

        B2 = (b21~b22~b23~b24);
        F21 = (1~0)|(0~phi2);
        F22 = (1~phi2)|(0~phi2);

        RR2 = (SIG_M2^2);
        QQ21 = (0~0)|(0~sig_t2^2);
        QQ22 = ones(2,1)*(sig_t2^2)*ones(1,2);



    B_LL1 =  (yy0|0);     @initial guess for state vector@
    B_LL2 = (yy0|0);


    vecp1 = inv(eye(1) -F12[2,2].*.F12[2,2])*sig_t1^2;

    P_LL2 = zeros(2,2);
    P_ll2[1,1] = 100000;
    P_LL2[2,2] = vecp1;
    P_ll1 = p_ll2;

@=======================================================@

LIK_m = zeros(t,1);
J_ITER = 1;
DO UNTIL J_ITER>T1;

YT=YY[J_ITER,.];
ZT=ZZ[J_ITER,.];

       /* KALMAN FILTER */
       /*==============================================================*/

             B_TL11 =  F11 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=1@
             B_TL12 =  (B1*ZT'|0) + F12 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=2@

             B_TL21 =  F11 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=1@
             B_TL22 =  (B1*ZT'|0) + F12 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=2@

          @============@


             P_TL11 = F11 * P_LL1 * F11' + QQ11;
             P_TL12 = F12 * P_LL1 * F12' + QQ12;

             P_TL21 = F11 * P_LL2 * F11' + QQ11;
             P_TL22 = F12 * P_LL2 * F12' + QQ12;


         @=========@

             F_CAST11= YT' - H*B_Tl11;
             F_CAST12= YT' - H*B_Tl12;

             F_CAST21= YT' - H*B_Tl21;
             F_CAST22= YT' - H*B_Tl22;

    @++++++++++++++++@

             SS11= H * P_TL11 * H' +RR1; @VARIANCE OF FORECAST ERROR@
             SS12= H * P_TL12 * H' +RR1;


             SS21= H * P_TL21 * H' +RR1; @VARIANCE OF FORECAST ERROR@
             SS22= H * P_TL22 * H' +RR1;

         @===========@


             B_TT11 = B_TL11 + (P_TL11 * H' *INV(SS11)) * F_CAST11;
             B_TT12 = B_TL12 + (P_TL12 * H' *INV(SS12)) * F_CAST12;

             B_TT21 = B_TL21 + (P_TL21 * H' *INV(SS21)) * F_CAST21;
             B_TT22 = B_TL22 + (P_TL22 * H' *INV(SS22)) * F_CAST22;

             @==============@

             P_TT11 = (EYE(2) - P_TL11 * H'*INV(SS11) * H ) * P_TL11;
             P_TT12 = (EYE(2) - P_TL12 * H'*INV(SS12) * H ) * P_TL12;

             P_TT21 = (EYE(2) - P_TL21 * H'*INV(SS21) * H ) * P_TL21;
             P_TT22 = (EYE(2) - P_TL22 * H'*INV(SS22) * H ) * P_TL22;

    @+++++++++++++++++++@
                /* HAMILTON FILTER */
       /*==================================================*/
          @Pr[St,Yt/Yt-1]@

          PR_VL11=V_PROB(F_CAST11,SS11)*PR_TRF0[1]*PROB__1;
          PR_VL12=V_PROB(F_CAST12,SS12)*PR_TRF0[2]*PROB__1;

          PR_VL21=V_PROB(F_CAST21,SS21)*PR_TRF0[3]*PROB__2;
          PR_VL22=V_PROB(F_CAST22,SS22)*PR_TRF0[4]*PROB__2;

         @==============@
@CONDITIONAL DENSITY TIMES WEIGHT@

             PR_VAL=PR_VL11+PR_VL12+
                    PR_VL21+PR_VL22;



@WEIGHTED AVERAGE OF CONDITIONAL DENSITIES:f(y_t|Y_{t-1})@

lik = -1*ln(pr_val);


         @==============@

             PRO_11=PR_VL11/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_12=PR_VL12/PR_VAL;

             PRO_21=PR_VL21/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_22=PR_VL22/PR_VAL;

             @==============@

             PROB__1=PRO_11+PRO_21;       @Pr[St=1/Yt]@
             PROB__2=PRO_12+PRO_22;       @Pr[St=2/Yt]@

             @Pr[St=i/Yt]@


       /* COLLAPSING TERMS */
       /*==============================================================*/


              B_LL1=(PRO_11*B_TT11 + PRO_21*B_TT21)/PROB__1;

              B_LL2=(PRO_12*B_TT12 + PRO_22*B_TT22)/PROB__2;

             @=========@

   P_LL1=(PRO_11*(P_TT11+(B_LL1-B_TT11)*(B_LL1-B_TT11)')+
          PRO_21*(P_TT21+(B_LL1-B_TT21)*(B_LL1-B_TT21)'))/PROB__1;

   P_LL2=(PRO_12*(P_TT12+(B_LL2-B_TT12)*(B_LL2-B_TT12)')+
          PRO_22*(P_TT22+(B_LL2-B_TT22)*(B_LL2-B_TT22)'))/PROB__2;


if j_iter<start; goto skip1; endif;

LIK_M[j_iter,.] = LIK;
skip1:  J_ITER = J_ITER+1;
ENDO;

J_ITER = t1+1;
DO UNTIL J_ITER>T;

YT=YY[J_ITER,.];
ZT=ZZ[J_ITER,.];

       /* KALMAN FILTER */
       /*==============================================================*/

             B_TL11 =  F21 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=1@
             B_TL12 =  (B2*ZT'|0) + F22 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=2@

             B_TL21 =  F21 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=1@
             B_TL22 =  (B2*ZT'|0) + F22 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=2@

          @============@


             P_TL11 = F21 * P_LL1 * F21' + QQ21;
             P_TL12 = F22 * P_LL1 * F22' + QQ22;

             P_TL21 = F21 * P_LL2 * F21' + QQ21;
             P_TL22 = F22 * P_LL2 * F22' + QQ22;


         @=========@

             F_CAST11= YT' - H*B_Tl11;
             F_CAST12= YT' - H*B_Tl12;

             F_CAST21= YT' - H*B_Tl21;
             F_CAST22= YT' - H*B_Tl22;

    @++++++++++++++++@

             SS11= H * P_TL11 * H' +RR2; @VARIANCE OF FORECAST ERROR@
             SS12= H * P_TL12 * H' +RR2;


             SS21= H * P_TL21 * H' +RR2; @VARIANCE OF FORECAST ERROR@
             SS22= H * P_TL22 * H' +RR2;

         @===========@


             B_TT11 = B_TL11 + (P_TL11 * H' *INV(SS11)) * F_CAST11;
             B_TT12 = B_TL12 + (P_TL12 * H' *INV(SS12)) * F_CAST12;

             B_TT21 = B_TL21 + (P_TL21 * H' *INV(SS21)) * F_CAST21;
             B_TT22 = B_TL22 + (P_TL22 * H' *INV(SS22)) * F_CAST22;

             @==============@

             P_TT11 = (EYE(2) - P_TL11 * H'*INV(SS11) * H ) * P_TL11;
             P_TT12 = (EYE(2) - P_TL12 * H'*INV(SS12) * H ) * P_TL12;

             P_TT21 = (EYE(2) - P_TL21 * H'*INV(SS21) * H ) * P_TL21;
             P_TT22 = (EYE(2) - P_TL22 * H'*INV(SS22) * H ) * P_TL22;

    @+++++++++++++++++++@
                /* HAMILTON FILTER */
       /*==================================================*/
          @Pr[St,Yt/Yt-1]@

          PR_VL11=V_PROB(F_CAST11,SS11)*PR_TRF1[1]*PRB__1;
          PR_VL12=V_PROB(F_CAST12,SS12)*PR_TRF1[2]*PRB__1;

          PR_VL21=V_PROB(F_CAST21,SS21)*PR_TRF1[3]*PRB__2;
          PR_VL22=V_PROB(F_CAST22,SS22)*PR_TRF1[4]*PRB__2;

         @==============@
@CONDITIONAL DENSITY TIMES WEIGHT@

             PR_VAL=PR_VL11+PR_VL12+
                    PR_VL21+PR_VL22;



@WEIGHTED AVERAGE OF CONDITIONAL DENSITIES:f(y_t|Y_{t-1})@

lik = -1*ln(pr_val);


         @==============@

             PRO_11=PR_VL11/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_12=PR_VL12/PR_VAL;

             PRO_21=PR_VL21/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_22=PR_VL22/PR_VAL;

             @==============@

             PRB__1=PRO_11+PRO_21;       @Pr[St=1/Yt]@
             PRB__2=PRO_12+PRO_22;       @Pr[St=2/Yt]@

             @Pr[St=i/Yt]@


       /* COLLAPSING TERMS */
       /*==============================================================*/


              B_LL1=(PRO_11*B_TT11 + PRO_21*B_TT21)/PRB__1;

              B_LL2=(PRO_12*B_TT12 + PRO_22*B_TT22)/PRB__2;

             @=========@

   P_LL1=(PRO_11*(P_TT11+(B_LL1-B_TT11)*(B_LL1-B_TT11)')+
          PRO_21*(P_TT21+(B_LL1-B_TT21)*(B_LL1-B_TT21)'))/PRB__1;

   P_LL2=(PRO_12*(P_TT12+(B_LL2-B_TT12)*(B_LL2-B_TT12)')+
          PRO_22*(P_TT22+(B_LL2-B_TT22)*(B_LL2-B_TT22)'))/PRB__2;


if j_iter<start1; goto skip2; endif;

LIK_M[j_iter,.] = LIK;
skip2:  J_ITER = J_ITER+1;
ENDO;

likv=sumc(lik_m);
               LOCATE 2,35;"LIKV=";;LIKV;
RETP(LIKV);
ENDP;

@>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>@
PROC TRANS(c0); @ constraining values of reg. coeff.@
     local cc;

cc = c0;

    cc[1:4,.]= exp(-1*c0[1:4,1])./ (1 + exp(-1*c0[1:4,1]));

    cc[5:6,.] = exp(-1*c0[5:6,.])./10;

    cc[7,.] = exp(-1*c0[7,.])./10;
    cc[8,.] = (c0[8,.])./(1 + abs(c0[8,.]));

    cc[9,.] = exp(-1*c0[9,.])./10;
    cc[10,.] = (c0[10,.])./(1 + abs(c0[10,.]));


   retp(cc);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~@
PROC WTRANS1(c_0);
local c_c, c_cons;

c_c=c_0;

c_cons=((1-c_c[2,.])./(2-c_c[1,.]-c_c[2,.]))-((1-c_c[4,.])./(2-c_c[3,.]
-c_c[4,.]));

retp(c_cons);

endp;
@>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>@

Proc WTRANS2(c0);
local cc, val, val1,val2;

cc=c0;

val1=(cc[1,.]^2)/(1-cc[2,.]^2);
val2=(cc[3,.]^2)/(1-cc[4,.]^2);

val=val1-val2;

retp(val);

endp;
@+++++++++++++++++++++++++++++++++++++++++++++++++@
Proc WTRANS3(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;

val1=cc[1,.]-cc[5,.];
val2=cc[2,.]-cc[6,.];
val3=cc[3,.]-cc[7,.];
val4=cc[4,.]-cc[8,.];

val=val1|val2|val3|val4;

retp(val);
endp;

@+++++++++++++++++++++++++++++++++++++++++++++++++@
Proc WTRANS4(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;


val1=cc[2,.]-cc[6,.];

val2=cc[4,.]-cc[8,.];

val=val1|val2;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
@+++++++++++++++++++++++++++++++++++++++++++++++++@
Proc WTRANS5(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;


val1=cc[1,.]-cc[5,.];

val2=cc[3,.]-cc[7,.];

val=val1|val2;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
Proc WTRANS6(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;

val1=cc[1,.]-cc[5,.];

val=val1;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@

Proc WTRANS7(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;

val1=cc[2,.]-cc[6,.];

val=val1;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
Proc WTRANS8(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;

val1=cc[3,.]-cc[7,.];

val=val1;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
Proc WTRANS9(c0);
local cc, val, val1,val2,val3,val4;

cc=c0;

val1=cc[4,.]-cc[8,.];

val=val1;

retp(val);
endp;
@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
Proc evar(c0);
local cc, val, val1,val2;

cc=c0;
val=zeros(1,4);

val1=(cc[7,.]^2)/(1-cc[8,.]^2);
val2=(cc[9,.]^2)/(1-cc[10,.]^2);

val=val1~sqrt(val1)~val2~sqrt(val2);

retp(val);

endp;
@++++++++++++++++++++++++++++++++@

PROC V_PROB(EV, HE);      @ CALCULATES    Pr[Yt/St,Yt-1]@
LOCAL VAL;

VAL=(1/SQRT(DET(HE)))*EXP(-0.5*EV'*inv(HE)*EV);


RETP(VAL);
ENDP;

@>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>@
proc(4)= filter(prmtr1);
Local  prmtr, PR_VAL,H, YT,ZT,LIKV, LIK, J_ITER,mean_ar1,lik_m,
r_eq,f_er,pr_t1,PTL_1,
b11,b12,b13,b14,
b21,b22,b23,b24,
B1,B2,
PR_TR,pr_tr1,
PR_TRF0,pr_trf1,
P, Q,p_1,q_1,
RR1,RR2,
F11,F12,F21,F22,
phi1,phi2,tht1,tht2,
qq11,qq12,qq21,qq22,
sig_M1,sig_t1,
sig_M2,sig_t2,
prb__1,prb__2,
Prob__1, Prob__2,
P_ll1, P_ll2,
vecp1, vecp2,
b_ll1, b_ll2,

B_TL11, B_TL12,
B_TL21, B_TL22,
p_TL11, p_TL12,
p_TL21, p_TL22,

B_Tt11, B_Tt12,
B_Tt21, B_Tt22,
p_Tt11, p_Tt12,
p_Tt21, p_Tt22,

ss11,ss12,
ss21,ss22,

F_cast11,F_cast12,
F_cast21,F_cast22,

PRO_11, PRO_12,
PRO_21, PRO_22,
PR_VL11, PR_VL12,
PR_VL21, PR_VL22;

EXTERNAL PROC TRANS, V_PROB;
PRMTR=TRANS(PRMTR1);
LOCATE 16,1; PRMTR';


        p=PRMTR[1,1];   @Pr[St=1|St-1=1}@
        q=PRMTR[2,1];   @Pr[St=2|St-1=2]@

        p_1=prmtr[3,1];
        q_1=prmtr[4,1];

        SIG_M1=PRMTR[5,1];
        SIG_M2=PRMTR[6,1];

        SIG_T1=prmtr[7,1];

        phi1=prmtr[8,1];

        Sig_T2=prmtr[9,1];

        phi2=prmtr[10,1];

        b11=prmtr[11,1];
        b12=prmtr[12,1];
        b13=prmtr[13,1];
        b14=prmtr[14,1];

        b21=prmtr[15,1];
        b22=prmtr[16,1];
        b23=prmtr[17,1];
        b24=prmtr[18,1];

    @A matrix of Tr. prob@
PR_TR=  (p~1-q)|(1-p~q );
pr_tr1= (p_1~1-q_1)|(1-p_1~q_1);


    @ Initial Probabilities @
           PROB__1=(1-q)/(2-p-q);
           PROB__2=1-prob__1;

           prb__1=(1-q_1)/(2-p_1-q_1);
           prb__2=1-prb__1;

           PR_TRF0=VEC(PR_TR);
           pr_trf1=vec(pr_tr1);

        H = (1~0);

        B1 = (b11~b12~b13~b14);
        F11 = (1~0)|(0~phi1);
        F12 = (1~phi1)|(0~phi1);

        RR1 = (SIG_M1^2);
        QQ11 = (0~0)|(0~sig_t1^2);
        QQ12 = ones(2,1)*(sig_t1^2)*ones(1,2);

        B2 = (b21~b22~b23~b24);
        F21 = (1~0)|(0~phi2);
        F22 = (1~phi2)|(0~phi2);

        RR2 = (SIG_M2^2);
        QQ21 = (0~0)|(0~sig_t2^2);
        QQ22 = ones(2,1)*(sig_t2^2)*ones(1,2);



    B_LL1 =  (yy0|0);     @initial guess for state vector@
    B_LL2 = (yy0|0);

    vecp1 = inv(eye(1) -F12[2,2].*.F12[2,2])*sig_t1^2;

    P_LL2 = zeros(2,2);
    P_ll2[1,1] = 100000;
    P_LL2[2,2] = vecp1;
    P_ll1 = p_ll2;

r_eq=zeros(t,1);
f_er=zeros(t,1);
PTL_1=zeros(t,1);
PR_T1=zeros(t,1);

@=======================================================@

LIK_m = zeros(t,1);
J_ITER = 1;
DO UNTIL J_ITER>T1;

YT=YY[J_ITER,.];
ZT=ZZ[J_ITER,.];

ptl_1[j_iter,.]=p*Prob__1+(1-q)*Prob__2;

       /* KALMAN FILTER */
       /*==============================================================*/

             B_TL11 =  F11 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=1@
             B_TL12 =  (B1*ZT'|0) + F12 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=2@

             B_TL21 =  F11 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=1@
             B_TL22 =  (B1*ZT'|0) + F12 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=2@
          @============@


             P_TL11 = F11 * P_LL1 * F11' + QQ11;
             P_TL12 = F12 * P_LL1 * F12' + QQ12;

             P_TL21 = F11 * P_LL2 * F11' + QQ11;
             P_TL22 = F12 * P_LL2 * F12' + QQ12;


         @=========@

             F_CAST11= YT' - H*B_Tl11;
             F_CAST12= YT' - H*B_Tl12;

             F_CAST21= YT' - H*B_Tl21;
             F_CAST22= YT' - H*B_Tl22;

    @++++++++++++++++@

             SS11= H * P_TL11 * H' +RR1; @VARIANCE OF FORECAST ERROR@
             SS12= H * P_TL12 * H' +RR1;


             SS21= H * P_TL21 * H' +RR1; @VARIANCE OF FORECAST ERROR@
             SS22= H * P_TL22 * H' +RR1;

         @===========@


             B_TT11 = B_TL11 + (P_TL11 * H' *INV(SS11)) * F_CAST11;
             B_TT12 = B_TL12 + (P_TL12 * H' *INV(SS12)) * F_CAST12;

             B_TT21 = B_TL21 + (P_TL21 * H' *INV(SS21)) * F_CAST21;
             B_TT22 = B_TL22 + (P_TL22 * H' *INV(SS22)) * F_CAST22;

             @==============@

             P_TT11 = (EYE(2) - P_TL11 * H'*INV(SS11) * H ) * P_TL11;
             P_TT12 = (EYE(2) - P_TL12 * H'*INV(SS12) * H ) * P_TL12;

             P_TT21 = (EYE(2) - P_TL21 * H'*INV(SS21) * H ) * P_TL21;
             P_TT22 = (EYE(2) - P_TL22 * H'*INV(SS22) * H ) * P_TL22;

    @+++++++++++++++++++@
                /* HAMILTON FILTER */
       /*==================================================*/
          @Pr[St,Yt/Yt-1]@

          PR_VL11=V_PROB(F_CAST11,SS11)*PR_TRF0[1]*PROB__1;
          PR_VL12=V_PROB(F_CAST12,SS12)*PR_TRF0[2]*PROB__1;

          PR_VL21=V_PROB(F_CAST21,SS21)*PR_TRF0[3]*PROB__2;
          PR_VL22=V_PROB(F_CAST22,SS22)*PR_TRF0[4]*PROB__2;

         @==============@
@CONDITIONAL DENSITY TIMES WEIGHT@

             PR_VAL=PR_VL11+PR_VL12+
                    PR_VL21+PR_VL22;



@WEIGHTED AVERAGE OF CONDITIONAL DENSITIES:f(y_t|Y_{t-1})@

lik = -1*ln(pr_val);


         @==============@

             PRO_11=PR_VL11/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_12=PR_VL12/PR_VAL;

             PRO_21=PR_VL21/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_22=PR_VL22/PR_VAL;

             @==============@

             PROB__1=PRO_11+PRO_21;       @Pr[St=1/Yt]@
             PROB__2=PRO_12+PRO_22;       @Pr[St=2/Yt]@

             @Pr[St=i/Yt]@

r_eq[j_iter,.]=PRO_11*B_TT11[1,1] + PRO_21*B_TT21[1,1]
        +PRO_12*B_TT12[1,1] + PRO_22*B_TT22[1,1];

PR_T1[j_iter,.]=PROB__1;

f_er[j_iter,.]=PRO_11*F_CAST11 + PRO_21*F_CAST21
        +PRO_12*F_CAST12 + PRO_22*F_CAST22;

       /* COLLAPSING TERMS */
       /*==============================================================*/


              B_LL1=(PRO_11*B_TT11 + PRO_21*B_TT21)/PROB__1;

              B_LL2=(PRO_12*B_TT12 + PRO_22*B_TT22)/PROB__2;

             @=========@

   P_LL1=(PRO_11*(P_TT11+(B_LL1-B_TT11)*(B_LL1-B_TT11)')+
          PRO_21*(P_TT21+(B_LL1-B_TT21)*(B_LL1-B_TT21)'))/PROB__1;

   P_LL2=(PRO_12*(P_TT12+(B_LL2-B_TT12)*(B_LL2-B_TT12)')+
          PRO_22*(P_TT22+(B_LL2-B_TT22)*(B_LL2-B_TT22)'))/PROB__2;


if j_iter<start; goto skip1; endif;

LIK_M[j_iter,.] = LIK;
skip1:  J_ITER = J_ITER+1;
ENDO;

J_ITER = t1+1;
DO UNTIL J_ITER>T;

YT=YY[J_ITER,.];

ptl_1[j_iter,.]=p_1*Prb__1+(1-q_1)*Prb__2;

ZT=ZZ[J_ITER,.];

       /* KALMAN FILTER */
       /*==============================================================*/

             B_TL11 =  F21 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=1@
             B_TL12 =  (B2*ZT'|0) + F22 * B_LL1;  @WHEN S_{t-1}=1, S_{t}=2@

             B_TL21 =  F21 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=1@
             B_TL22 =  (B2*ZT'|0) + F22 * B_LL2;  @WHEN S_{t-1}=2, S_{t}=2@

          @============@


             P_TL11 = F21 * P_LL1 * F21' + QQ21;
             P_TL12 = F22 * P_LL1 * F22' + QQ22;

             P_TL21 = F21 * P_LL2 * F21' + QQ21;
             P_TL22 = F22 * P_LL2 * F22' + QQ22;


         @=========@

             F_CAST11= YT' - H*B_Tl11;
             F_CAST12= YT' - H*B_Tl12;

             F_CAST21= YT' - H*B_Tl21;
             F_CAST22= YT' - H*B_Tl22;

    @++++++++++++++++@

             SS11= H * P_TL11 * H' +RR2; @VARIANCE OF FORECAST ERROR@
             SS12= H * P_TL12 * H' +RR2;


             SS21= H * P_TL21 * H' +RR2; @VARIANCE OF FORECAST ERROR@
             SS22= H * P_TL22 * H' +RR2;

         @===========@


             B_TT11 = B_TL11 + (P_TL11 * H' *INV(SS11)) * F_CAST11;
             B_TT12 = B_TL12 + (P_TL12 * H' *INV(SS12)) * F_CAST12;

             B_TT21 = B_TL21 + (P_TL21 * H' *INV(SS21)) * F_CAST21;
             B_TT22 = B_TL22 + (P_TL22 * H' *INV(SS22)) * F_CAST22;

             @==============@

             P_TT11 = (EYE(2) - P_TL11 * H'*INV(SS11) * H ) * P_TL11;
             P_TT12 = (EYE(2) - P_TL12 * H'*INV(SS12) * H ) * P_TL12;

             P_TT21 = (EYE(2) - P_TL21 * H'*INV(SS21) * H ) * P_TL21;
             P_TT22 = (EYE(2) - P_TL22 * H'*INV(SS22) * H ) * P_TL22;

    @+++++++++++++++++++@
                /* HAMILTON FILTER */
       /*==================================================*/
          @Pr[St,Yt/Yt-1]@

          PR_VL11=V_PROB(F_CAST11,SS11)*PR_TRF1[1]*PRB__1;
          PR_VL12=V_PROB(F_CAST12,SS12)*PR_TRF1[2]*PRB__1;

          PR_VL21=V_PROB(F_CAST21,SS21)*PR_TRF1[3]*PRB__2;
          PR_VL22=V_PROB(F_CAST22,SS22)*PR_TRF1[4]*PRB__2;

         @==============@
@CONDITIONAL DENSITY TIMES WEIGHT@

             PR_VAL=PR_VL11+PR_VL12+
                    PR_VL21+PR_VL22;



@WEIGHTED AVERAGE OF CONDITIONAL DENSITIES:f(y_t|Y_{t-1})@

lik = -1*ln(pr_val);


         @==============@

             PRO_11=PR_VL11/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_12=PR_VL12/PR_VAL;

             PRO_21=PR_VL21/PR_VAL;       @Pr[St,St-1/Yt]@
             PRO_22=PR_VL22/PR_VAL;

             @==============@

             PRB__1=PRO_11+PRO_21;       @Pr[St=1/Yt]@
             PRB__2=PRO_12+PRO_22;       @Pr[St=2/Yt]@

             @Pr[St=i/Yt]@

r_eq[j_iter,.]=PRO_11*B_TT11[1,1] + PRO_21*B_TT21[1,1]
        +PRO_12*B_TT12[1,1] + PRO_22*B_TT22[1,1];

PR_T1[j_iter,.]=PRB__1;

f_er[j_iter,.]=PRO_11*F_CAST11 + PRO_21*F_CAST21
        +PRO_12*F_CAST12 + PRO_22*F_CAST22;

       /* COLLAPSING TERMS */
       /*==============================================================*/


              B_LL1=(PRO_11*B_TT11 + PRO_21*B_TT21)/PRB__1;

              B_LL2=(PRO_12*B_TT12 + PRO_22*B_TT22)/PRB__2;

             @=========@

   P_LL1=(PRO_11*(P_TT11+(B_LL1-B_TT11)*(B_LL1-B_TT11)')+
          PRO_21*(P_TT21+(B_LL1-B_TT21)*(B_LL1-B_TT21)'))/PRB__1;

   P_LL2=(PRO_12*(P_TT12+(B_LL2-B_TT12)*(B_LL2-B_TT12)')+
          PRO_22*(P_TT22+(B_LL2-B_TT22)*(B_LL2-B_TT22)'))/PRB__2;


if j_iter<start1; goto skip2; endif;

LIK_M[j_iter,.] = LIK;
skip2:  J_ITER = J_ITER+1;
ENDO;

retp(r_eq,pr_t1,PTL_1,f_er);
endp;

@~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~@
PROC(2)= SMOOTH(ptt1,ptl1);

         @pTT1 contains Pr[S_t=1|Y_t]@
         @pTL1 contains Pr[S_t=1|Y_{t-1}]@

local p,q,p_1,q_1, pr_sm2,pr_sm1, j_iter,pr_sm11,pr_sm12,pr_sm21,
pr_sm22,ptt2,ptl2,TT,prmtr;

          TT=ROWS(PTT1);
          prmtr=trans(xout);

           P=PRMtr[1,1];    @Pr[St=1/St-1=1]@
           Q=PRMtr[2,1];    @Pr[St=2/St-1=2]@
           P_1=PRMtr[3,1];    @Pr[St=1/St-1=1]@
           Q_1=PRMtr[4,1];    @Pr[St=2/St-1=2]@

           ptt2=1-ptt1;
           ptl2=1-ptl1;

           pr_sm1=ptt1;     @ pr_sm1 will contain Pr[S_t=1|Y_T]@
           pr_sm2=ptt2;

j_iter=TT-1;
do until j_iter < T1+1;

    @The followings are P[S_t, S_t+1|Y_T] @

   pr_sm11=pr_sm1[j_iter+1,1]*p_1*ptt1[j_iter,1]/ptl1[j_iter+1,1];

   pr_sm12=pr_sm2[j_iter+1,1]*(1-p_1)*ptt1[j_iter,1]/ptl2[j_iter+1,1];

   pr_sm21=pr_sm1[j_iter+1,1]*(1-q_1)*ptt2[j_iter,1]/ptl1[j_iter+1,1];

   pr_sm22=pr_sm2[j_iter+1,1]*q_1*ptt2[j_iter,1]/ptl2[j_iter+1,1];

   pr_sm1[j_iter,1]=pr_sm11+pr_sm12;
   pr_sm2[j_iter,1]=pr_sm21+pr_sm22;

j_iter=j_iter -1;
endo;


j_iter=T1-1;
do until j_iter < 1;

    @The followings are P[S_t, S_t+1|Y_T] @

   pr_sm11=pr_sm1[j_iter+1,1]*p*ptt1[j_iter,1]/ptl1[j_iter+1,1];

   pr_sm12=pr_sm2[j_iter+1,1]*(1-p)*ptt1[j_iter,1]/ptl2[j_iter+1,1];

   pr_sm21=pr_sm1[j_iter+1,1]*(1-q)*ptt2[j_iter,1]/ptl1[j_iter+1,1];

   pr_sm22=pr_sm2[j_iter+1,1]*q*ptt2[j_iter,1]/ptl2[j_iter+1,1];

   pr_sm1[j_iter,1]=pr_sm11+pr_sm12;
   pr_sm2[j_iter,1]=pr_sm21+pr_sm22;

j_iter=j_iter -1;
endo;

RETP(pr_sm1,pr_sm2); @This proc returns Pr[S_t=1|Y_T] & Pr[S_t=2|Y_T]@
endp;



