/* (C) Ole E. Barndorff-Nielsen and Neil Shephard (2002). Written for
"Estimating quadratic variation using realised variance,"
Journal of Applied Econometrics

*/

#include "ssf_main.ox"

main()
{
//	   high frequency raw data
				
    decl i,x1 = loadmat("boll_brown.in7")[36:][];
//	print(x1[:1000][]);
//	print(aggregater(x1[:idays*288-1][3]',288));


	decl idays = 10;
	decl j,k,x = x1[:idays*288-1][4]';
	decl x_sea = zeros(1,288);
	x = x- meanr(x);

	k = 0;
	for (j=0; j<idays; j++)
	{
	   for (i=0; i<288; i++)
	   {
	      x_sea[0][i] += x[][k];
		  k += 1;
	   }
	}

	x_sea = x_sea./idays;

	k = 0;
	for (j=0; j<idays; j++)
	{
	   for (i=0; i<288; i++)
	   {
	      x[0][k] -= x_sea[0][i];
		  k += 1;
	   }
	}

	Draw(0,cumulate(x_sea')',0,1/288);
	SetDrawWindow("seasonal");
	ShowDrawWindow();
	
//	decl Delta=1.0,mStar=288/16, M=288/mStar;
	decl Delta=1.0,mStar=2, M=288/mStar;
	decl z,z2, dfunc,vp,acf1,weight=0;				
	decl psi,lambda,omega;
	igraph=0, igraph3=20;
	decl hessian;

	print(columns(x)/288);
	decl y,b,xacf;

//	decl xlags = ones(1,columns(x))|(lag0(x[][]',range(1,5)')')|(meanc(lag0(x[][]',range(200,287)')'));
	decl xlags = ones(1,columns(x))|(lag0(x[][]',range(1,6)')');

	olsr(x,xlags,&b);
	print(b);
//	x = x - b*xlags;
    xacf = acf(x[][]',1*288)'[][1:];
	Draw(0,cumulate(xacf')',0,1/288);
	Draw(1,xacf,0,1/288);
	SetDrawWindow("hello");
	ShowDrawWindow();

	decl acf_store, acf_store1,r, zr;
	decl xstart, xdiff;

	decl xstore = new matrix[idays][18];
	decl xstore4= new matrix[idays][18];
	decl xy = new matrix[2][18];

	for (j=0; j<columns(xstore); j++)
	{
		if (j==0) mStar = 288;
		if (j==1) mStar = 144;
		if (j==2) mStar = 96;
		if (j==3) mStar = 72;
		if (j==4) mStar = 48;
		if (j==5) mStar = 36;
		if (j==6) mStar = 32;
		if (j==7) mStar = 24;
		if (j==8) mStar = 18;
		if (j==9) mStar = 16;
		if (j==10) mStar = 12;
		if (j==11) mStar = 9;
		if (j==12) mStar = 8;
		if (j==13) mStar = 6;
		if (j==14) mStar = 4;
		if (j==15) mStar = 3;
		if (j==16) mStar = 2;
		if (j==17) mStar = 1;
//		if (j==0) mStar=288/4;
//		if (j==1) mStar=288/12;
//		if (j==2) mStar=288/(12*4);
//		if (j==3) mStar=1;

		M=288/mStar;
	    z = aggregater(x,mStar);
	    z2 = aggregater(z.*z,M);
		xy[0][j] = M;
		xy[1][j] = mStar;

//
////	decl acf_store, acf_store1,r, zr;
	xstart = 2.0, xdiff = 0.5;
//	
	for (i=0; i<1; i++)
	{
	    r = xstart + xdiff*i;
		zr = aggregater(fabs(z).^r,M)';

		print(M~zr[0:4][]');
		xstore[][j] = zr[0:rows(xstore)-1][];
		xstore4[][j]= (aggregater(fabs(z).^4,M)')[0:rows(xstore)-1][];

	}
//
	


	}


    decl is = 6;

	for (j=0; j<9; j++)
	{
	DrawXMatrix(j,xstore[j][is:]|exp((log(xstore[j][is:])+2.0*sqrt(0.6666*xstore4[j][is:]./(xstore[j][is:].*xstore[j][is:]))))
	|exp((log(xstore[j][is:])-2.0*sqrt(0.6666*xstore4[j][is:]./(xstore[j][is:].*xstore[j][is:])))),
	{"Realised vol","Upper 97.5%","Lower 2.5%"},log10(xy[][is:]),"",0);
	DrawAdjust(ADJ_MINMAX,0,2);
	print(j~j);
	}
	ShowDrawWindow();

//	DrawMatrix(0,meanc(xstore[][1:])
//	             |(meanc(xstore[][1:])+2.0*sqrt(varc(xstore[][1:])/rows(xstore)))
//	             |(meanc(xstore[][1:])-2.0*sqrt(varc(xstore[][1:])/rows(xstore))),"",0,1,0);
//	DrawXMatrix(0,meanc(xstore[][is:])
//	             |(meanc(xstore[][is:])+2.0*sqrt(0.666666*meanc(xstore4[][is:])/rows(xstore)))
//	             |(meanc(xstore[][is:])-2.0*sqrt(0.666666*meanc(xstore4[][is:])/rows(xstore))),
//				 {"Realised vol","Upper 97.5%","Lower 2.5%"},log10(xy[0][])[][is:],"",0,1,0);


	decl xyz = xstore[][is]'|exp(log(xstore[][is])+2.0*sqrt(0.6666*xstore4[][is]./(xstore[][is].*xstore[][is])))'
	|exp(log(xstore[][is])-2.0*sqrt(0.6666*xstore4[][is]./(xstore[][is].*xstore[][is])))';

	print(xyz');

//	xyz = log(xyz);

	DrawLine(0,0,min(xyz),0,max(xyz),0);
	for (i=0; i<columns(xyz); i++)
	{
      DrawLine(0,i,xyz[1][i],i,xyz[2][i],1);
	  DrawLine(0,i-0.2,xyz[0][i],i+0.2,xyz[0][i],2);
	}
	Draw(0,xyz[0][],0,1);
//	DrawX(1,xyz[1][]-xyz[0][],xyz[0][]);
//    Draw(1,xyz,0,1);
//	Draw(1,diff0(log(xstore[][is]),1)',0,1);
	SetDrawWindow("bye");
	ShowDrawWindow();

	print(xy');

}