/* (C) Ole E. Barndorff-Nielsen and Neil Shephard (2002). Written for
"Estimating quadratic variation using realised variance,"
Journal of Applied Econometrics

*/

#include <oxstd.h>
#include <oxdraw.h>

main()
{
     decl i;

	 decl y = zeros(5,107);
	 decl x = loadmat("djia.dat");
	 print(x[5439][3] - x[5438][3]);

	 decl xbrown = sqrt(0.04/110).*cumulate(rann(1,110)')';
	 xbrown = xbrown - xbrown[0][columns(xbrown)-1];
	 xbrown = log(x[5438][3])  + (log(x[5439][3]) - log(x[5438][3]))*range(0,109)./110
	 + xbrown;
	 xbrown = exp(xbrown);
	 xbrown = 1914*ones(110,1)~0~0~xbrown';
	 x = x[:5438][]|xbrown|x[5439:][];
	 
	 Draw(0,x[5390:5800][3]',1914 + 5/12,1.0/280);
	 DrawLine(0,1914 + 7/12,55,1914 + 7/12,90,1);
	 DrawLine(0,1915,55,1915,90,1);
	 SetDrawWindow("data");
	 ShowDrawWindow();
	 
	 x[][3] = diff0(log(x[][3]),1);
	 decl iyear = 1896;

	 

//	 print(x[:28000][]);

	 for (i=0; i<rows(x); i++)
	 {
//	     print(i~x[i][0]~x[i][0]-iyear);
	     y[0][x[i][0]-iyear] += fabs(x[i][3]);
		 y[1][x[i][0]-iyear] += fabs(x[i][3])^2;
		 y[2][x[i][0]-iyear] += fabs(x[i][3])^4;
		 y[3][x[i][0]-iyear] += 1;
		 y[4][x[i][0]-iyear] += x[i][3];
	 }
	 

     decl se = sqrt(0.6666.*y[2][]./(y[1][].*y[1][]));






    decl xyz = sqrt(y[1][]|exp((log(y[1][])+2.0.*se)|(log(y[1][])-2.0.*se)));
	xyz = xyz[][:columns(xyz)-2];

//	print(xyz');

//	xyz = log(xyz);

	DrawLine(0,iyear,min(xyz),iyear,max(xyz),0);
	for (i=0; i<columns(xyz); i++)
	{
      DrawLine(0,i+iyear,xyz[1][i],i+iyear,xyz[2][i],1);
	  DrawLine(0,i-0.2+iyear,xyz[0][i],i+0.2+iyear,xyz[0][i],2);
	}
	Draw(0,xyz[0][],iyear,1);
//	DrawX(1,xyz[1][]-xyz[0][],xyz[0][]);
	SetDrawWindow("bye");
	DrawTitle(0,"95% confidence intervals for annual realised standard deviation");
	ShowDrawWindow();

}