function fit=locpolyest(x,y,b,p,kern);

n = size(x,1);
xx = x';

epanekerf=@(z)(3/4)*(1- z.*z).*(z.*z < 1);
gausskerf=@(z)exp(-z.*z/2)/sqrt(2*pi);

if size(b,1) == 1 ;
    b = b*ones(n,1) ;
end ;

fit = ones(n,p+1) ;

for i=1:n ;
    xc = x - xx(i);
    if     kern == 1                  % Epanechnikov Kernel
        w = epanekerf(xc/b(i));
    elseif kern == 2                   % Gaussian Kernel
        w = gausskerf(xc/b(i));
    end
    
    xm = ones(n,1);
    for jj = 1:p ;
        xm = [xm,(xc.^jj)] ;
        jj = jj + 1;
    end ;
    
    w2 = w*ones(1,size(xm,2)) ;
    ixwx = inv(xm'* (w2.*xm)) ;
    ixwxxw = ixwx*(w2.*xm)' ;
    betas = ixwxxw * y ;
    fit(i,:) =  betas ;
    
end ;
