clear all
clc
close all

mem = input('type of household:\n (1) 1 member\n (2) 2 members\n (3) 2-3 members\n (4) 2-4 members\n');


TOTEXP = NaN(5000,1);

START = 1977;
END = 1986;

years = START:END;

for t = years
    i = t-START+1;
    if mem == 1
        filename = ['realtotexp_' num2str(t) '_1member.csv'];
    elseif mem == 2
        filename = ['realtotexp_' num2str(t) '_2member.csv'];
    elseif mem == 3
        filename = ['realtotexp_' num2str(t) '_2_3member.csv'];
    elseif mem == 4
        filename = ['realtotexp_' num2str(t) '_2_4member.csv'];
    end
    
    te = csvread(filename,1,1);
    te = te(:,2);
    N(i,1) = size(te,1);
    TOTEXP(1:N(i,1),i) = te;
    
    %     XI(i,:) = prctile(te,[1:25:100]);
    %     F(i,:) = ksdensity(te,XI(i,:));
    
    [F(i,:),XI] = ksdensity(te);
    
    MMax(i,1) = max(te);
    MMin(i,1) = min(te);
    MMea(i,1) = mean(te);
    MMed(i,1) = median(te);
    MQ25(i,1) = prctile(te,25);
    MQ75(i,1) = prctile(te,75);
    IQR(i,1) = MQ75(i)-MQ25(i);
    OUT(i,1) = {find(te>MQ75(i)+1.5*IQR(i))};
end

TOTEXP = TOTEXP(1:max(N),:);

figure
for t=years
    hold all
    i = t-START+1;
    h1 = line([i i],[MMin(i) MQ25(i)]);
    h2 = line([i i],[MQ75(i) min(MQ75(i)+1.5*IQR(i),MMax(i))]);
    h3 = line([i-0.25 i+0.25],[MQ25(i) MQ25(i)]);
    h4 = line([i-0.25 i+0.25],[MQ75(i) MQ75(i)]);
    h5 = line([i-0.25 i+0.25],[MMin(i) MMin(i)]);
    h6 = line([i-0.25 i+0.25],[MQ75(i)+1.5*IQR(i) MQ75(i)+1.5*IQR(i)]);
    h7 = line([i-0.25 i-0.25],[MQ25(i) MQ75(i)]);
    h8 = line([i+0.25 i+0.25],[MQ25(i) MQ75(i)]);
    h9 = line([i-0.25 i+0.25],[MMed(i) MMed(i)]);
    %     for h =1:size(OUT{i},1)
    %         plot(i,OUT{i}(h),'+k','MarkerSize',15)
    %     end
    set([h1 h2 h3 h4 h5 h6 h7 h8 h9],'LineWidth',2,'Color',[0 0 0])
    set([h1 h2],'LineStyle','--')
end
xlim([0 11])
ylim([-50 1200])
set(gca,'XTick',1:10)
% set(gca,'XTickLabel',{'1997','1998','1999','2000','2001','2002','2003','2004','2005','2006'})
% set(gca,'XTickLabel',{'1987','1988','1989','1990','1991','1992','1993','1994','1995','1996'})
set(gca,'XTickLabel',{'1977','1978','1979','1980','1981','1982','1983','1984','1985','1986'})

box on
hx = xlabel('Years');
hy = ylabel('Total expenditure');
set([hx hy],'Interpreter','latex','FontSize',16)
set(gca,'FontSize',16)
