new;
cls;

/* GAUSS code for 
   Yong Bao, Melody Lo, and Frank Mixon, "General-Interest versus Specialty
   Journals: Using Intellectual Influence of Econometrics Research to Rank
   Economics Journals and Articles", Journal of Applied Econometrics,
   forthcoming.

   The data file used was an Excel file and contains exclusively nonnumerical
   values for each article record from SSCI. 
*/

/*
Journals=
"AMERICAN ECONOMIC REVIEW"
|"ECONOMETRICA"
|"JOURNAL OF POLITICAL ECONOMY"
|"JOURNAL OF ECONOMIC THEORY"
|"QUARTERLY JOURNAL OF ECONOMICS"
|"REVIEW OF ECONOMIC STUDIES"
|"JOURNAL OF MONETARY ECONOMICS"
|"GAMES AND ECONOMIC BEHAVIOR"
|"JOURNAL OF ECONOMIC PERSPECTIVES"
|"EUROPEAN ECONOMIC REVIEW"  @JOURNAL OF THE EUROPEAN ECONOMIC ASSOCIATION@
|"ECONOMIC THEORY"
|"JOURNAL OF HUMAN RESOURCES"
|"JOURNAL OF PUBLIC ECONOMICS"
|"JOURNAL OF ECONOMIC LITERATURE"
|"ECONOMICS LETTERS"
|"JOURNAL OF ECONOMIC DYNAMICS & CONTROL"
|"JOURNAL OF LABOR ECONOMICS"
|"JOURNAL OF ENVIRONMENTAL ECONOMICS AND MANAGEMENT"
|"RAND JOURNAL OF ECONOMICS"
|"SCANDINAVIAN JOURNAL OF ECONOMICS"
|"JOURNAL OF FINANCIAL ECONOMICS"
|"OXFORD BULLETIN OF ECONOMICS AND STATISTICS"
|"JOURNAL OF INTERNATIONAL ECONOMICS"
|"JOURNAL OF ECONOMETRICS"
|"ECONOMETRIC THEORY"
|"JOURNAL OF BUSINESS & ECONOMIC STATISTICS"
|"REVIEW OF ECONOMICS AND STATISTICS"
|"INTERNATIONAL ECONOMIC REVIEW"
|"ECONOMIC JOURNAL"
|"JOURNAL OF APPLIED ECONOMETRICS"
|"JOURNAL OF THE AMERICAN STATISTICAL ASSOCIATION";

Journals1=Journals;
Journals1[10]="JOURNAL OF THE EUROPEAN ECONOMIC ASSOCIATION";

*/

Journals=xlsreadsa("c:\\research\\lo\\ranking\\Journals.xls","a1:a31",1,"");
Journals1=xlsreadsa("c:\\research\\lo\\ranking\\Journals1.xls","a1:a31",1,"");

nJ=rows(Journals); /* Number of Journals */
CrossC1=zeros(nJ,nJ); /* Cross-citations*/
CrossC2=zeros(nJ,nJ); /* Cross-citations, self-excluded */
rep=50; /*Number of replications*/
top=30; /* Top articles */
threshold=5;

/*First step, calculate the SSCI impact factor for each journal: JEL 1984,
not done*/

/*Second step, calculate the within-displine impact factor for each journal:
JEEA2003 or Boston 2005*/

npp={};
tcsp1={};tcsp2={};tcsp3={};tcsp4={};
articles={};

npdummy=zeros(nJ,1);

for i(1,nJ,1); 

    /*load data*/
    data=xlsreadsa("c:\\research\\lo\\ranking\\Econometrics Articles (2000-2005).xls","a1:z10000",i+1,"");
    if data[1,1]$=="None"; np=1;
    else;
        npdummy[i]=1;

        j=1;
        do until data[j,2]$=="Total citations (without any adjustment)";
            j=j+1;
        endo;
        k=cols(data);
        do until (data[.,k]$=="")==0;
            k=k-1;
        endo; 
        data=data[2:j-1,1:k];

        /* delete empty rows and Record:??-??*/
        tt={};
        for j(1,rows(data),1);
            if strindx(data[j,1],"-",1)==0 and (data[j,.]$=="")==0;
                tt=tt$|data[j,.];
            endif;
        endfor;

        /* Count how many papers in this journal*/   
        np=0;
        for j(1,rows(tt),1);
            if strindx(tt[j,1],"Record:",1)/=0;
                np=np+1;
                tt[j,1]="Record: "$+ftocv(np,1,0);
            endif;
        endfor;  

        csp1={};csp2={}; aaa={};
        if np<=threshold; /* Any journal with # of total articles<=threshold is excluded */
        else;
            for j(1,np,1);
                ii=1;
                do until strindx(tt[ii,1],"Record: "$+ftocv(j,1,0),1)/=0;            
                    ii=ii+1;
                endo;
                k=0;
                do until strindx(tt[ii+k,1],"Database:",1)/=0;
                    k=k+1;
                endo;
                paper=tt[ii:ii+k,.]; /* Locate the jth paper in the ith journal */
                /* We may want to exclude the 2005 data. The following code can be added
                    to check if a paper is from 2005:
                    if strindx(paper[4,2],"2005",1)/=0;
                */ 

                {T1,T2}=CC(paper,i);
                CrossC1[.,i]=CrossC1[.,i]+T1;
                CrossC2[.,i]=CrossC2[.,i]+T2;
                aaa=aaa$|(Rauthor(paper[3,2])$+" ("$+Rjounral(paper[5,2])$+")");                
                csp1=csp1|sumc(T1);
                csp2=csp2|sumc(T2);            
            endfor; 
        endif;
    endif; 
    npp=npp|np;  
    if rows(aaa)>0;        
        articles=articles$|aaa; 
        tcsp1=tcsp1|csp1; 
        tcsp2=tcsp2|csp2;
    endif;
endfor;

for i(1,nJ,1);
    if npdummy[i]==1;
        npdummy[i]=npp[i];
    endif;
endfor;

C=CrossC1'; /* Now Cij is # of citiations to Journal i from Journal j*/
Q1=sumc(C')./npp; /*size adjusted*/
score1=100*Q1/maxc(Q1); 
Cself=diagrv(C,zeros(nJ,1));  /*Self-citations ajusted*/ /*Cself=CrossC2'*/
Q2=sumc(Cself')./npp; /*Self-citations and size ajusted values*/
score2=100*Q2/maxc(Q2); 
score3=JEEA2003(Cself,rep,npp);
score4=Boston2005(Cself,rep,npp);

for i(1,nJ,1); 
    
    /*load data*/
    data=xlsreadsa("c:\\research\\lo\\ranking\\Econometrics Articles (2000-2005).xls","a1:z10000",i+1,"");
    if data[1,1]$=="None"; np=1;
    else;

        j=1;
        do until data[j,2]$=="Total citations (without any adjustment)";
            j=j+1;
        endo;
        k=cols(data);
        do until (data[.,k]$=="")==0;
            k=k-1;
        endo; 
        data=data[2:j-1,1:k];

        /* delete empty rows and Record:??-??*/
        tt={};
        for j(1,rows(data),1);
            if strindx(data[j,1],"-",1)==0 and (data[j,.]$=="")==0;
                tt=tt$|data[j,.];
            endif;
        endfor;

        /* Count how many papers in this journal*/   
        np=0;
        for j(1,rows(tt),1);
            if strindx(tt[j,1],"Record:",1)/=0;
                np=np+1;
                tt[j,1]="Record: "$+ftocv(np,1,0);
            endif;
        endfor;  

        csp3={};csp4={};
        if np<=threshold; /* Any journal with # of total articles<=threshold is excluded */
        else;        
            for j(1,np,1);
                ii=1;
                do until strindx(tt[ii,1],"Record: "$+ftocv(j,1,0),1)/=0;            
                    ii=ii+1;
                endo;
                k=0;
                do until strindx(tt[ii+k,1],"Database:",1)/=0;
                    k=k+1;
                endo;
                paper=tt[ii:ii+k,.]; /* Locate the jth paper in the ith journal */
                /* We may want to exclude the 2005 data. The following code can be added
                    to check if a paper is from 2005:
                    if strindx(paper[4,2],"2005",1)/=0;
                */ 
                {T1,T2}=CC(paper,i);
                temp3=0; temp4=0;
                for jj(1,nJ,1);
                    temp3=temp3+(T2[jj]/npp[jj])*score3[jj];
                    temp4=temp4+(T2[jj]/npp[jj])*score4[jj]/(sumc(Cself[.,jj])/npp[jj]);
                endfor;

                csp3=csp3|temp3;
                csp4=csp4|temp4;
            
            endfor; 
        endif;
    endif;        
    if rows(csp3)>0; 
        tcsp3=tcsp3|csp3; 
        tcsp4=tcsp4|csp4; 
    endif;  
endfor;

articlescore=tcsp1~tcsp2~tcsp3~tcsp4;

/*
tempmean=meanc(temp[.,2]);
for i(1,4,1);
    temp[.,i]=tempmean*temp[.,i]/meanc(temp[.,i]);
endfor;
*/

tempind=rev(sortind(articlescore[.,4]));
articlescore=articlescore[tempind,.];
articles=articles[tempind];

articlescore=articlescore[1:top,.]; /* Top articles */
tempind=tempind[1:top];
articles=articles[1:top];

tempmean=meanc(articlescore[.,1]);
for i(1,4,1);
    articlescore[.,i]=tempmean*articlescore[.,i]/meanc(articlescore[.,i]);
endfor;

Q4=rev(sortind(score4)); 
journalscore=npdummy~score1~score2~score3~score4;
journalscore=journalscore[Q4,.];

jounralranking=ftocv(seqa(1,1,nJ),1,0)$~Journals[Q4]$~ftocv(journalscore[.,1],1,0)
        $~ftocv(journalscore[.,2],1,2)$~ftocv(journalscore[.,3],1,2)
        $~ftocv(journalscore[.,4],1,2)$~ftocv(journalscore[.,5],1,2);

jounralranking=("Rank*"$~"Journal"$~"Econometrics Articles"$~"[1]"$~"[2]"$~"[3]"$~"[4]")
        $|jounralRanking
        $|(""$~""$~""$~""$~""$~""$~"")
        $|("Notes: *Rank is based on Column [4]"$~""$~""$~""$~""$~""$~"")
        $|("Column [1] Size Adjusted"$~""$~""$~""$~""$~""$~"")
        $|("Column [2] Size and Self-Citations Adjusted"$~""$~""$~""$~""$~""$~"")
        $|("Column [3] Size, Self-Citations, and Impact Adjusted"$~""$~""$~""$~""$~""$~"")
        $|("Column [4] Size, Self-Citations, Impact, and Intensity Adjusted"$~""$~""$~""$~""$~""$~"");

ret=xlsWritesa(jounralranking, "c:\\research\\lo\\ranking\\JournalsRanking020407_Revised_Mostcited.xls", "a1", 1, "");

articleranking=("Rank*"$~"Article"$~"[1]"$~"[2]"$~"[3]"$~"[4]")
        $|(ftocv(seqa(1,1,rows(articles)),1,0)$~articles$~ftocv(articlescore,1,2))
        $|(""$~""$~""$~""$~""$~"")
        $|("Notes: *Rank is based on Column [4]"$~""$~""$~""$~""$~"")
        $|("Column [1] Unweighted"$~""$~""$~""$~""$~"")
        $|("Column [2] Unweighted, Journal Self-Citations Adjusted"$~""$~""$~""$~""$~"")
        $|("Column [3] Weighted: Journal Size, Self-Citations, and Impact Adjusted"$~""$~""$~""$~""$~"")
        $|("Column [4] Weighted: Journal Size, Self-Citations, Impact, and Intensity Adjusted"$~""$~""$~""$~""$~"");
ret=xlsWritesa(articleranking, "c:\\research\\lo\\ranking\\articleRanking020407_Revised_Mostcited.xls", "a1", 1, "");

end;

proc(2)=CC(paper,ni); /* Count citations of the paper within the nJ journals */
local C,Cself,nc,j,citations;
nc=cols(paper);
C=zeros(nJ,1);
Cself=zeros(nJ,1);
if paper[2,4]$/="0";
    for j(5,nc,1);
        citations=paper[.,j];
        C=C+ccite(citations,0);  
        Cself=Cself+ccite(citations,ni);   /* self excluded */    
    endfor;    
endif;
retp(C,Cself); /* C is a column of nJx1, each row gives the citations of this paper by the corresponding journal*/
endp;
    
proc ccite(citations,ni); /* citations is a row vector */
local n,i,c,cc,cc1;
n=rows(citations);
c={};
for i(1,n,1);
    if (citations[i,.]$=="")==0; /*delete empty rows*/
            c=c$|citations[i,.];
    endif;
endfor;
n=rows(c);
cc=zeros(nJ,1); cc1=cc;
for i(1,n,1);
   cc=cc+check(c[i],Journals,ni);
   cc1=cc1+check(c[i],Journals1,ni);
endfor;
cc[10]=cc[10]+cc1[10];
retp(cc);
endp;

proc check(cj,list,ni);
local c,n,i,x,y;
n=rows(list);
c=zeros(n,1);
for i(1,n,1);
    {x,y}=splitcj(cj);
    if list[i]$==x and i/=ni; /* exclude self-citations*/        
        c[i]=y;
    endif;
endfor;
retp(c);
endp;

proc(2)=splitcj(cj);
local x,y,j,k;
j=strindx(cj,"(",1);
k=strindx(cj,")",1);
y=stof(strsect(cj,j+1,k-j-1));
x=strsect(cj,1,j-2);
retp(x,y);
endp;    

proc JEEA2003(C,rep,size);
local temp,r,i,j,Q,nJ;
nJ=rows(C);
Q=zeros(nJ,1); 
temp=zeros(nJ,1);
for r(0,rep,1);
    if r==0;
        for i(1,nJ,1);    
            temp[i]=sumc(C[i,.]')/size[i];            
        endfor;    
        temp=100*temp/maxc(temp);     
    else;
        for i(1,nJ,1);
            for j(1,nJ,1);
                Q[i]=Q[i]+C[i,j]*temp[j];
            endfor;  
            Q[i]=Q[i]/size[i];
        endfor;
        Q=100*Q/maxc(Q); 
        temp=Q;
    endif;
endfor;
retp(Q);
endp; 

proc Boston2005(C,rep,size);
local temp,r,i,j,Q,nJ;
nJ=rows(C);
Q=zeros(nJ,1);
temp=zeros(nJ,1);
for r(0,rep,1);
    if r==0;
        for i(1,nJ,1); 
            for j(1,nJ,1);
                temp[i]=temp[i]+C[i,j]/(sumc(C[.,j])/size[j]);
            endfor;
            temp[i]=temp[i]/size[i];
        endfor;        
        temp=100*temp/maxc(temp); 
    else;
        for i(1,nJ,1);
            for j(1,nJ,1);
                Q[i]=Q[i]+temp[j]*C[i,j]/(sumc(C[.,j])/size[j]);
            endfor;
            Q[i]=Q[i]/size[i];
        endfor;       
        Q=100*Q/maxc(Q); 
        temp=Q;
    endif;
endfor;
retp(Q);
endp;      

proc Rjounral(name);
local n,i,x,y,z;
n=strlen(name);
i=1;
do until strsect(name,i,1)$==",";
    i=i+1;
endo;
x=strsect(name,1,i);
y=strsect(name,i+1,n-i);

i=1;
do until strsect(y,i,1)$==",";
    i=i+1;
endo;
z=strsect(y,i-4,4); 
x=x$+" "$+z;
retp(x);
endp;

proc Rauthor(names);
local i,n,x,y,z;
if strindx(names,";",1)==0;    
    retp(aauthor(names));
else;
    i=strindx(names,";",1);   
    y={}; z=names;
    do until i==0;
        x=strsect(z,1,i-1);
        y=y$|aauthor(x);
        z=strsect(z,i+2,strlen(z)-(i+2)+1);
        i=strindx(z,";",1); 
    endo;
    y=y$|aauthor(z);    
    if rows(y)==2;
        x=y[1]$+" and "$+y[2];
    else;
        x="";
        for i(1,rows(y)-1,1);
            x=x$+y[i]$+", ";
        endfor;
        x=x$+"and "$+y[rows(y)];
    endif;
    retp(x);
endif;
endp;         

proc aauthor(name);
local i,x;
i=strindx(name,",",1);
x=strsect(name,1,i-1);
retp(x);
endp;
