
version 6.0

# delimit;

capture log close;

log using M:\Distn\choicesetpaper\2004choicesets\choiceset_5mo_44pct_allco.log, replace;

/*choiceset_5mo_44pct_allco.do:  get choice sets from mergemaster1 for clogits.
Time window of 5 months; budget constraint of 44% of adjinc; all counties.
40,000 households with 15 choices.*/

clear;

set mem 100000;

set more off;

set seed 123456789;

use M:\Distn\newpubgood\Data\Pooled\mergemaster3;

/*do some additional data cleaning & dropping of vars*/

drop if SALEPRCE<50000; /*still some very low sale prices after trim*/
gen x=mod(bathrms,0.25); /*some weird bathrm values*/
drop if x~=0 & x~=.;
drop x;

/*drop obs with missing values now.  No point in spending lots of 
computer time to draw obs that will be dropped later.*/

drop if SALEPRCE==.;
drop if bathrms==.;
drop if bedrms==.;
drop if sqftbldg==.;
drop if sqftlot==.;
drop if age==.;
drop if pool==.;
drop if firepl==.;
drop if inc_ownr==.;

/*adjust incomes*/
 gen adjinc=inc_ownr;
 replace adjinc=adjinc*1.014 if SALEYEAR==1990;
 replace adjinc=adjinc*1.027 if SALEYEAR==1991;
 replace adjinc=adjinc*1.041 if SALEYEAR==1992;
 replace adjinc=adjinc*1.074 if SALEYEAR==1993;
 replace adjinc=adjinc*1.106 if SALEYEAR==1994;
 replace adjinc=adjinc+(.116*97600) if SALEYEAR==1989;
 replace adjinc=adjinc+(.116*97600) if SALEYEAR==1990;
 replace adjinc=adjinc+(.116*97600) if SALEYEAR==1991;
 replace adjinc=adjinc+(.116*97700) if SALEYEAR==1992;
 replace adjinc=adjinc+(.116*99200) if SALEYEAR==1993;
 replace adjinc=adjinc+(.116*100800) if SALEYEAR==1994;

 /*be parsimonious in this file.  Then merge variables back in later.*/
keep idno saledat SALEPRCE adjinc;

tempfile motherb;
save "motherb", replace;

clear;

/*************************************************************************/

/*define program for generating 5 choicesets*/

capture program drop chset;
program define chset;

local h=1;
while `h'<=3 {;

use "motherb";
gen ranuni = uniform();

/*get data set to sample from and set of 40000 houses actualy chosen*/

replace ranuni=1 if 0.116*SALEPRCE/adjinc >= 0.44;
sort ranuni;

gen x=0;
replace x=-1 if _n<=40000;
sort x saledat;
gen hhold = _n if _n <= 40000; /*numeric id for _household_*/
sort saledat;
gen idno2 =_n; /*need a numeric id for _house_*/
drop x;

save "sample", replace;

keep if hhold ~=.;
drop if ranuni==1; 
drop ranuni;
gen choice=1;
tempfile tempb1;
save "tempb1", replace;

clear;
set mem 50000;

/*now add houses NOT chosen for each hhold*/

tempfile tempb2;
tempname nochsb;
postfile `nochsb' idno2 hhold flag using "tempb2", replace;

/*go through week by week*/
local k = 1989;
while `k' < 1995 {;

/*time window for households observed to buy in week k*/
drop _all;
use "sample" if saledat >= `k'-(5/24) & saledat <= `k'+(7/365)+(5/24);

/*get codes for households observed this week*/
quietly replace hhold=. if saledat < `k' | saledat >= `k' + 7/365;
quietly sum hhold;
scalar min=r(min);
scalar max=r(max);

if max~=. {; /*non-empty week*/

quietly gen x=1; /*flag: x=1 means invalid observation*/
quietly gen ran=.;

  local j=min;
  while `j' <= max  {;  

  /*reset data*/
  quietly replace x=1;
  quietly replace ran = uniform();

  /*get info on choosing hhold*/
  quietly sum adjinc if hhold==`j', meanonly;
  scalar inc=r(mean);
  quietly sum saledat if hhold==`j', meanonly;
  scalar date=r(mean);

  quietly replace x=0 if hhold~=`j'
                       & 0.116*SALEPRCE/inc < 0.44
                       & saledat >= date-(5/24) & saledat <= date+(5/24);  /*valid choices*/

  quietly sort x ran; /*random selection of valid choices at top*/

  capture {;

  local i=1; /*get top 14 obs.  Hopefully 1 valid, if not, delete below*/
  while `i' <= 14 {; 

    post `nochsb' idno2[`i'] `j' x[`i'];

    local i = `i'+1;

    };

  }; /*end capture*/

  if _rc~=0 {; /*if BREAK or error, save results before exiting*/
    postclose `nochsb';
    exit;
  };

  local j = `j'+1; 
   
  };

}; /*end commands if max~=.*/

local k = `k' + 7/365;

};

postclose `nochsb';

/*merge with chosen houses*/

clear;

use "tempb2";
drop if flag==1; /*delete any invalid choices in top 14*/
drop flag;
sort idno2;
gen choice=0;
save "tempb2", replace;
clear;

use "sample";
drop hhold;
sort idno2;
merge idno2 using "tempb2";
tab _merge;
keep if choice==0;
drop adjinc _merge;
append using "tempb1";
drop idno2;
gsort hhold -choice;
drop ranuni;

egen x=max(adjinc), by(hhold);
replace adjinc=x;
drop x;

/*bring back in other descriptive variables when working*/

local x="M:\Distn\choicesetpaper\2004choicesets\choiceset_5mo_0pct_44pct_allco_"+"`h'";

save `x', replace;

local h = `h'+1;

};

end;

chset;

log close;  
  

    
 






