# delimit;

capture log close;

log using c:/distn/choicesetpaper/2004choicesets/choicerobust_sqrt2_wdemog.log, replace;

/*choicerobust_sqrt2_wdemog.do:  
check sensitivity of wtp to choice set definitions, with sqrt spec. & demog interactions*/

clear;

set mem 250000;

set seed 123456789;

set more off;

tempfile temp0b;

use c:/distn/choicesetpaper/2004choicesets/choicedataset;

gen adjinc_x = inc_ownr+.116*97600; /*adjinc for use in mwtp below, not for logits*/ 
drop inc_ownr;

gen SALEYEAR=int(saledat);

gen   nrozna3lr = 366-nrozna3l;
gen rtnrozna3lr = sqrt(366-nrozna3l);
gen rtnrozna89r = sqrt(366-oz3l89);
gen rtnrozna96r = sqrt(366-oz3l96);
gen rtnrozna_randr= sqrt(366-nrozna_rand);
drop nrozna3l oz3l89 oz3l96 nrozna_rand;

gen rttest= sqrt(math+reading);
drop math reading;
gen rttch_sd = sqrt(tchsd3l);
drop tchsd3l;
gen rtcrime3lr = sqrt(3000-crime3l);
drop crime3l;

gen rtbed    = sqrt(bedrms);
gen rtbath   = sqrt(bathrms);
gen rtbldg   = sqrt(sqftbldg);
gen rtlot    = sqrt(sqftlot);
gen rtage    = sqrt(age+1);
drop bedrms bathrms sqftbldg sqftlot age;

gen     coast1 = 1 if coastmi <=1;
replace coast1 = 0 if coastmi > 1;
gen     orange=1 if COUNTY=="or";
replace orange=0 if COUNTY~="or" & length(COUNTY)~=0;
gen     sanbern=1 if COUNTY=="sb";
replace sanbern=0 if COUNTY~="sb" & length(COUNTY)~=0;
gen     riversd=1 if COUNTY=="rv";
replace riversd=0 if COUNTY~="rv" & length(COUNTY)~=0;
gen     ventura=1 if COUNTY=="va";
replace ventura=0 if COUNTY~="va" & length(COUNTY)~=0;
drop coastmi;

gen blackona = pctblack*rtnrozna3lr;
gen blackona96 = pctblack*rtnrozna96r;
gen blackonar = pctblack*rtnrozna_randr;
gen blacktch = pctblack*rttch_sd;
gen blactest = pctblack*rttest;
gen blaccrim = pctblack*rtcrime3lr;

gen hispona = pcthisp*rtnrozna3lr;
gen hispona96 = pcthisp*rtnrozna96r;
gen hisponar = pcthisp*rtnrozna_randr;
gen hisptch = pcthisp*rttch_sd;
gen hisptst = pcthisp*rttest;
gen hispcrm = pcthisp*rtcrime3lr;

gen chldona = pcthhcld*rtnrozna3lr;
gen chldona96 = pcthhcld*rtnrozna96r;
gen chldonar = pcthhcld*rtnrozna_randr;
gen chldtch = pcthhcld*rttch_sd;
gen chldtst = pcthhcld*rttest;
gen chldcrm = pcthhcld*rtcrime3lr;

gen marona = pcthhmar*rtnrozna3lr;
gen marona96 = pcthhmar*rtnrozna96r;
gen maronar = pcthhmar*rtnrozna_randr;
gen martch = pcthhmar*rttch_sd;
gen martst = pcthhmar*rttest;
gen marcrm = pcthhmar*rtcrime3lr;

gen colona = pctcol*rtnrozna3lr;
gen colona96 = pctcol*rtnrozna96r;
gen colonar = pctcol*rtnrozna_randr;
gen coltch = pctcol*rttch_sd;
gen coltst = pctcol*rttest;
gen colcrm = pctcol*rtcrime3lr;

gen chldbath= pcthhcld*rtbath;
gen chldbldg= pcthhcld*rtbldg;
gen chldlot = pcthhcld*rtlot;

gen hispbldg= pcthisp*rtbldg;
gen hisplot = pcthisp*rtlot;

gen blacbldg= pctblack*rtbldg;
gen blacklot= pctblack*rtlot;


gen month = month((saledat-1960)*365);
drop saledat;

compress;

sort idno;
quietly save c:\Distn\choicesetpaper\2004choicesets\temp0b, replace;
drop _all;

capture program drop dorobust;
program define dorobust;

tempname result;
postfile `result' est_mo est_inclow est_inchigh est_co draw margwtp 
                  welf_mo welf_inclow welf_inchigh welf_co
                  exactwtp_89_96 exactwtp_rand hhinc co mu_inc_flag
  using c:/distn/choicesetpaper/2004choicesets/temp1, replace;

/*Go through choice sets used for _estimation_:  
time windows, budget shares, geographic areas--3 random draws each.
Do the clogit for each and get marginal values.*/

local i=5;
while `i' <= 7 {;  

  local jlow=1;
  while `jlow' <=4 {;

    if `jlow'==1 {; local inclow=17; }; 
    if `jlow'==2 {; local inclow=14; };
    if `jlow'==3 {; local inclow=10; };
    if `jlow'==4 {; local inclow= 0; };

  local jup=1;  
  while `jup' <= 4 {;  

    if `jup'==1 {; local incup= 44; }; 
    if `jup'==2 {; local incup= 52; };
    if `jup'==3 {; local incup= 63; };
    if `jup'==4 {; local incup=100; };

    local k=1;
    while `k' <=5 {;  

      if `k'==1 {; local co=  "1co_"; };
      if `k'==5 {; local co="allco_"; };

      local L=1;
      while `L'<=3 {;  

        local x="c:\Distn\choicesetpaper\2004choicesets\choiceset_"+"`i'"+"mo_"+"`inclow'"+"pct_"+"`incup'"+"pct_"+"`co'"+"`L'";

        quietly {;
        use `x';
        sort idno;
        merge idno using c:\Distn\choicesetpaper\2004choicesets\temp0b;

        keep if _merge==3;
        drop _merge;
        sort hhold;
        gen rtnetinc = sqrt(adjinc-.116*SALEPRCE);
        }; /*end quietly*/

        set matsize 50;

        clogit choice orange sanbern riversd ventura coast1
               rtnrozna3lr rttch_sd rttest rtcrime3lr
               blackona blacktch blactest blaccrim
               hispona hisptch hisptst hispcrm 
               chldona chldtch chldtst chldcrm
               marona martch martst marcrm
               colona coltch coltst colcrm
               rtbath rtbldg rtlot firepl pool rtage
               chldbath chldbldg chldlot blacbldg blacklot hispbldg hisplot
               rtnetinc,
               group(hhold);

        if _b[rtnetinc]>=0 {;
           scalar flag=0;
           };
           else scalar flag=1;


/*Now for each choice set used in estimation, get exact wtp for the same choice set,
and for all choice sets of which it is a proper subset.*/

        local m=`i'; /*start at time window for estimator's choice set, and get broader*/
        while `m' <= 7 {;

          local nlow= `jlow'; /*start at budget share for estimator's set, and get broader*/
          while `nlow' <= 4 {; 

          local nup=`jup'; /*start at budget share for estimator's set, and get broader*/
          while `nup' <= 4 {; 

            local p=`k'; /*start at geographic area for estamator, then get broader*/
            while `p' <= 5 {;

              display _newline "months=`i' budgetlow=`jlow' budgetup=`jup' counties=`k' draw=`L'   m=`m'  nlow=`nlow' nup=`nup' p=`p' "; 

              drop _all;

              use c:\Distn\choicesetpaper\2004choicesets\temp0b if SALEYEAR==1989 & month>=3 & month<=9;

              /*get marginal wtp first time around*/

              if `m'==`i' & `nlow'==`jlow' & `nup'==`jup' & `p'==`k' {;

              quietly gen mwtp = ( _b[rtnrozna3lr]
                                  +_b[blackona]*pctblack
                                  +_b[hispona]*pcthisp
                                  +_b[chldona]*pcthhcld
                                  +_b[marona]*pcthhmar
                                  +_b[colona]*pctcol
                                 )*sqrt(adjinc_x-.116*SALEPRCE)/(_b[rtnetinc]*rtnrozna3lr);

              sum mwtp if adjinc_x-.116*SALEPRCE > 0; /*in 'real' data some hholds do not meet cutoff*/
              scalar margwtp=r(mean);
              };

if flag==0 {;

              /*create vars to write into during sims*/
              quietly {;
              gen error=.;
              gen utilx=.;
              gen rtnetinc=.;
              };

              /*draw sample hholds & get exact welfare*/
              local q=1;
              while `q' <= 200 {;

            /*  display "  q = `q'";  */

              capture {;  /*if BREAK or error, save results before exiting*/   

              /*characterize a household*/

  scalar bblack =0;
  scalar hhisp  =0;
  scalar married=0;
  scalar child  =0;
  scalar college=0;

  scalar race   = uniform();
  scalar family = uniform();
  scalar educat = uniform();

  if race <= 0.084 {; 

     scalar bblack = 1; 
     
     if family <= 0.351 {; scalar married=1; };
     if family <= 0.180 | (family >  0.351 & family <= 0.541 ) {; scalar child=1; };

     if educat <= 0.149 {; scalar college=1; };

     };

  if race > 0.084 & race <= 0.408 {; 
     
     scalar hhisp  = 1; 
     
     if family <= 0.602 {; scalar married=1; };
     if family <= 0.429 | (family >  0.602 & family <= 0.749 ) {; scalar child=1; };

     if educat <= 0.063 {; scalar college=1; };

     };

  if race > 0.408 {; 
     
     if family <= 0.538 {; scalar married=1; };
     if family <= 0.235 | (family >  0.538 & family <= 0.589 ) {; scalar child=1; };

     if educat <= 0.316 {; scalar college=1; };

     };
 
  scalar hhinc = exp( 10.477 -.1314*bblack -.1097*hhisp -.04*child +.3206*college 
                     + 0.855*invnorm(uniform()) );

  scalar x = uniform(); /*to indicate "home county"*/

              quietly {; 

              replace error = -ln(-ln( uniform() )) - 0.5772;
              replace rtnetinc = sqrt(hhinc - .116*SALEPRCE);

              /*get vector of utilities before*/ 



  quietly gen utila  =  _b[coast1]*coast1
       + (_b[rtnrozna3lr]      + _b[blackona]*bblack 
                               + _b[hispona]*hhisp 
                               + _b[chldona]*child
                               + _b[marona]*married 
                               + _b[colona]*college )*rtnrozna3lr
          + (_b[rttch_sd]      + _b[blacktch]*bblack 
                               + _b[hisptch]*hhisp 
                               + _b[chldtch]*child
                               + _b[martch]*married 
                               + _b[coltch]*college )*rttch_sd
          + (_b[rttest]        + _b[blactest]*bblack 
                               + _b[hisptst]*hhisp 
                               + _b[chldtst]*child
                               + _b[martst]*married 
                               + _b[coltst]*college )*rttest
        + (_b[rtcrime3lr]      + _b[blaccrim]*bblack 
                               + _b[hispcrm]*hhisp 
                               + _b[chldcrm]*child
                               + _b[marcrm]*married 
                               + _b[colcrm]*college )*rtcrime3lr
          + (_b[rtbath]        + _b[chldbath]*child )*rtbath
          + (_b[rtbldg]        + _b[chldbldg]*child
                               + _b[blacbldg]*bblack
                               + _b[hispbldg]*hhisp )*rtbldg
          + (_b[rtlot]         + _b[chldlot]*child
                               + _b[blacklot]*bblack
                               + _b[hisplot]*hhisp )*rtbldg
          + _b[firepl]*firepl
          + _b[pool]*pool
          + _b[rtage]*rtage
          + _b[rtnetinc]*rtnetinc
          + error; 

if `k'==5 {;   /*add county vars in when required*/
replace utila = utila + _b[orange]*orange
                      + _b[sanbern]*sanbern
                      + _b[riversd]*riversd
                      + _b[ventura]*ventura;
           };


              /*get appropriate dimensions*/
              if `m'==1 {; replace utila=. if month~=6; };
              if `m'==3 {; replace utila=. if month<5 | month>7; };
              if `m'==5 {; replace utila=. if month<4 | month>8; };
              if `m'==7 {; replace utila=. if month<3 | month>9; };    
              if `nlow'==1 {; replace utila=. if .116*SALEPRCE / hhinc <= 0.17; };    
              if `nlow'==2 {; replace utila=. if .116*SALEPRCE / hhinc <= 0.14; };
              if `nlow'==3 {; replace utila=. if .116*SALEPRCE / hhinc <= 0.10; };
              if `nlow'==4 {; replace utila=. if .116*SALEPRCE / hhinc <= 0; };
              if `nup'==1 {; replace utila=. if .116*SALEPRCE / hhinc >= 0.44; };    
              if `nup'==2 {; replace utila=. if .116*SALEPRCE / hhinc >= 0.52; };
              if `nup'==3 {; replace utila=. if .116*SALEPRCE / hhinc >= 0.63; };
              if `nup'==4 {; replace utila=. if .116*SALEPRCE / hhinc >= 1; };
              if `p'==1 &               x < 0.4508 {; replace utila=. if COUNTY~="la"; };
              if `p'==1 & x >= 0.4508 & x < 0.6735 {; replace utila=. if COUNTY~="or"; };
              if `p'==1 & x >= 0.6735 & x < 0.8101 {; replace utila=. if COUNTY~="rv"; };
              if `p'==1 & x >= 0.8101 & x < 0.9296 {; replace utila=. if COUNTY~="sb"; };
              if `p'==1 & x >= 0.9296              {; replace utila=. if COUNTY~="va"; };

              /*get vector of utilities after*/ 
              gen utilb1 = utila 
                          + (  _b[rtnrozna3lr]
                             + _b[blackona]*bblack 
                             + _b[hispona]*hhisp 
                             + _b[chldona]*child
                             + _b[marona]*married 
                             + _b[colona]*college 
                            )*(rtnrozna96r-rtnrozna3lr);

              gen utilb2 = utila 
                          + (  _b[rtnrozna3lr]
                             + _b[blackona]*bblack 
                             + _b[hispona]*hhisp 
                             + _b[chldona]*child
                             + _b[marona]*married 
                             + _b[colona]*college 
                            )*(rtnrozna_randr-rtnrozna3lr);

              /*get maximized utilities before and after*/
              sum utila, meanonly;
              scalar rlutila=r(max);
              sum utilb1, meanonly;
              scalar rlutilb1=r(max);
              sum utilb2, meanonly;
              scalar rlutilb2=r(max);

              }; /*end quietly*/ 

              /*get price for arg-max house*/
              quietly sum SALEPRCE if utila==rlutila, meanonly;
              scalar pa=r(mean);

              /*policy 1*/

              /*get starting cv values: upper bound is net income; 
                lower is cv without substitution*/
              scalar cv_h = hhinc - .116*pa - 1;
              scalar cv_l = hhinc - 0.116*pa -(1/_b[rtnetinc]^2)*(rlutila-rlutilb1+
                                               _b[rtnetinc]*(hhinc-.116*pa)^.5)^2;

              if (rlutila>rlutilb1 & _b[rtnetinc]>0) | (rlutila<rlutilb1 & _b[rtnetinc]<0) {;
              scalar cv_h = 0;
              scalar cv_l = hhinc - 0.116*pa -(1/_b[rtnetinc]^2)*(rlutila-rlutilb1+
                                               _b[rtnetinc]*(hhinc-.116*pa)^.5)^2;
              };

              if rlutila==. {; scalar cv_h=0; scalar cv_l=0; };

              /*bisection loop*/
              local r = cv_h - cv_l;
              while `r' > .02 {;

                scalar cv_bi = (cv_h + cv_l)/2;

                quietly replace utilx = utilb1 -_b[rtnetinc]*sqrt(hhinc-.116*SALEPRCE)
                                      + _b[rtnetinc]*sqrt(hhinc-.116*SALEPRCE-cv_bi);
  
                sum utilx, meanonly;

                  if ( _b[rtnetinc]> 0 & r(max) >= rlutila & r(max)~=.) 
                   | ( _b[rtnetinc]< 0 & r(max) <  rlutila & r(max)~=.)  {;
                    scalar cv_l = cv_bi;
                    };

                  if ( _b[rtnetinc]> 0 & r(max) <  rlutila & r(max)~=.) 
                   | ( _b[rtnetinc]< 0 & r(max) >= rlutila & r(max)~=.) 
                   | r(max)==. {;
                    scalar cv_h = cv_bi;
                    };

                local r = cv_h - cv_l;
                };

                scalar cv1 = (cv_h + cv_l)/2;

              /*policy 2*/

              /*get starting cv values: upper bound is minimum housing budget; 
                lower is cv without substitution*/
              scalar cv_h = hhinc - .116*pa - 1;
              scalar cv_l = hhinc - 0.116*pa -(1/_b[rtnetinc]^2)*(rlutila-rlutilb2+
                                               _b[rtnetinc]*(hhinc-.116*pa)^.5)^2;

              if (rlutila>rlutilb1 & _b[rtnetinc]>0) | (rlutila<rlutilb1 & _b[rtnetinc]<0) {;
              scalar cv_h = 0;
              scalar cv_l = hhinc - 0.116*pa -(1/_b[rtnetinc]^2)*(rlutila-rlutilb2+
                                               _b[rtnetinc]*(hhinc-.116*pa)^.5)^2;
              };

              if rlutila==. {; scalar cv_h=0; scalar cv_l=0; };

              /*bisection loop*/
              local r = cv_h - cv_l;
              while `r' > .02 {;

                scalar cv_bi = (cv_h + cv_l)/2;

                quietly replace utilx = utilb2 -_b[rtnetinc]*sqrt(hhinc-.116*SALEPRCE)
                                      + _b[rtnetinc]*sqrt(hhinc-.116*SALEPRCE-cv_bi);
  
                sum utilx, meanonly;

                  if ( _b[rtnetinc]> 0 & r(max) >= rlutila & r(max)~=.) 
                   | ( _b[rtnetinc]< 0 & r(max) <  rlutila & r(max)~=.)  {;
                    scalar cv_l = cv_bi;
                    };

                  if ( _b[rtnetinc]> 0 & r(max) <  rlutila & r(max)~=.) 
                   | ( _b[rtnetinc]< 0 & r(max) >= rlutila & r(max)~=.) 
                   | r(max)==. {;
                    scalar cv_h = cv_bi;
                    };

                local r = cv_h - cv_l;
                };

                scalar cv2 = (cv_h + cv_l)/2;

                post `result'
                              (`i') (`inclow') (`incup') (`k') (`L') (margwtp) 
                              (`m') (`nlow') (`nup') (`p') (cv1) (cv2) (hhinc) (x) (flag);

              drop utila utilb1 utilb2;

            }; /*end capture*/  
              if _rc~=0 {; /*if BREAK or error, save results before exiting*/
                 postclose `result';
                 exit;
                  };

              local q = `q' + 1;
              };

              drop _all;

}; /*end skipping of exact wtp if mu inc < 0*/

            local p = `p'+4;
            };

          local nup = `nup'+1;
          };

          local nlow = `nlow'+1;
          };

        local m = `m'+2;
        };

        drop _all;

/*Now go back and move on to next estimator*/

      local L = `L'+1;
      };

    local k = `k'+4;
    };

  local jup = `jup'+1;
  };

  local jlow = `jlow'+1;
  };

local i = `i'+2;
};    

postclose `result';

end;

dorobust;

display "$S_DATE  $S_TIME";

clear;

use c:/distn/choicesetpaper/2004choicesets/temp_sqrtdemog;
save c:/distn/choicesetpaper/2004choicesets/choicesets_sqrt2_wdemog_b, replace;

log close;
      

