function B=svecmB(mB_Res,mC1_Res,X,r,p)
dum=0;
Rtil=0;

eps1_tol = 1E-6;	%   tolerance of relative change in parameters 
eps2_tol = 1E-10; 	%   tolerance for relative change in logLik
maxIterations = 500;
iStartValueMethod = 2; % 1: draw randomly, 
                    % 2: fixed values set by "fixStart", 
                    % 3: vector specicied by user "vStartUser"
fixStart = .1;         % fixed starting value, only needed when  iStartValueMethod  = 2 
vStartUser = [.1,.2,.4,.6,.7]; %vector of start values, only needed when iStartValueMethod = 3  
                            %  dimension changes, rows(vStartUser) = cols(mS)	

iCorr = 0;         %    decompose correlation matrix first to obtain SV	
imaxRetries	= 10;   %   max. retries of randomly drawing starting values  
T=length(X);              
% Johansen procedure
[beta,alpha,mGamma,A,mSigmaU,errors,ec]= JohResConst(X,r,p);
beta = beta(:,1:end-1); % remove the trend coefficient
mGamma = mGamma(:,1:end-1); % remove the constant

% Johansen procedure without constant and other deterministics because factors zero mean
% [beta,alpha,mGamma,A,mSigmaU,errors,ec]= JohNoDet(X,r,p); 

[mCB_point,mB_point,mS,vs,model]=svec(alpha, beta, mGamma, mSigmaU,T,mB_Res,mC1_Res,eps1_tol,eps2_tol, maxIterations,iStartValueMethod,fixStart,vStartUser,iCorr,imaxRetries);
B=mB_point;