% /*
%  This file is part of the econometric software package JMulTi.
%  Copyright (C) 2000-2005  Ralf Brueggemann, Markus Kraetzig
% 
%  This program is free software; you can redistribute it and/or
%  modify it under the terms of the GNU General Public License
%  as published by the Free Software Foundation; either version 2
%  of the License, or (at your option) any later version.
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
% 
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
%  */
% #ifos2win 
% /* to be used by library creation, windows only */
% #include var.dec
% #include svar.dec
% #endif
% 
% /**
%  * SVEC ESTIMATION, August 2003, Ralf Brueggemann, Humboldt-University Berlin,
%  * some adjustments to use it with JMulTi by Markus Kr?tzig
%  */
% 
% /**
%  * mSigmaU    - K x K matrix, reduced form covariance matrix
%  * T          - number of observations used in estimation
%  */ 
% 
% /**
%  * Restriction on C and PSI can be specified here
%  *
%  *   use:
%  *    <= SVAR_UNRESTRICTED = unrestricted estimate 
%  *    0 		   = restricted to zero
%  *   other values  = restricted to specified values 
%  *
%  *  mB_Res = {   1   -1e12  0,
%  *              -1e12 1 -1e12,
%  *               0    0     1 };
%  *  
%  *  mC1_Res =  { -1e12 0   0, 
%  *              0   -1e12 0,
%  *              0     0  -1e12 };      
%  *  
%  *
%  */  
% 
% /**
%  *  eps1_tol = 1E-6;	   tolerance of relative change in parameters 
%  *  eps2_tol = 1E-10; 	   tolerance for relative change in logLik
%  *  maxIterations = 500;
%  *  iStartValueMethod = 2; 1: draw randomly, 
%  *                         2: fixed values set by "fixStart", 
%  *			   3: vector specicied by user "vStartUser"
%  *  fixStart = .1;         fixed starting value, only needed when  iStartValueMethod  = 2 
%  *  vStartUser = {.1,.2,.4,.6,.7}; vector of start values, only needed when iStartValueMethod = 3  
%  *                                 dimension changes, rows(vStartUser) = cols(mS)	
%  *
%  *  iCorr = 1;             decompose correlation matrix first to obtain SV	
%  *  imaxRetries	= 10;      max. retries of randomly drawing starting values 
%  */	
% 
% SVEC uses model=3, i.e. B model
% beta_d used for bootstrap, not assigned
% function [mCB_point,mB_point,mS,vs,vg_bs,model,m_se_B,m_se_mCB,m_tv_B,m_tv_mCB]=svec_wrapper_var(alpha, beta, beta_d, mGamma, mSigmaU,T,mB_Res,mC1_Res,eps1_tol,eps2_tol, maxIterations,iStartValueMethod,fixStart,vStartUser,iCorr,imaxRetries,fname,BS_int,bootrep,seed,var)
function [mCB_point,mB_point,mS,vs,model]=svec(alpha, beta, mGamma, mSigmaU,T,mB_Res,mC1_Res,eps1_tol,eps2_tol, maxIterations,iStartValueMethod,fixStart,vStartUser,iCorr,imaxRetries)

K  = rows(mSigmaU);
bet=beta';

%tmp=vec(mB_Res);
% for i (1,rows(tmp),1);
%     if tmp[i] < SVAR_UNRESTRICTED;
%         tmp[i]=SVAR_UNRESTRICTED;
%     end;
% end;
%mB_Res = reshape(tmp,K,K);
%tmp=vec(mC1_Res);
% for i (1,rows(tmp),1)
%     if tmp[i] < SVAR_UNRESTRICTED
%         tmp[i]=SVAR_UNRESTRICTED;
%     end
% end;
%mC1_Res = reshape(tmp,K,K);

% /* initialize some variables */

mC1		  = ComputeC1_svec_var(alpha, bet, mGamma);
mS=[];
vs=[];
vg_b=[];
vg_corr 	  = 0;	
i_iRt		  = 0;
i_itercorr	  = 0;
i_coCorr	  = 0;
mB		  = 0;
mC		  = 0;
mSigmaAB	  = 0;
mSigmaUt	  = 0;
i		  = 0;
LLnew		  = 0;
LR_stat		  = 0;
LR_prob		  = 0;
DegreeofOverIdent = 0;
noConvergence	  = 0;


										
[mS,vs,model,nfreea,nfreeb,nfreeall, nResB, nResC1] = GetResMatricesLR_svec_var(mB_Res, mC1_Res, mC1);
%   if model < 0;
%     retp(-10,-10,-10,-10,-10,-10,-10,-10,-10,-10);
%   endif;
vg  = StartingValues_svar_var(mS,iStartValueMethod,vStartUser,fixStart); 
% [i_ident, DegreeofOverIdent] = CheckIdentificationLR_svec_var(vg,mS,vs,nfreeall, nResB, nResC1);
i_ident=1;
if i_ident == 1     %/* only proceed when model is identified, otherwise inform user*/    		
  if iCorr == 1	% /* decompose correlation matrix first to obtain SV 	*/
    [vg_corr,i_iRT,i_itercorr, i_coCorr]  = DecompCorrelation_svar_var(mSigmaU,mS,vs,vg,T,eps1_tol,eps2_tol,DegreeofOverIdent,maxIterations,model, imaxRetries);	
    vg = vg_corr; 
    if i_iRT == 0 & i_coCorr == 0;	%/* only estimate when 1st step was successful*/  
      %<[mB,vg_b,mSigmaUt,i,LLnew,LR_stat,LR_prob, noConvergence] = MLEstSVECM_svec_var(mSigmaU, mS,vs,vg,T,eps1_tol, eps2_tol, DegreeofOverIdent,maxIterations,model);
      [mB,vg_B,mSigmaUt,i,LLnew,noConvergence]=MLEstSVECM_svec_var(mSigmaU,mS,vs,vg,T,eps1_tol,eps2_tol,maxIterations,model);
    end	
  else
    %[mB,vg_b,mSigmaUt,i,LLnew,LR_stat,LR_prob, noConvergence] = MLEstSVECM_svec_var(mSigmaU, mS,vs,vg,T,eps1_tol, eps2_tol, DegreeofOverIdent,maxIterations,model);
    [mB,vg_B,mSigmaUt,i,LLnew,noConvergence]=MLEstSVECM_svec_var(mSigmaU,mS,vs,vg,T,eps1_tol,eps2_tol,maxIterations,model);

  end %	/* end iCorr	*/
end;	% /* end i_ident*/

mCB_point = mC1*mB;
mB_point  = mB;
vg_BS 	  = vg_b;

%/* Std. deviations and t-ratios */
% 
% m_se_B={};
% m_tv_B={};
% m_se_mCB={};
% m_tv_mCB={};
% 
% /* Bootstrap std deviations */
% if BS_int;
%   
%   {m_se_B,m_se_mCB,m_tv_B,m_tv_mCB} = 
%   BootstrapStdErr_svec_var(var,beta,beta_d,bootRep,seed,mB_Res,mC1_Res,
%   vg_bs,T,K,mB_point,mCB_point,eps1_tol, eps2_tol,DegreeofOverIdent, maxIterations);
% 	
% endif;
% 
% 
% 
% OutputResultsLR_svec_var(mB,mSigmaUt,i,LLnew,LR_stat,LR_prob,DegreeofOverIdent,T,noConvergence, maxIterations,vg,model, 
% i_ident,iCorr, i_iRT,i_itercorr, i_coCorr,vg_corr,mCB_point, nResB, nResC1,BS_int,m_se_B,m_tv_B,m_se_mCB,m_tv_mCB,fname);
% 
% 


