% Computes IRF for the following model:
% X(it)=A(L)X(it-1)+lam*F(t)+u(it)
% where F(t)=B(L)F(t-1)+v(t)
% Shock to v(t), IRs of F(t) come from irfsim.m
% Igor Masten, 17/11/2011 
function [impx2]=irfsim_flag(bar,bfecm,imp,p,flags,nimp)

%bar = bar';
%bfecm = bfecm';
nf=size(imp,2);
implag = zeros(nimp+1,(flags+1)*nf);
for jj = 0:flags;
    implag(jj+1:end,jj*nf+1:(jj+1)*nf)=imp(1:end-jj,:);
end
n1=size(bfecm,1);
impx2=NaN(nimp+1,n1);

for j=1:n1
    lx = zeros(1,p);
    b = [bar(j,:)'; bfecm(j,:)'];
    for i=1:nimp+1
        xregsim=[lx implag(i,:)];
        impx2(i,j)=xregsim*b;
        lx = [impx2(i,j),lx(:,1:p-1)];
    end
end

