% Computes IRF for the following model:
% X(it)=A(L)X(it-1)+lam(L)*F(t)+u(it)
% where F(t)=B(L)F(t-1)+v(t)
% Shock to v(t), IRs of F(t) come from irfsim.m
% Igor Masten, 15/6/2013 
function [impx1]=irfsim_LRres_ecm_flag(beta,bar,bfecm,imp,p,flags,nimp)
% imp are responses of  dF and dG

Fsim = cumsum(imp);
% implag = lagmatrix(imp,0:flags);
nf=size(imp,2);
implag = zeros(nimp+1,(flags+1)*nf);
for jj = 0:flags;
    implag(jj+1:end,jj*nf+1:(jj+1)*nf)=imp(1:end-jj,:);
end
n1=size(bfecm,1);
xirsim = NaN(nimp+1,n1);
impx1=NaN(nimp+1,n1);
ecmir=NaN(nimp+1,n1);
ecmir(1,:)=zeros(1,n1);
for j=1:n1
    b = [bar(j,:)'; bfecm(j,:)'];
    lx = zeros(1,p);
    for i=1:nimp+1
        xregsim=[lx ecmir(i,j) implag(i,:)];
        impx1(i,j)=xregsim*b;
        lx = [impx1(i,j),lx(:,1:p-1)];
        if i==1
            xirsim(i,j)=impx1(i,j);
        else
            xirsim(i,j)=xirsim(i-1,j)+impx1(i,j);
        end
        ecmir(i+1,j)=xirsim(i,j)-Fsim(i,:)*beta(:,j);
    end
end
impx1 = xirsim; % levels
