% Generates IRs with fecm, lags of dX and lags of dF and dG
% The ecm computed also with G
% y = T x K matrix of dependent variables
% x = T x N1 (N1 <= N) matrix of series of interest
% k = number of factors
% shock = K x 1 vector of initial impulse
% nir = number of periods in the IRF
% nrep1 = number of bootstrap replications -- factors
% nrep2                                    -- parameters
% xindex specifies elements of x we want impulse responses
% IDENTIFICATION OF MP SHOCKS FROM DIFFERENCES OF I(1) FACTORS
% The procedure here with factors and identification is the following:
% 1) Estimate factors from levels and rotate
% 2) Difference the I(1) factors and add to I(0) factors estimated from
% levels
% 3) Identify MP shocks from differences and compute IRs
% 3) Cumulate the IRs of I(1) shocks
% 4) Use in the FECM to get IRs of Xs
% Igor Masten, 15.6.2013
function [impest,impxest]=ir_ecm_LRres_flags_alldiff_bn(x1,x2,F,lags,arlags,flags,xindex,nf1,omegast,shock,nir)
x1=x1-repmat(mean(x1),size(x1,1),1);
x2=x2-repmat(mean(x2),size(x2,1),1);

Forig = F;       
dx1 = diff(x1);
x=[x1,x2];
p=lags;
[T,N]=size(x);
n1=size(x1,2);
n2=size(x2,2);
beta = olssvd(x1,F); %factor loadings, cointegration coefficients
ecm = x1 - F*beta; 
ecm = ecm(1:end-1,:); % ecm enters lagged 1 period

% Impulse responses

% [betaF,alpha,Gamma,A,SigmaU,errors,ec]= JohNoDet(F,nf1,p-1);
[betaF,alpha,Gamma,A,SigmaU,errors,ec]= JohResConst(F,nf1,p-1); 
b=vec2varResConst(betaF,alpha,Gamma,p-1);
b=b';

% IRs of the levels of factors obtained from the VECM parameters
impest = irfsim_noc(b,omegast,shock,p,nir);
% dFi1sim = diff(impest);
% dFi1sim = [impest(1,:);dFi1sim];

impest1 = diff(impest);
impest1 = [impest(1,:);impest1];
impest2=impest1;

% -------------------------- %
%  IRs point estimate of x1  %
% -------------------------- %
F = Forig;
% dFi1=diff(F(:,1:nf1));
dF = diff(F);
G=dF;

% Step 3: Get coefficient for generating IRs

bar1=NaN(n1,arlags);
bar2=NaN(n2,arlags);
start = max([arlags lags flags])+1;
ecmt = ecm(start:end,:);
dx1t = dx1(start:end,:);
x2 = x2(2:end,:);
x2t = x2(start:end,:);
% dFt = dF(start:end,:);
% Gt = G(start:end,:);
dFlag = lagmatrix(dF,0:flags); % current and lagged values of dF and dG
dFlagt = dFlag(start:end,:);
Glag = lagmatrix(G,0:flags);
Glagt = Glag(start:end,:);

% Coefficients for dx1 eqs

    bx1=NaN(n1,size(dFlagt,2)+1); %+1 for the ecm term
    for i = 1:n1
        xi=dx1t(:,i);
        xilag=lagmatrix(dx1(:,i),1:arlags);
        xilag=xilag(start:end,:);
        xireg=[xilag ecmt(:,i) dFlagt];
        bb = (xireg'*xireg)\(xireg'*xi);
        bar1(i,:)=bb(1:arlags,:)'; 
        bx1(i,:)=bb(arlags+1:end,:)';
    end

% Coefficients for x2 eqs

    bx2=NaN(n2,size(Glagt,2));
    for i = 1:n2
        xi=x2t(:,i);
        xilag=lagmatrix(x2(:,i),1:arlags);
        xilag=xilag(start:end,:);
        xireg=[xilag Glagt];
        bb = (xireg'*xireg)\(xireg'*xi);
        bar2(i,:)=bb(1:arlags,:)'; 
        bx2(i,:)=bb(arlags+1:end,:)';
    end

% Step 4: IRs of X
    % dx1 eqs
    impx1est=irfsim_LRres_ecm_flag(beta,bar1,bx1,impest1,arlags,flags,nir); % impest1 are IRs of all(!) factors in differences
    % x2 eqs
    impx2est = irfsim_flag(bar2,bx2,impest2,arlags,flags,nir);

impxest = [impx1est,impx2est];
impxest = impxest(:,xindex);
