% Estimates FAVAR residuals
function [bar1,bar2,bx1,bx2,ufavar]=getFAVARparam(x1,x2,F,arlags,flags)
x1=x1-repmat(mean(x1),size(x1,1),1);
x2=x2-repmat(mean(x2),size(x2,1),1);

dx1 = diff(x1);
n1=size(x1,2);
n2=size(x2,2);

dF = diff(F);
G = dF;

bar1=NaN(n1,arlags);
bar2=NaN(n2,arlags);
start = max([arlags flags])+1;
dx1t = dx1(start:end,:);
x2 = x2(2:end,:);
x2t = x2(start:end,:);
dFlag = lagmatrix(dF,0:flags); % current and lagged values of dF and dG
dFlagt = dFlag(start:end,:);
Glag = lagmatrix(G,0:flags);
Glagt = Glag(start:end,:);

% dx1 eqs
bx1=NaN(n1,size(dFlagt,2));
ufecm1=NaN(size(dx1t));
for i = 1:n1
    xi=dx1t(:,i);
    xilag=lagmatrix(dx1(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag dFlagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm1i = xi - xireg*bb;
    bar1(i,:)=bb(1:arlags,:)'; 
    bx1(i,:)=bb(arlags+1:end,:)';
    ufecm1(:,i)=ufecm1i;
end

% x2 eqs
bx2=NaN(n2,size(Glagt,2));
ufecm2=NaN(size(x2t));
for i = 1:n2
    xi=x2t(:,i);
    xilag=lagmatrix(x2(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag Glagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm2i = xi - xireg*bb;
    bar2(i,:)=bb(1:arlags,:)'; 
    bx2(i,:)=bb(arlags+1:end,:)';
    ufecm2(:,i)=ufecm2i;
end
ufavar = [ufecm1,ufecm2];
