% Generates panel as if FAVAR were the DGP i.e. no ecm.
% Block bootstrap of idiosyncratic components
% Igor Masten, Jan 2016
% 
function [x,dx]=favar_gen_panel_flags_alldiff_bn(bx1,bx2,bar1,bar2,ufecm,F,dF,p,flags,bsize,x1init,x2init)

G=dF;
dFlag = lagmatrix(dF,0:flags);
dFlag = dFlag(flags+1:end,:);
Glag = lagmatrix(G,0:flags);
Glag = Glag(flags+1:end,:);

T=size(dFlag,1);
[Tt]=size(ufecm,1);

%Sample indices
nblocks = ceil(T./bsize);
n1 = size(bx1,1);
n2 = size(bx2,1);
ufecm1=ufecm(:,1:n1);
ufecm2=ufecm(:,n1+1:end);

ind=NaN(bsize*nblocks,1);
for j=1:nblocks
    ii = 1+(Tt-bsize-1)*rand(1);
    ii = round(ii);
    iiseq=ii:ii+bsize-1;
    iiseq=iiseq';
    ind(bsize*(j-1)+1:bsize*j)=iiseq;
end
ind=ind(bsize*nblocks-T+1:end,:);
ufecm1st=ufecm1(ind,:);
ufecm1st = ufecm1st-repmat(mean(ufecm1st),size(ufecm1st,1),1);
ufecm2st=ufecm2(ind,:);
ufecm2st = ufecm2st-repmat(mean(ufecm2st),size(ufecm2st,1),1);

% dx1 equations
xreg = NaN(T,size(dFlag,2)+p);
dx1 = NaN(T,n1);
x1 = NaN(T,n1);

for j=1:n1
    b = [bar1(j,:)'; bx1(j,:)'];
    lx = x1init(:,j)';

    for i=1:T
        xreg(i,:)=[lx dFlag(i,:)];
        dx1(i,j)=xreg(i,:)*b + ufecm1st(i,j);
        lx = [dx1(i,j),lx(:,1:p-1)];
        if i==1
            x1(i,j)=dx1(i,j);
        else
            x1(i,j)=x1(i-1,j)+dx1(i,j);
        end
    end
end
dx1=standardize(dx1);
x1=cumsum(dx1);

% x2 equations
xreg = NaN(T,size(Glag,2)+p);
x2 = NaN(T,n2);
for j=1:n2
    b = [bar2(j,:)'; bx2(j,:)'];
    lx = x2init(:,j)';
    for i=1:T
        xreg(i,:)=[lx Glag(i,:)];
        x2(i,j)=xreg(i,:)*b + ufecm2st(i,j);
        lx = [x2(i,j),lx(:,1:p-1)];
    end
end
x2=standardize(x2);

% Collect
x = [x1,x2]; 
dx=[dx1,x2];

