% The model here is as in bmm5. Lags of factors included in Xs eqs.
% The ecm is computed also with G
% In X2 eqs G(t)
% Igor Masten, 18.12.2015
function [beta,bx1,bx2,bar1,bar2,ufecm,dF,F]=fac_estim_MP_flags_bn(y,x1,x2,dx,lags,arlags,flags,slowindex,nf)
% demean x1 and x2
x1=x1-repmat(mean(x1),size(x1,1),1);
x2=x2-repmat(mean(x2),size(x2,1),1);

x=dx; %because estimation of factors in differences
% x=[x1,x2];
%p=lags; % VAR lags
[T,N]=size(x);
n1=size(x1,2);
n2=size(x2,2);


[F,Lf]=extract_i0(x,nf); % Real trend in differences
xslow=x(:,slowindex);
[Fslow,Lfslow]=extract(xslow,nf);
% ensure unit variance of dF
% F = cumsum(F);
% Fslow = cumsum(Fslow);
% F = standardize(F);
% Fslow = standardize(Fslow);

% Rotate factors
Fr = facrot(F,y(:,end),Fslow);
Fr = cumsum(Fr); 
Fr = standardize(Fr);
fy=[Fr,y]; %rotated factors, these are nonstationary
F=fy;
dF = diff(F);
dF=[F(1,:);dF];

G = dF; % ALL factors in differences enter the x2 equations, this is different than in the original case

beta = olssvd(x1,F); %factor loadings, cointegration coefficients
ecm = x1 - F*beta;
ecm = ecm(1:end-1,:); % ecm enters lagged 1 period

bar1=NaN(n1,arlags);
bar2=NaN(n2,arlags);
start = max([arlags lags flags])+1;
ecmt = ecm(start:end,:);
dx1 = diff(x1);
dx1t = dx1(start:end,:);
x2 = x2(2:end,:);
x2t = x2(start:end,:);
G=G(2:end,:);
Glag = lagmatrix(G,0:flags);
Glagt = Glag(start:end,:); 
dF = dF(2:end,:);
dFlag = lagmatrix(dF,0:flags); % current and lagged values of dF and dG
dFlagt = dFlag(start:end,:);
% Parameters for dX1 equations

bx1=NaN(n1,size(dFlagt,2)+1); %+1 for the ecm term + 
ufecm1=NaN(size(dx1t));
for i=1:n1;
    xi=dx1t(:,i);
    xilag=lagmatrix(dx1(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag ecmt(:,i) dFlagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm1i = xi - xireg*bb;
    bar1(i,:)=bb(1:arlags,:)'; 
    bx1(i,:)=bb(arlags+1:end,:)';
    ufecm1(:,i)=ufecm1i;
end

% Parameters for X2 equations
bx2=NaN(n2,size(Glagt,2));
ufecm2=NaN(size(x2t));
for i = 1:n2
    xi=x2t(:,i);
    xilag=lagmatrix(x2(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag Glagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm2i = xi - xireg*bb;
    bar2(i,:)=bb(1:arlags,:)'; 
    bx2(i,:)=bb(arlags+1:end,:)';
    ufecm2(:,i)=ufecm2i;
end

ufecm = [ufecm1,ufecm2];

