% The model here is as in bmm5. Lags of factors included in Xs eqs.
% The ecm is computed also with G
% In X2 eqs G(t)
% Igor Masten, 15.6.2013
function [beta,bx1,bx2,bar1,bar2,ufecm,dF,F]=fac_estim_LRres_alldiff_flags(x1,x2,lags,arlags,flags,realindex,nominalindex,nf,nf1,nf1real)
dx1 = diff(x1);
x=[x1,x2];
p=lags; % VAR lags
xreal=x(:,realindex);
xnominal=x(:,nominalindex);
[T,N]=size(x);
n1=size(x1,2);
n2=size(x2,2);
nf0=nf-nf1; % # I(0) factors

% [Freal,Lfreal]=extract(x,nf1real); % Real trend
% u01=x-Freal*Lfreal';
% u0nom=u01(:,nominalindex);
% u0real=u01(:,realindex);
% [Fnom,Lfnom]=extract(u0nom,nf1-nf1real); % Nominal trend
% u0stat=u0nom-Fnom*Lfnom';
% u0stat = [u0real u0stat]; 
% [Fstat,Lfstat]=extract(u0stat,nf-nf1); %Stationary factors
% F = [Freal,Fnom,Fstat];
% Lfnomres=[zeros(N-size(Lfnom,1),nf1-nf1real);Lfnom]; % Loading to nominal factors padded by zeros
% Lf = [Lfreal, Lfnomres, Lfstat];

[Freal,Lfreal]=extract(x,nf1real); % Real trend in differences
u01=x-Freal*Lfreal';
u0nom=u01(:,nominalindex);
u0real=u01(:,realindex);
[Fnom,Lfnom]=extract(u0nom,nf-nf1real); % Nominal factors, the remaining factors. 
u0stat=u0nom-Fnom*Lfnom';
u0stat = [u0real u0stat]; 
F = [Freal,Fnom];
dF=diff(F);
dF=standardize(dF);
F = cumsum(dF);

Fi1 = F(:,1:nf1);
G = F(:,nf1+1:end);
% G = G(2:end,:);

x1 = x1(2:end,:);
x2 = x2(3:end,:);
dF=dF(2:end,:);
G=G(2:end,:);
dx1 = dx1(2:end,:);

bx = olssvd(x1,F); %factor loadings
% cointegration coefficients
% beta = bx(1:nf1,:);
beta = bx;
% ecm = x1 - Fi1*beta;
ecm = x1 - F*beta;
ecm = ecm(1:end-1,:); % ecm enters lagged 1 period

% gen stationary factors, i.e diff F and add to G
%dFi1 = diff(Fi1);
% dF = diff(F);
%g = [dFi1,G];

bar1=NaN(n1,arlags);
bar2=NaN(n2,arlags);
start = max([arlags lags flags])+1;
ecmt = ecm(start:end,:);
dx1t = dx1(start:end,:);
%gt = g(start:end,:);
% x2 = x2(2:end,:);
x2t = x2(start:end,:);
%g2 = g(:,nf1+1:end);
Glag = lagmatrix(G,0:flags);
Glagt = Glag(start:end,:); %take only I(0) factors for x2 eqs 
% dFt = dF(start:end,:);
dFlag = lagmatrix(dF,0:flags); % current and lagged values of dF and dG
dFlagt = dFlag(start:end,:);
% Parameters for dX1 equations

bx1=NaN(n1,size(dFlagt,2)+1); %+1 for the ecm term + 
ufecm1=NaN(size(dx1t));
for i=1:n1;
    xi=dx1t(:,i);
    xilag=lagmatrix(dx1(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag ecmt(:,i) dFlagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm1i = xi - xireg*bb;
    bar1(i,:)=bb(1:arlags,:)'; 
    bx1(i,:)=bb(arlags+1:end,:)';
    ufecm1(:,i)=ufecm1i;
end

% Parameters for X2 equations
bx2=NaN(n2,size(Glagt,2));
ufecm2=NaN(size(x2t));
for i = 1:n2
    xi=x2t(:,i);
    xilag=lagmatrix(x2(:,i),1:arlags);
    xilag=xilag(start:end,:);
    xireg=[xilag Glagt];
    bb = (xireg'*xireg)\(xireg'*xi);
    ufecm2i = xi - xireg*bb;
    bar2(i,:)=bb(1:arlags,:)'; 
    bx2(i,:)=bb(arlags+1:end,:)';
    ufecm2(:,i)=ufecm2i;
end

ufecm = [ufecm1,ufecm2];

