% Resamples factors, length of fy + flags presample values needed to
% generate observables with the FECM with factors lags
% igor.masten@ef.uni-lj.si, 19.12.2015
function [fr,initind]=boot_fac_flags_bn(f,b,e,lags,flags)
start = max([lags flags])+1;
lf = lagmatrix(f,1:lags);
% lf = [ones(size(f,1),1) lf];
lft = lf(start:end,:);

[T,k]=size(f);
T=T+flags;
Tt = size(e,1);
initind = round(1+(Tt-1)*rand);
lfi = lft(initind,:); %Initial values for simulation
fr	 = zeros(T+1,size(e,2));

for ii = 1:T+1
    i = round(1+(Tt-1)*rand);
    fi = lfi*b + e(i,:);
    fr(ii,:) = fi;
%     lfi = [1,fi,lfi(:,2:end-k)];
    lfi = [fi,lfi(:,1:end-k)];
end

fr = diff(fr);
fr=(fr-repmat(mean(fr),T,1))./repmat(std(fr),T,1);
fr=cumsum(fr);
% fr=fr(2:end,:);


