% This code implements the long-run restrictions scheme of bmm5 - Journal
% of Applied Econometrics
% Banerjee, A., M. Marcellino and I. Masten: Structural FECM: Cointegration in Large-Scale Structural FAVAR models
% Allows for I(1) idiosyncratic errors, factor extraction from differences
% SFECM LR in the factors VAR
% Igor Masten, January, 2015
% Based on fecm_bbeset_LRres_flags_alldiff_bn_reoder.m
%%
clear;
dirname=pwd;
name='\boundedline';
dirname=[dirname,name];
addpath(dirname);

% -----------------------------------%
%   Estimation parameters etc        %
% -----------------------------------%
K=4; % # of factors
lags=4; %lags for factors VAR
arlags=3; % lags for the AR componente in Xs, used in filtering
flags = 1;
nrep1=1; % on observation equation
nrep2=100; % on VAR equation
nsteps=96;
xlags=1; %Switch for AR component in Xs
xflags=0; % switch for lags of F in X equations, # of F lags equal to arlags
nf=K;
nf1=2; % # of I(1) factors
nf1real = 1; % # of real I(1) factors
Nsim = 100; % # of MC replications
T0=3;
favarCI=0; % 1 for favar CI 0 for fecm CI

% For the long-run restrictions
% K =4
mB_Res = [   -1e12 -1e12   -1e12  0;
             -1e12 -1e12   -1e12  -1e12;
             -1e12 -1e12   -1e12  -1e12;
             -1e12 -1e12   -1e12  -1e12];

 mC1_Res =  [ -1e12     0       0  0; 
              -1e12 -1e12       0  0;
              -1e12 -1e12       0  0;
              -1e12 -1e12       0  0];

% K = 5
% mB_Res = [   -1e12 -1e12   -1e12  -1e12  0;
%              -1e12 -1e12   -1e12  -1e12  0;
%              -1e12 -1e12   -1e12  -1e12 -1e12;
%              -1e12 -1e12   -1e12  -1e12 -1e12;
%              -1e12 -1e12   -1e12   0    -1e12];
% 
%  mC1_Res =  [ -1e12     0       0  0 0; 
%               -1e12 -1e12       0  0 0;
%               -1e12 -1e12       0  0 0;
%               -1e12 -1e12       0  0 0;
%               -1e12 -1e12       0  0 0];
          
% K = 6
% mB_Res = [   -1e12 -1e12   -1e12  -1e12  -1e12  -1e12;
%              -1e12 -1e12   -1e12  -1e12  -1e12  -1e12;
%              -1e12 -1e12   -1e12  -1e12 -1e12   -1e12;
%              -1e12 -1e12   -1e12  0 0 0 ;
%              -1e12 -1e12   -1e12  -1e12 0 0 ;
%              -1e12 -1e12   -1e12  -1e12 -1e12  0 ];
% 
% % mB_Res = [   -1e12 -1e12   -1e12  -1e12  0  0;
% %              -1e12 -1e12   -1e12  -1e12  0  0;
% %              -1e12 -1e12   -1e12  -1e12 -1e12   0;
% %              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 ;
% %              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 ;
% %              -1e12 -1e12   -1e12  0 -1e12  -1e12 ];
% 
% 
%  mC1_Res =  [ -1e12     0       0  0 0 0; 
%               -1e12 -1e12       0  0 0 0;
%               -1e12 -1e12       0  0 0 0;
%               -1e12 -1e12       0  0 0 0;
%               -1e12 -1e12       0  0 0 0;
%               -1e12 -1e12       0  0 0 0]; 
% K=7
% mB_Res = [   -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 -1e12;
%              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 -1e12;
%              -1e12 -1e12   -1e12  0 0 0 0;
%              -1e12 -1e12   -1e12  -1e12 0 0 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12 0 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12  -1e12 -1e12 ];
% 
% 
%  mC1_Res =  [ -1e12     0       0  0 0 0 0; 
%               -1e12 -1e12       0  0 0 0 0 ;
%               -1e12 -1e12       0  0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0];          

% K=8
% mB_Res = [   -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 -1e12 -1e12;
%              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 -1e12 -1e12;
%              -1e12 -1e12   -1e12   0    0       0    0      0;
%              -1e12 -1e12   -1e12  -1e12 0 0 0 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12 0 0 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 0 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12 -1e12 -1e12 0;
%              -1e12 -1e12   -1e12  -1e12 -1e12  -1e12 -1e12 -1e12];
% 
% 
%  mC1_Res =  [ -1e12     0       0  0 0 0 0 0; 
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0;
%               -1e12 -1e12       0  0 0 0 0 0]; 
%------------------------------------------------------------------------%

% -----------------------------------%
% Load data and transformation codes %
% -----------------------------------%
load('USrealvec.mat');
load('USslowvec.mat');
load('UStcodevec.mat');
name = 'newUSdatatr_i0_pi1_reorder.txt';
data_i0 = load(name);
data_i0_est=data_i0;
name = 'newUSdatatr_i1_pi1_reorder.txt';
data_i1 = load(name);


data_i1 = data_i1(T0:end,:);
data_i0 = data_i0(T0-1:end,:);
data_i0_est = data_i0_est(T0-1:end,:);
data_i0_orig = data_i0;
data_i1_orig = data_i1;
% Ratio of standard deviation for scaling impulse responses.
stdratio = std(data_i1,1)./std(data_i1,1);
stdratio = stdratio';
stdX = std(data_i1,1);
%------------------------------------------------------------------------%

[T,N]=size(data_i0);

% -----------------------------------%
%       Standardize data             %
% -----------------------------------%
data_i1=(data_i1-repmat(mean(data_i1,1),T,1))./repmat(std(data_i1,1),T,1);
data_i0=(data_i0-repmat(mean(data_i0,1),T,1))./repmat(std(data_i0,1),T,1);
data_i0_est=(data_i0_est-repmat(mean(data_i0_est,1),T,1))./repmat(std(data_i0_est,1),T,1);

% -----------------------------------%
% Specify slow, response vars, etc.  %
% -----------------------------------%
 xindex=[6;74;108;111;56;54; 65;73 ;95;3;4;10;11;98;20; 90;40; 50;61]; % with variables with tcode=1 ordered last and tcode=2 ordered before them
stdX=stdX(:,xindex);
stdX = repmat(stdX,nsteps,1);
slowindex=zeros(sum(slowvec),1);
realindex=zeros(sum(realvec),1);
fastindex=zeros(N-length(slowindex),1);
nominalindex = zeros(N-length(realindex),1);

j=0; jj=0;
 for i=1:N
     if slowvec(i,:)==1
         j=j+1;
         slowindex(j,:)=i;
     else
         jj=jj+1;
         fastindex(jj,:)=i;
     end
 end
 
 j=0; jj=0;
 for i=1:N
     if realvec(i,:)==1
         j=j+1;
         realindex(j,:)=i;
     else
         jj=jj+1;
         nominalindex(jj,:)=i;
     end
 end
 
% Reorder such that I(1) first and I(0) second
tcodes = tcodevec;
intcode = zeros(size(tcodes));
for ii = 1:size(tcodes,1);
    if tcodes(ii,:)>=5;
        intcode(ii,:)=1;
    elseif tcodes(ii,:)==2; % uncomment when treating interest rates as I(1)
        intcode(ii,:)=1;
    end
end
statcode=1-intcode;
intcode=logical(intcode);
statcode = logical(statcode);

varindex = 1:size(tcodes,1);
varindex=varindex';
intvarindex = varindex(intcode); %index of I(1) vars
statvarindex = varindex(statcode); %index of I(0) vars
 
% Block size
%  bsize = round(T^(1/3));
bsize=1;

varnames={'IP','CPI','3m TREASURY BILLS','5y TREASURY BONDS','MONEY BASE','M2',...
        'EXCH RATE YEN','COMMODITY PR IND','CAPACITY UTIL RATE',...
        'PERSONAL CONS','Real M&T sales','IP DURABLES','IP NONDURABLE','UNEMPLOYMENT','EMPLOYMENT','AVG HOURLY EARNINGS',...
        'HOUSING STARTS','ORDERS DUR GOODS','S&P500'};

    
%------------------------------------------------------------------------%
% Permanent real shock
shock=[0.01, zeros(1,nf-1)];
shock=shock';

x1 = data_i1(:,intvarindex); 
x2 = data_i1(:,statvarindex);

n1 = size(x1,2);

% differences in new order
dx1 = data_i0(:,intvarindex); 
dx2 = data_i0(:,statvarindex);
dx = [dx1,dx2];
x1=cumsum(dx1);
x2=dx2;
% x1 = data_i1(:,intvarindex); 
% x2 = data_i1(:,statvarindex);
x = [x1,x2];
dx_est=data_i0_est;

% Estimate factors from differences
[beta,bx1,bx2,bar1,bar2,ufecm,dF,F]=fac_estim_LRres_alldiff_flags_bn(x1,x2,dx_est,lags,arlags,flags,realindex,nominalindex,nf,nf1,nf1real);

ufecm=ufecm-repmat(mean(ufecm),size(ufecm,1),1);
B=svecmB(mB_Res,mC1_Res,F,nf-nf1,lags);

% Get FAVAR residuals
[bar1f,bar2f,bx1f,bx2f,ufavar]=getFAVARparam(x1,x2,F,arlags,flags);

ufavar=demean(ufavar);


[FYirfecm,Xirfecm]=ir_ecm_LRres_flags_alldiff_bn(x1,x2,F,lags,arlags,flags,xindex,nf1,B,shock,nsteps-1);
Xirfecm = Xirfecm.*stdX;
[FYirfavar,Xirfavar]=ir_LRres_flags_alldiff_bn(x1,x2,F,lags,arlags,flags,xindex,nf1,B,shock,nsteps-1); % error correcton among factors not taken into account in the FAVAR
Xirfavar = Xirfavar.*stdX;

n=size(Xirfecm,2);

Xirfecm0 = Xirfecm;
Xirfavar0 = Xirfavar;
FYirfecm0 = FYirfecm;
FYirfavar0 = FYirfavar;

s=1:nsteps;s=s'; z=zeros(nsteps,1);	% to plot level zero

%% Monte Carlo
N=size(xindex,1);

% Define matrices for simulation trials
Xfecm_mc = NaN(nsteps,N,Nsim);
Xfavar_mc = NaN(nsteps,N,Nsim);
FYfecm_mc = NaN(nsteps,K,Nsim);
FYfavar_mc = NaN(nsteps,K,Nsim);

 % Begin looping
 T = size(x,1);
% compute parameters and residuals of factors fecm for bootstrap
[betaF,alpha,Gamma,A,SigmaU,errors,ec]= JohNoDet(F,nf1,lags-1);
A=vec2var(betaF,alpha,Gamma,lags-1);
A=A';
errors=errors-repmat(mean(errors),size(errors,1),1);
 for i = 1:Nsim;
     % Step 1: Resample factors
     [Fr,initind]=boot_fac_flags_bn(F,A,errors,lags,flags); % Here lenghth of Fr is T+flags, because of initial values for generating X
     push = max([lags flags]); 
     initind = initind+push-1;
     x1init = x1(initind-arlags+1:initind,:);
     x2init = x2(initind-arlags+1:initind,:);
     Fi1r = Fr(:,1:nf1);
     Gr = Fr(:,nf1+1:end);
     dFi1r = diff(Fi1r);
     dFr = diff(Fr);


     Fr = Fr(2:end,:);
     Br=svecmB(mB_Res,mC1_Res,F,nf-nf1,lags);
     % Step 2: Gen panel from fyr and block boostrap on u
     if favarCI==1
         [xr,dxr]=favar_gen_panel_flags_alldiff_bn(bx1f,bx2f,bar1f,bar2f,ufavar,Fr,dFr,arlags,flags,bsize,x1init,x2init); %FAVAR DGP
     else
        [xr,dxr]=fecm_gen_panel_flags_alldiff_bn(beta,bx1,bx2,bar1,bar2,ufecm,Fr,dFr,arlags,flags,bsize,x1init,x2init); %FECM DGP
     end
     x1r = xr(:,1:n1); 
     x2r = xr(:,n1+1:end);
     xirr=dxr(:,xindex);
     Fr = Fr (flags+1:end,:);
   % Estimate IRs using fecm
     [FYirfecm,Xirfecm]=ir_ecm_LRres_flags_alldiff_bn(x1r,x2r,Fr,lags,arlags,flags,xindex,nf1,Br,shock,nsteps-1);
     Xirfecm = Xirfecm.*stdX;
     Xfecm_mc(:,:,i)=Xirfecm;
     FYfecm_mc(:,:,i)=FYirfecm;
     % Estimate IRs using favar
     [FYirfavar,Xirfavar]=ir_LRres_flags_alldiff_bn(x1r,x2r,Fr,lags,arlags,flags,xindex,nf1,Br,shock,nsteps-1);
     Xirfavar = Xirfavar.*stdX;
     Xfavar_mc(:,:,i)=Xirfavar;
     FYfavar_mc(:,:,i)=FYirfavar;
   
 end
%%
 
Xfecm_mc = sort(Xfecm_mc,3);
FYfecm_mc = sort(FYfecm_mc,3);
Xfavar_mc = sort(Xfavar_mc,3);
FYfavar_mc = sort(FYfavar_mc,3);
Xfecm_mc = Xfecm_mc(:,:,[.05*Nsim 0.5*Nsim  .95*Nsim]);
FYfecm_mc = FYfecm_mc(:,:,[.05*Nsim 0.5*Nsim  .95*Nsim]);
Xfavar_mc = Xfavar_mc(:,:,[.05*Nsim 0.5*Nsim  .95*Nsim]);
FYfavar_mc = FYfavar_mc(:,:,[.05*Nsim 0.5*Nsim  .95*Nsim]);
 
FYfecm_mc=permute(FYfecm_mc,[2,1,3]);		% equations x nsteps x error bands
Xfecm_mc=permute(Xfecm_mc,[2,1,3]);
FYfavar_mc=permute(FYfavar_mc,[2,1,3]);		% equations x nsteps x error bands
Xfavar_mc=permute(Xfavar_mc,[2,1,3]);

n=size(Xfecm_mc,1);

if favarCI==1
    Xseup = Xfavar_mc(:,:,3)-Xfavar_mc(:,:,2);
    Xselow = Xfavar_mc(:,:,2)-Xfavar_mc(:,:,1);
    FYseup = FYfavar_mc(:,:,3)-FYfavar_mc(:,:,2);
    FYselow = FYfavar_mc(:,:,2)-FYfavar_mc(:,:,1);
    Xbounds = cat(3,Xselow,Xseup);
    Xbounds = permute(Xbounds,[2,3,1]);
    FYbounds = cat(3,FYselow,FYseup);
    FYbounds = permute(FYbounds,[2,3,1]);
    Xfavar_ci = Xfavar_mc;
    Xfavar_ci(:,:,1) = Xirfavar0'-Xselow;
    Xfavar_ci(:,:,2) = Xirfavar0';
    Xfavar_ci(:,:,3) = Xirfavar0'+Xseup;
    FYfavar_ci(:,:,1) = FYirfavar0'-FYselow;
    FYfavar_ci(:,:,2) = FYirfavar0';
    FYfavar_ci(:,:,3) = FYirfavar0'+FYseup;
else
    Xseup = Xfecm_mc(:,:,3)-Xfecm_mc(:,:,2);
    Xselow = Xfecm_mc(:,:,2)-Xfecm_mc(:,:,1);
    FYseup = FYfecm_mc(:,:,3)-FYfecm_mc(:,:,2);
    FYselow = FYfecm_mc(:,:,2)-FYfecm_mc(:,:,1);
    Xbounds = cat(3,Xselow,Xseup);
    Xbounds = permute(Xbounds,[2,3,1]);
    FYbounds = cat(3,FYselow,FYseup);
    FYbounds = permute(FYbounds,[2,3,1]);
    Xfecm_ci = Xfecm_mc;
    Xfecm_ci(:,:,1) = Xirfecm0'-Xselow;
    Xfecm_ci(:,:,2) = Xirfecm0';
    Xfecm_ci(:,:,3) = Xirfecm0'+Xseup;
    FYfecm_ci(:,:,1) = FYirfecm0'-FYselow;
    FYfecm_ci(:,:,2) = FYirfecm0';
    FYfecm_ci(:,:,3) = FYirfecm0'+FYseup;
end

%%
% -----------------------------------%
%       Plot the IRs                 %
% -----------------------------------%
s=1:nsteps; z=zeros(nsteps,1);	% to plot level zero

if favarCI==1
    figure

   subplot(4,5,1)
   plot(s, FYirfecm0(:,1),'k-','LineWidth',1.5);
   hold on;
   ax1=boundedline(s,squeeze(FYfavar_ci(1,:,2)),FYbounds(:,:,1),'--k');
   set(ax1,'LineWidth',1.5);
    plot(s, FYirfecm0(:,1),'k-','LineWidth',1.5);
   plot(s,z,'-k','LineWidth',1);
   hold off;
   legend('FECM','90% conf. int. ','FAVAR','FECMlev');
   set(gca,'XLim',[0 nsteps],'XTick',[0 12 24 36 48 60 72 84 nsteps],'FontSize',8);
   title('Real trend','FontSize',11)

    for i=1:19
       subplot(4,5,i+1)
       ax1=boundedline(s,squeeze(Xfavar_ci(i,:,2)),Xbounds(:,:,i),'--k');
       set(ax1,'LineWidth',1.5);
       hold on;
       plot(s, Xirfecm0(:,i),'k-','LineWidth',1.5);
       plot(s,z,'-k','LineWidth',1);
       hold off;
       set(gca,'XLim',[0 nsteps],'XTick',[0 12 24 36 48 60 72 84 nsteps],'FontSize',8);
       title(varnames(i),'FontSize',11)
    end
else
   figure
   subplot(4,5,1)
   plot(s, FYirfavar0(:,1),'k--','LineWidth',1.5);
   hold on;
   ax1=boundedline(s,squeeze(FYfecm_ci(1,:,2)),FYbounds(:,:,1),'-k');
   set(ax1,'LineWidth',1.5);
   plot(s,z,'-k','LineWidth',1);
   hold off;
   legend('FAVAR','90% conf. int. ','FECM');
   set(gca,'XLim',[0 nsteps],'XTick',[0 12 24 36 48 60 72 84 nsteps],'FontSize',8);
   title('Real trend','FontSize',11)

    for i=1:19
       subplot(4,5,i+1)
       ax1=boundedline(s,squeeze(Xfecm_ci(i,:,2)),Xbounds(:,:,i),'-k');
       set(ax1,'LineWidth',1.5);
       hold on;
       plot(s, Xirfavar0(:,i),'k--','LineWidth',1.5);
       plot(s,z,'-k','LineWidth',1);
       hold off;
       set(gca,'XLim',[0 nsteps],'XTick',[0 12 24 36 48 60 72 84 nsteps],'FontSize',8);
       title(varnames(i),'FontSize',11)
    end
end

