function [beta,alpha,gamma,A,sigma,errors,ec]= JohResConst(data,r,p)
Y = data; 
K = size(Y,2);
dY = diff(Y);
T = size(dY,1);
Tt = T-p; % p is the number of lagged differences
dYlag = lagmatrix(dY,[1:p]);
dYlag = dYlag(p+1:T,:);
X = dYlag;
    
dY = dY(p+1:T,:);
Y1 = Y(p+1:size(Y,1)-1,:); %Lagged levels
Y1 = [Y1,ones(Tt,1)]; % Restricted constant model

% From tall to long
dY = dY';
X = X';
Y1 = Y1';
    
% Johansen procedure
M = eye(Tt)-X'*((X*X')\X);
R0 = dY*M;
R1 = Y1*M;
S00 = R0*R0'/Tt;
S01 = R0*R1'/Tt;
S10 = R1*R0'/Tt;
S11 = R1*R1'/Tt;
[ve, va] = eig(S11);
sqrtS11 = ve*sqrt(va)*ve'; % Square roots of the matrix S11
W = (sqrtS11\S10)*((S00\S01)/sqrtS11);
[ve, va] = eig(W); % Eigenvalues (va) with corresponding eigenvectors (ve)
va = diag(va);
[b,ind]=sort(va); % Sorting the eigenvalues in ascending order
va = b(K-r+2:K+1,1); % Selecting r biggest eigenvalues
ve = ve(:,ind);
ve = ve(:,K-r+2:K+1); % Selecting r eigenvectors associated with r biggest eigenvalues
beta = ve'/sqrtS11; % Cointegrating vectors r#K
%Normalizing the cointegrating vectors
beta = beta';
beta_c = [eye(r),beta(1:r,:)'\beta(r+1:size(beta,1),:)'];
beta = beta_c;
alpha = S01*beta'/(beta*S11*beta'); % Loading matrix
gamma = (dY - alpha*beta*Y1)*X'/(X*X'); % The rest of the parameters.
A = [alpha,gamma];
ec=beta*Y1;
ec=ec';
errors = (dY - alpha*beta*Y1 - gamma*X)';
sigma = errors'*errors/Tt;

