% /*
% **	Usage: mC1 = ComputeC1(alpha, beta, mGamma);
% **
% **	Purpose: Compute long run impact matrix for cointegrated VAR models
% **
% **	Input:		alpha:	 K x r matrix of loading coefficients
% **
% **				beta: 	 K x r matrix of cointegration coefficients related to stochastic variables
% **
% **				mGamma:  K x K(p-1) matrix coefficient matrix of lagged differences 
% **				  		 \Gamma = \Gamma_1 ... \Gamma_{p-1}  
% **
% **	Ouput: 		mC1:	 K x K matrix, reduced form long run impact matrix
% */

function mC1=ComputeC1_svec_var(alpha, beta, mGamma)

% K = size(alpha,1);
% if ismiss(mGamma) == 1;			/* check whether lags are present*/ 
% 	mGa = eye(K);
% else;
mGa = ComputeMeanLag_svec_var(mGamma);
% end;   
		
%  orthogonal complement of beta 
beta_o = null(beta');	

% if scalerr(beta_o) == 1;  
%  "";  "There is no null space of beta!"; /* check whether the 		*/
% end; 								 /* null space exists  		*/   	   	   	    	 

% /* orthogonal complement of alpha  */

alpha_o = null(alpha');	
	 
% 	if scalerr(alpha_o) == 1;  
% 	"";  "There is no null space of alpha!"; /* check whether the  */
%    	endif;    				 				 /* null space exists  */

mC1 = beta_o*inv(alpha_o'*mGa*beta_o)*alpha_o'; % total impact matrix C(1) */