new;
cls;

/*Bailey, N., Kapetanios, G. and Pesaran, H. P. (2015). Exponent of Cross-sectional Dependence: Estimation and Inference. 
                                                   Journal of Applied Econometrics, forthcoming.*/
/* Experiment A: Serially uncorrelated factors (mu=1). Table A1 */

#include code_ord_holm.src;

repl=2000;
rndseed 12345;

ttit=100|200|500;
nnin=50|100|200|500|1000;
allbias={};
allrmse={};
allsize={};
allpowerp={};
allpowerm={};

allbiasm={};
allrmsem={};
allsizem={};
allpowerpm={};
allpowermm={};

tit=1;
do while tit<=rows(ttit);
t=ttit[tit];
nin=1;
do while nin<=rows(nnin);
n=nnin[nin];

/* Preliminaries */
a_sizet=0.05;
a_size=0.1;
factor=2;
mu_c=0; /* mean of constant across N */
rho1=0.0; /* Structure on factors: choice from 0,0.5,0.9 */
rho_l=0.0;
sigma_f=1; /* standard deviation of f*/
mu=sqrt(1);
mu2=sqrt(0.75);  /* Adjusts the mean of factor loadings */
u_mu2=mu2+0.2;
l_mu2=mu2-0.2;
scale_sigma_e=3/4; 

/* Structure on errors - AR */
phi=rndu(1,n);

/* Construct constant */
const=mu_c+rndn(n,1);
c_v=diagrv(eye(n),const);

alfa=seqa(0.7,0.05,7);
alfa2=alfa./(1.5); /*a_2=a_1/2*/
alfa_h1=alfa+0.05;
alfa_h1[rows(alfa_h1),1]=alfa[rows(alfa),1]-0.05;
alfa_h2=alfa-0.05;
alfa_h2[1,1]=alfa[1,1]+0.05;

sto_bias_a_tild=zeros(repl,rows(alfa)); /* alpha estimates */
sto_bias_a_ntild=zeros(repl,rows(alfa)); /* alpha estimates */
sto_bias_a_ch=zeros(repl,rows(alfa)); /* alpha estimates */
sto_bias_a_nch=zeros(repl,rows(alfa)); /* alpha estimates */

sto_mse_a_tild=zeros(repl,rows(alfa)); /* alpha estimates */
sto_mse_a_ntild=zeros(repl,rows(alfa)); /* alpha estimates */
sto_mse_a_ch=zeros(repl,rows(alfa)); /* alpha estimates */
sto_mse_a_nch=zeros(repl,rows(alfa)); /* alpha estimates */

sto_d_a_tild=zeros(repl,rows(alfa)); /* Size */
sto_d_a_ntild=zeros(repl,rows(alfa)); /* Size */
sto_d_a_ch=zeros(repl,rows(alfa)); /* Size */
sto_d_a_nch=zeros(repl,rows(alfa)); /* Size */

sto_p_a_tild=zeros(repl,rows(alfa)); /* Power */
sto_p_a_ntild=zeros(repl,rows(alfa)); /* Power */
sto_p_a_ch=zeros(repl,rows(alfa)); /* Power */
sto_p_a_nch=zeros(repl,rows(alfa)); /* Power */
sto_p_a_tild1=zeros(repl,rows(alfa)); /* Power */
sto_p_a_ntild1=zeros(repl,rows(alfa)); /* Power */
sto_p_a_ch1=zeros(repl,rows(alfa)); /* Power */
sto_p_a_nch1=zeros(repl,rows(alfa)); /* Power */

for o(1,repl,1); /*loop of replications*/

/* GENERAL SETUP */
/* Construction of error term */
/* generate noise with different variances */
v=rndn(2,n);
sigma_e=scale_sigma_e*(1/2+((v[1,.])^2+(v[2,.])^2)/(4/3));
v_prel=rndn(t+50,n);
epsilon=zeros(t+50,n);
for i(1,n,1);
epsilon[.,i]=sqrt(sigma_e[1,i])*v_prel[.,i];
endfor;

/* generate AR(1) errors*/
u=zeros(t+50,n);
for p(2,t+50,1);
 for j(1,n,1);
  u[p,j]=phi[1,j]*u[p-1,j]+sqrt((1-phi[1,j]^2))*epsilon[p,j];
 endfor;
endfor;
u=u[51:t+50,.];

/* Construction of AR(1) factors */
zita=sigma_f*rndn(t+50,factor);
f=zeros(t+50,factor);
for p(2,t+50,1);
f[p,.]=rho1*f[p-1,.]+sqrt((1-rho1^2))*zita[p,.];
endfor;
f=f[51:t+50,.];

/* Construction of V_i's */
v11=rndu(1,n); 
lamda2=l_mu2+(u_mu2-l_mu2)*rndu(1,n);

for m(1,rows(alfa),1);  /*loop of strength of structure*/

mu1=sqrt(mu^2-n^(2*(alfa2[m,1]-alfa[m,1]))*mu2^2);
u_mu1=mu1+0.2;
l_mu1=mu1-0.2;
lamda1=l_mu1+(u_mu1-l_mu1)*v11; 

/* Construction of loadings */
lamda=zeros(factor,n);
/* two factor case */
for i(1,floor(n^alfa[m,1]),1);
lamda[1,i]=lamda1[1,i];
endfor;
for j(floor(n^alfa[m,1])+1,n,1);
lamda[1,j]=rho_l^(j-n^alfa[m,1]);
endfor;
for i(1,floor(n^alfa2[m,1]),1);
lamda[2,i]=lamda2[1,i];
endfor;
for j(floor(n^alfa2[m,1])+1,n,1);
lamda[2,j]=rho_l^(j-n^alfa2[m,1]);
endfor;
lamda_adj=lamda[2,.];
iy=rndu(cols(lamda_adj),1);
h_mix=sorthc(lamda_adj'~iy,2);
lamda[2,.]=(h_mix[.,1])';

/* Dataset */
x=ones(t,n)*c_v+f*lamda+u;

/********** Exponent of cross-sectional dependence ************/
/* Bias and RMSE */
{a_tilde,a_newtilde,m_x_bar_4m,ggg_o,s_frasel,ggg_t,s_fraselt,musqr_thr}=atilde(x,a_size);
{a_ch,a_newch,rej,ggg2,s_frasel2,ggg_t2,s_fraselt2,rej}=acheck(x,a_size);

bias_atild=a_tilde-alfa[m,1];
sto_bias_a_tild[o,m]=bias_atild;
bias_antild=a_newtilde-alfa[m,1];
sto_bias_a_ntild[o,m]=bias_antild;

bias_ach=a_ch-alfa[m,1];
sto_bias_a_ch[o,m]=bias_ach;
bias_anch=a_newch-alfa[m,1];
sto_bias_a_nch[o,m]=bias_anch;

mse_atild=(a_tilde-alfa[m,1])^2;
sto_mse_a_tild[o,m]=mse_atild;
mse_antild=(a_newtilde-alfa[m,1])^2;
sto_mse_a_ntild[o,m]=mse_antild;

mse_ach=(a_ch-alfa[m,1])^2;
sto_mse_a_ch[o,m]=mse_ach;
mse_anch=(a_newch-alfa[m,1])^2;
sto_mse_a_nch[o,m]=mse_anch;

/* Size and Power */
z_a_tild=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_tilde)*s_frasel/(ggg_o-1)))^(-1/2)*2*ln(n)*(a_tilde-alfa[m,1]);

z_a_ntild=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newtilde)*s_fraselt/(ggg_t-1)))^(-1/2)*2*ln(n)*(a_newtilde-alfa[m,1]);

z_a_ch=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_ch)*s_frasel2/(ggg2-1)))^(-1/2)*2*ln(n)*(a_ch-alfa[m,1]);

z_a_nch=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newch)*s_fraselt2/(ggg_t2-1)))^(-1/2)*2*ln(n)*(a_newch-alfa[m,1]);

/* SIZE */
/* H0: a=a_0 */
if (abs(z_a_tild)-1.96)>0;
    size1=1;
  else;
    size1=0;
 endif;
sto_d_a_tild[o,m]=size1;

if (abs(z_a_ntild)-1.96)>0;
    size2=1;
  else;
    size2=0;
 endif;
sto_d_a_ntild[o,m]=size2;
if (abs(z_a_ch)-1.96)>0;
    size3=1;
  else;
    size3=0;
 endif;
sto_d_a_ch[o,m]=size3;

if (abs(z_a_nch)-1.96)>0;
    size4=1;
  else;
    size4=0;
 endif;
sto_d_a_nch[o,m]=size4;

/* POWER */
/* H0: a=a_1 */
z_a_tild1=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_tilde)*s_frasel/(ggg_o-1)))^(-1/2)*2*ln(n)*(a_tilde-alfa_h1[m,1]);

z_a_ntild1=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newtilde)*s_fraselt/(ggg_t-1)))^(-1/2)*2*ln(n)*(a_newtilde-alfa_h1[m,1]);

z_a_ch1=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_ch)*s_frasel2/(ggg2-1)))^(-1/2)*2*ln(n)*(a_ch-alfa_h1[m,1]);

z_a_nch1=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newch)*s_fraselt2/(ggg_t2-1)))^(-1/2)*2*ln(n)*(a_newch-alfa_h1[m,1]);


if (abs(z_a_tild1)-1.96)>0;
    power1=1;
  else;
    power1=0;
 endif;
sto_p_a_tild[o,m]=power1;

if (abs(z_a_ntild1)-1.96)>0;
    power2=1;
  else;
    power2=0;
 endif;
sto_p_a_ntild[o,m]=power2;
if (abs(z_a_ch)-1.96)>0;
    power3=1;
  else;
    power3=0;
 endif;
sto_p_a_ch[o,m]=power3;

if (abs(z_a_nch1)-1.96)>0;
    power4=1;
  else;
    power4=0;
 endif;
sto_p_a_nch[o,m]=power4;

/* H0: a=a_2 */
z_a_tild2=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_tilde)*s_frasel/(ggg_o-1)))^(-1/2)*2*ln(n)*(a_tilde-alfa_h2[m,1]);

z_a_ntild2=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newtilde)*s_fraselt/(ggg_t-1)))^(-1/2)*2*ln(n)*(a_newtilde-alfa_h2[m,1]);

z_a_ch2=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_ch)*s_frasel2/(ggg2-1)))^(-1/2)*2*ln(n)*(a_ch-alfa_h2[m,1]);

z_a_nch2=((1/t)*(m_x_bar_4m-1)+(4/n)*(n^(1-a_newch)*s_fraselt2/(ggg_t2-1)))^(-1/2)*2*ln(n)*(a_newch-alfa_h2[m,1]);

if (abs(z_a_tild2)-1.96)>0;
    power1_1=1;
  else;
    power1_1=0;
 endif;
sto_p_a_tild1[o,m]=power1_1;
if (abs(z_a_ntild2)-1.96)>0;
    power2_1=1;
  else;
    power2_1=0;
 endif;
sto_p_a_ntild1[o,m]=power2_1;
if (abs(z_a_ch2)-1.96)>0;
    power3_1=1;
  else;
    power3_1=0;
 endif;
sto_p_a_ch1[o,m]=power3_1;
if (abs(z_a_nch2)-1.96)>0;
    power4_1=1;
  else;
    power4_1=0;
 endif;
sto_p_a_nch1[o,m]=power4_1;

endfor;
endfor;

m_bias_a_tild=(sumc(sto_bias_a_tild)'/repl)*100;
m_bias_a_ntild=(sumc(sto_bias_a_ntild)'/repl)*100;
m_bias_a_ch=(sumc(sto_bias_a_ch)'/repl)*100;
m_bias_a_nch=(sumc(sto_bias_a_nch)'/repl)*100;

m_mse_a_tild=(sqrt(sumc(sto_mse_a_tild)'/repl))*100;
m_mse_a_ntild=(sqrt(sumc(sto_mse_a_ntild)'/repl))*100;
m_mse_a_ch=(sqrt(sumc(sto_mse_a_ch)'/repl))*100;
m_mse_a_nch=(sqrt(sumc(sto_mse_a_nch)'/repl))*100;

d_a_tild=(sumc(sto_d_a_tild)'/repl)*100;
d_a_ntild=(sumc(sto_d_a_ntild)'/repl)*100;
d_a_ch=(sumc(sto_d_a_ch)'/repl)*100;
d_a_nch=(sumc(sto_d_a_nch)'/repl)*100;

p_a_tild=(sumc(sto_p_a_tild)'/repl)*100;
p_a_ntild=(sumc(sto_p_a_ntild)'/repl)*100;
p_a_ch=(sumc(sto_p_a_ch)'/repl)*100;
p_a_nch=(sumc(sto_p_a_nch)'/repl)*100;

p_a_tild1=(sumc(sto_p_a_tild1)'/repl)*100;
p_a_ntild1=(sumc(sto_p_a_ntild1)'/repl)*100;
p_a_ch1=(sumc(sto_p_a_ch1)'/repl)*100;
p_a_nch1=(sumc(sto_p_a_nch1)'/repl)*100;

allbias=allbias|(m_bias_a_tild|m_bias_a_ch);
allrmse=allrmse|(m_mse_a_tild|m_mse_a_ch);
allsize=allsize|(d_a_tild|d_a_ch);
allpowerp=allpowerp|(p_a_tild|p_a_ch);
allpowerm=allpowerm|(p_a_tild1|p_a_ch1);

allbiasm=allbiasm|(m_bias_a_ntild|m_bias_a_nch);
allrmsem=allrmsem|(m_mse_a_ntild|m_mse_a_nch);
allsizem=allsizem|(d_a_ntild|d_a_nch);
allpowerpm=allpowerpm|(p_a_ntild|p_a_nch);
allpowermm=allpowermm|(p_a_ntild1|p_a_nch1);

nin=nin+1;
endo;
tit=tit+1;
endo;
endd:

/* ***************************** Output ******************************* */
"";
"Table A1: Bias, RMSE, Size and Power for unadjusted Exponent of Cross-sectional Dependence";
"";
"allbias";allbias;
"allrmse";allrmse;
"allsize";allsize;
"allpowerp";allpowerp;
"allpowerm";allpowerm;

end;


