new;
cls;

/*Bailey, N., Kapetanios, G. and Pesaran, H. P. (2015). Exponent of Cross-sectional Dependence: Estimation and Inference. 
                                                   Journal of Applied Econometrics, forthcoming.*/
/* Sub-sections 5.1 and 5.2 of BKP: Cross-country and within country dependence of macro-variables */												   
#include code_ord_holm.src;

/*********** Input Data *******************/
load x_gdp[122,33]="gdp_qq.txt"; /* Real GDP growth data */
load x_dp[123,33]="dp_qq.txt"; /* Inflation data */
load x_deq[122,26]="deq_qq.txt"; /* Real equity prices data */
load x_dep[122,33]="dep_qq.txt"; /* Exchange rates data */

load x_adj[126,96]="ukmacro.txt"; /* UK macro data */
x_uk=x_adj[.,1]~x_adj[.,4:96];

load data1[195,97]="usmacro.txt"; /* US macro data */
trans=ones(14,1)|zeros(2,1)|ones(32,1)|zeros(15,1)|ones(34,1);
trans[88]=0;
trans[69]=0;
data={};
i=1;
do while i<=97;
  if trans[i]==0;
    data=data~trimr(data1[.,i],1,0);
  else;
    data=data~trimr(ln(data1[.,i])-lag(ln(data1[.,i])),1,0);
  endif;
  i=i+1;
endo;
data=real(data);
x_adj=data;
x_us=data[.,1:46]~data[.,48:92]~data[.,94:97];

/*********** Data Preparation *******************/
a_size=0.1;

/* Standardise data */
x_gdpst=standx(x_gdp);
x_dpst=standx(x_dp);
x_deqst=standx(x_deq);
x_depst=standx(x_dep);
x_ukst=standx(x_uk);
x_usst=standx(x_us);

/*********** CD test *************/
{t_gdp,n_gdp,cd_gdp}=CD(x_gdp);
{t_dp,n_dp,cd_dp}=CD(x_dp);
{t_deq,n_deq,cd_deq}=CD(x_deq);
{t_dep,n_dep,cd_dep}=CD(x_dep);
{t_uk,n_uk,cd_uk}=CD(x_uk);
{t_us,n_us,cd_us}=CD(x_us);

/********** Exponent of cross-sectional dependence ************/
{rej,a_gdp,v_f_gdp,rej,rej,ggg_gdp,s_gdp,rej}=atildeall(x_gdpst,a_size);
{rej,a_dp,v_f_dp,rej,rej,ggg_dp,s_dp,rej}=atildeall(x_dpst,a_size);
{rej,a_deq,v_f_deq,rej,rej,ggg_deq,s_deq,rej}=atildeall(x_deqst,a_size);
{rej,a_dep,v_f_dep,rej,rej,ggg_dep,s_dep,rej}=atildeall(x_depst,a_size);
{rej,a_uk,v_f_uk,rej,rej,ggg_uk,s_uk,rej}=atildeall(x_ukst,a_size);
{rej,a_us,v_f_us,rej,rej,ggg_us,s_us,rej}=atildeall(x_usst,a_size);

om_gdp=1.65*((1/t_gdp)*(v_f_gdp)+(4/n_gdp)*(n_gdp^(1-a_gdp)*s_gdp/(ggg_gdp-1)))^(1/2)/(2*ln(n_gdp)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_dp=1.65*((1/t_dp)*(v_f_dp)+(4/n_dp)*(n_dp^(1-a_dp)*s_dp/(ggg_dp-1)))^(1/2)/(2*ln(n_dp)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_deq=1.65*((1/t_deq)*(v_f_deq)+(4/n_deq)*(n_deq^(1-a_deq)*s_deq/(ggg_deq-1)))^(1/2)/(2*ln(n_deq)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_dep=1.65*((1/t_dep)*(v_f_dep)+(4/n_dep)*(n_dep^(1-a_dep)*s_dep/(ggg_dep-1)))^(1/2)/(2*ln(n_dep)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_uk=1.65*((1/t_uk)*(v_f_uk)+(4/n_uk)*(n_uk^(1-a_uk)*s_uk/(ggg_uk-1)))^(1/2)/(2*ln(n_uk)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_us=1.65*((1/t_us)*(v_f_us)+(4/n_us)*(n_us^(1-a_us)*s_us/(ggg_us-1)))^(1/2)/(2*ln(n_us)); /* 90% CI: 1.65, 95% CI: 1.96 */

/* ***************************** Output ******************************* */

"";"";
"Table 1 (Section 5.1 of BKP paper):: CD statistics, Exponents of CSD (alpha) and s.e. ";
"n_gdp";n_gdp;
"t_gdp";t_gdp;
"cd_gdp";cd_gdp;
"a_gdp"; (a_gdp-om_gdp)~a_gdp~(a_gdp+om_gdp);
"";"";
"n_dp";n_dp;
"t_dp";t_dp;
"cd_dp";cd_dp;
"a_dp"; (a_dp-om_dp)~a_dp~(a_dp+om_dp);
"";"";
"n_deq";n_deq;
"t_deq";t_deq;
"cd_deq";cd_deq;
"a_deq"; (a_deq-om_deq)~a_deq~(a_deq+om_deq);
"";"";
"n_dep";n_dep;
"t_dep";t_dep;
"cd_dep";cd_dep;
"a_dep"; (a_dep-om_dep)~a_dep~(a_dep+om_dep);

"";"";
"Table 2 (Section 5.2 of BKP paper):: CD statistics, Exponents of CSD (alpha) and s.e. ";
"n_us";n_us;
"t_us";t_us;
"cd_us";cd_us;
"a_us"; (a_us-om_us)~a_us~(a_us+om_us);
"";"";
"n_uk";n_uk;
"t_uk";t_uk;
"cd_uk";cd_uk;
"a_uk"; (a_uk-om_uk)~a_uk~(a_uk+om_uk);

/* ******************************************************** Procedures ******************************************************* */
/* Standardise data */
proc standx(x);
local n,t,m_x,std_x,x_stand;
t=rows(x);
n=cols(x);
m_x=meanc(x)';
std_x=stdc(x)';
x_stand=zeros(t,n);
for i(1,n,1);
x_stand[.,i]=(x[.,i]-m_x[1,i])/std_x[1,i];
endfor;
retp(x_stand);
endp;

/* Pesaran, M.H. (2015). Testing Weak Cross-sectional Dependence in Large Panels. Econometrics Reviews (forthcoming) */
/* CD test */
proc (3)=CD(x);
local n,t,interc,coef,x_prel,m_x,std_x,little_x,rho_var_bar,cd;
t=rows(x);
n=cols(x);
interc=ones(t,1);
coef=inv(interc'*interc)*interc'*x;
x_prel=x-interc*coef; 
m_x=meanc(x_prel)';
std_x=stdc(x_prel)';
little_x=zeros(t,n); 
for j(1,n,1);
little_x[.,j]=x_prel[.,j]/std_x[1,j];
endfor;
rho_var_bar=(meanc(sumc(little_x').^2)-n)/(n*(n-1));
cd=sqrt((t)/2)*sqrt(n*(n-1))*rho_var_bar;
retp(t,n,cd);
endp;

